/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.items.ItemWaypointCompass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import org.apache.commons.lang3.tuple.Pair;

public class ModelAtlas
implements ISmartItemModel,
IPerspectiveAwareModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:AtlasBook");
    private IBakedModel baseModel;
    private IBakedModel simpleAtlas;
    List<String> simpleParts;
    List<String> modelParts;
    IModel model = null;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };

    public ModelAtlas(IBakedModel model) {
        this.baseModel = model;
        this.modelParts = new ArrayList<String>();
        this.modelParts.add("book");
        this.modelParts.add("compass");
        this.modelParts.add("1");
        this.simpleParts = new ArrayList<String>();
        this.simpleParts.add("book");
    }

    public IBakedModel handleItemState(ItemStack stack) {
        int compass;
        if (this.simpleAtlas == null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/atlas.obj"));
            }
            catch (IOException e) {
                this.model = ModelLoaderRegistry.getMissingModel();
            }
            this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            OBJModel.OBJState partList = new OBJModel.OBJState(this.simpleParts, true, (IModelState)transform);
            this.simpleAtlas = this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, this.textureGetter);
        }
        this.baseModel = this.simpleAtlas;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && tags.func_74764_b("needleAngle") && tags.func_74764_b("savedCompass") && (compass = tags.func_74762_e("savedCompass")) != -1 && this.checkForMatchingCompass(tags, compass)) {
            this.modelParts = new ArrayList<String>();
            this.modelParts.add("book");
            this.modelParts.add("compass");
            String part = "" + this.getCompassNeedlePart(tags.func_74760_g("needleAngle") + 90.0f);
            this.modelParts.add(part);
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/atlas.obj"));
            }
            catch (IOException e) {
                this.model = ModelLoaderRegistry.getMissingModel();
            }
            this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            OBJModel.OBJState partList = new OBJModel.OBJState(this.modelParts, true, (IModelState)transform);
            this.baseModel = this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, this.textureGetter);
        }
        return this;
    }

    private boolean checkForMatchingCompass(NBTTagCompound tags, int compass) {
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack invStack;
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= 6 || (invStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null || !(invStack.func_77973_b() instanceof ItemWaypointCompass) || compass != slot) continue;
            return true;
        }
        return false;
    }

    private int getCompassNeedlePart(float needleAngle) {
        while (needleAngle < 0.0f) {
            needleAngle += 360.0f;
        }
        while (needleAngle > 360.0f) {
            needleAngle -= 360.0f;
        }
        int result = 36 - (int)(needleAngle /= 10.0f);
        return result;
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        return this.baseModel.func_177551_a(facing);
    }

    public List<BakedQuad> func_177550_a() {
        return this.baseModel.func_177550_a();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(ModelRotation.X0_Y90);
        switch (cameraTransformType) {
            case FIRST_PERSON: {
                transform = new TRSRTransformation(new Vector3f(-0.1f, 1.1f, 0.3f), new Quat4f(-2.5f, 8.0f, 0.7f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                break;
            }
            case THIRD_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.2f, -0.14f, -0.25f), new Quat4f(18.0f, 0.0f, 7.0f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f), new Quat4f(0.0f, 0.0f, 0.1f, 1.0f));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.3f, 0.08f, 0.5f), new Quat4f(-0.06f, 0.0f, -0.06f, 0.5f), new Vector3f(1.6f, 1.6f, 1.6f), new Quat4f(-0.06f, 0.0f, -0.06f, 0.5f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.5f, 0.1f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(2.0f, 2.0f, 2.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.5f, 0.3f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(2.0f, 2.0f, 2.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }
}

