/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModelSeatBacks
implements ISmartItemModel,
IPerspectiveAwareModel {
    private IBakedModel baseModel;
    List<String> modelParts;
    IModel model = null;
    private String woodTextureString = "none";
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String texture = location.toString();
            if (texture.contains("minecraft:blocks/planks_spruce")) {
                texture = ModelSeatBacks.this.woodTextureString;
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(texture);
        }
    };

    public ModelSeatBacks(IBakedModel model) {
        this.modelParts = new ArrayList<String>();
        this.modelParts = this.getModelParts(this.modelParts);
    }

    public abstract List<String> getModelParts(List<String> var1);

    public IBakedModel handleItemState(ItemStack stack) {
        String customTextureLocation = "none";
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            customTextureLocation = tags.func_74779_i("renderTexture");
        }
        switch (BiblioWoodBlock.EnumWoodType.getEnum(stack.func_77952_i())) {
            case OAK: {
                this.woodTextureString = "minecraft:blocks/planks_oak";
                break;
            }
            case SPRUCE: {
                this.woodTextureString = "minecraft:blocks/planks_spruce";
                break;
            }
            case BIRCH: {
                this.woodTextureString = "minecraft:blocks/planks_birch";
                break;
            }
            case JUNGLE: {
                this.woodTextureString = "minecraft:blocks/planks_jungle";
                break;
            }
            case ACACIA: {
                this.woodTextureString = "minecraft:blocks/planks_acacia";
                break;
            }
            case DARKOAK: {
                this.woodTextureString = "minecraft:blocks/planks_big_oak";
                break;
            }
            case FRAME: {
                if (customTextureLocation.contains("none") || customTextureLocation.contains("minecraft:white")) {
                    this.woodTextureString = "bibliocraft:blocks/frame";
                    break;
                }
                this.woodTextureString = customTextureLocation;
                break;
            }
            default: {
                this.woodTextureString = "minecraft:blocks/planks_oak";
            }
        }
        try {
            this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:block/seat.obj"));
        }
        catch (IOException e) {
            this.model = ModelLoaderRegistry.getMissingModel();
        }
        this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        OBJModel.OBJState partList = new OBJModel.OBJState(this.modelParts, true, (IModelState)transform);
        this.baseModel = this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, this.textureGetter);
        return this;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        return this.baseModel.func_177551_a(facing);
    }

    public List<BakedQuad> func_177550_a() {
        return this.baseModel.func_177550_a();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(ModelRotation.X0_Y90);
        switch (cameraTransformType) {
            case FIRST_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.45f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON: {
                transform = new TRSRTransformation(new Vector3f(-0.05f, 0.17f, 0.25f), new Quat4f(0.0f, 0.0f, 1.0f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(0.0f, -0.3f, 1.0f, 1.0f));
                break;
            }
            case GUI: {
                transform = this.getAdjustedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.75f, 0.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(2.0f, 2.0f, 2.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(-0.58f, -0.31f, 0.5f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(1.2f, 1.2f, 1.2f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public abstract TRSRTransformation getAdjustedGUITransform(TRSRTransformation var1);
}

