/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class TileEntityMapFrameRenderer
extends TileEntityBiblioRenderer {
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/mapframe.obj");
    private IFlexibleBakedModel pin;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
    };

    @Override
    public void render(BiblioTileEntity tile, double x, double y, double z, float tick) {
        ItemStack stack = tile.func_70301_a(0);
        if (this.pin == null) {
            ArrayList<String> part = new ArrayList<String>();
            part.add("pin");
            this.pin = this.initModel(part, this.modelLocation);
        }
        if (stack != null && tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame frame = (TileEntityMapFrame)tile;
            this.renderFramedItemMap(stack, frame.mapRotation);
            for (int i = 0; i < frame.getPinXCoords().size(); ++i) {
                float xValue = ((Float)frame.getPinYCoords().get(i)).floatValue();
                float yValue = ((Float)frame.getPinXCoords().get(i)).floatValue();
                switch (this.getVertPosition()) {
                    case FLOOR: {
                        xValue = 1.0f - xValue;
                        yValue = 1.0f - yValue;
                        break;
                    }
                    case WALL: {
                        float tx;
                        if (this.getAngle() == EnumFacing.SOUTH || this.getAngle() == EnumFacing.EAST) {
                            tx = xValue;
                            xValue = yValue;
                            yValue = tx;
                            break;
                        }
                        tx = xValue;
                        xValue = 1.0f - yValue;
                        yValue = tx;
                        break;
                    }
                    case CEILING: {
                        yValue = 1.0f - yValue;
                    }
                }
                this.func_147499_a(this.getColorTexture(((Float)frame.getPinColors().get(i)).floatValue()));
                this.renderPin(this.pin, xValue, yValue);
            }
        }
    }

    public ResourceLocation getColorTexture(float color) {
        int colorint = (int)color;
        switch (colorint) {
            case 0: {
                return CommonProxy.BLACKWOOL;
            }
            case 1: {
                return CommonProxy.REDWOOL;
            }
            case 2: {
                return CommonProxy.GREENWOOL;
            }
            case 3: {
                return CommonProxy.LIMEWOOL;
            }
            case 4: {
                return CommonProxy.BROWNWOOL;
            }
            case 5: {
                return CommonProxy.BLUEWOOL;
            }
            case 6: {
                return CommonProxy.CYANWOOL;
            }
            case 7: {
                return CommonProxy.LBLUEWOOL;
            }
            case 8: {
                return CommonProxy.PURPLEWOOL;
            }
            case 9: {
                return CommonProxy.MAGENTAWOOL;
            }
            case 10: {
                return CommonProxy.PINKWOOL;
            }
            case 11: {
                return CommonProxy.YELOOWWOOL;
            }
            case 12: {
                return CommonProxy.ORANGEWOOL;
            }
            case 13: {
                return CommonProxy.GRAYWOOL;
            }
            case 14: {
                return CommonProxy.LGRAYWOOL;
            }
            case 15: {
                return CommonProxy.WHITEWOOL;
            }
        }
        return CommonProxy.REDWOOL;
    }

    private void renderPin(IFlexibleBakedModel model, double x, double y) {
        boolean isWall;
        double z = 0.0;
        boolean bl = isWall = this.getVertPosition() == EnumVertPosition.WALL;
        if (!isWall) {
            z = y;
            y = 0.0;
        }
        switch (this.getAngle()) {
            case SOUTH: {
                double tx = x;
                x = -z;
                z = tx;
                if (this.getVertPosition() != EnumVertPosition.FLOOR) break;
                y = -y;
                z = 1.0 - z;
                break;
            }
            case WEST: {
                x *= -1.0;
                z *= -1.0;
                break;
            }
            case NORTH: {
                double tx = x;
                x = z;
                z = -tx;
                break;
            }
            case EAST: {
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(this.globalX + (double)this.xshift + x), (double)(this.globalY + y), (double)(this.globalZ + (double)this.zshift + z));
        GlStateManager.func_179114_b((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (this.getVertPosition()) {
            case FLOOR: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case WALL: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case CEILING: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GlStateManager.func_179137_b((double)-1.0, (double)0.0, (double)0.0);
            }
        }
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_177550_a()) {
            LightUtil.renderQuadColor((WorldRenderer)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderFramedItemMap(ItemStack stack, int rotation) {
        GlStateManager.func_179094_E();
        float rot = 0.0f;
        float xAdjust = 0.0f;
        float yAdjust = 0.0f;
        float zAdjust = 0.0f;
        block0 : switch (rotation) {
            case 0: {
                rot = 180.0f;
                switch (this.getVertPosition()) {
                    case FLOOR: {
                        rot = 0.0f;
                        zAdjust = 0.0f;
                        break block0;
                    }
                    case WALL: {
                        switch (this.getAngle()) {
                            case SOUTH: {
                                yAdjust = 1.0f;
                                zAdjust = -1.0f;
                                break block0;
                            }
                            case WEST: {
                                xAdjust = 1.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                            case NORTH: {
                                yAdjust = 1.0f;
                                zAdjust = 1.0f;
                                break block0;
                            }
                            case EAST: {
                                xAdjust = -1.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case CEILING: {
                        rot = 0.0f;
                        xAdjust = 0.0f;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                rot = 90.0f;
                switch (this.getVertPosition()) {
                    case FLOOR: {
                        rot = 270.0f;
                        xAdjust = 1.0f;
                        zAdjust = 0.0f;
                        break block0;
                    }
                    case WALL: {
                        switch (this.getAngle()) {
                            case SOUTH: {
                                rot = 270.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                            case WEST: {
                                rot = 270.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                            case NORTH: {
                                rot = 90.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                            case EAST: {
                                rot = 90.0f;
                                yAdjust = 1.0f;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case CEILING: {
                        rot = 90.0f;
                        xAdjust = 1.0f;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.getVertPosition()) {
                    case FLOOR: {
                        rot = 180.0f;
                        xAdjust = 1.0f;
                        zAdjust = 1.0f;
                        break block0;
                    }
                    case CEILING: {
                        rot = 180.0f;
                        xAdjust = 1.0f;
                        zAdjust = -1.0f;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                rot = 270.0f;
                switch (this.getVertPosition()) {
                    case FLOOR: {
                        rot = 90.0f;
                        zAdjust = 1.0f;
                        break block0;
                    }
                    case WALL: {
                        switch (this.getAngle()) {
                            case SOUTH: {
                                rot = 90.0f;
                                zAdjust = -1.0f;
                                break block0;
                            }
                            case WEST: {
                                rot = 90.0f;
                                xAdjust = 1.0f;
                                break block0;
                            }
                            case NORTH: {
                                rot = 270.0f;
                                zAdjust = 1.0f;
                                break block0;
                            }
                            case EAST: {
                                rot = 270.0f;
                                xAdjust = -1.0f;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case CEILING: {
                        rot = 270.0f;
                        xAdjust = 0.0f;
                        zAdjust = -1.0f;
                        break block0;
                    }
                }
            }
        }
        block43 : switch (this.getVertPosition()) {
            case FLOOR: {
                GlStateManager.func_179137_b((double)(this.globalX + (double)xAdjust), (double)(this.globalY + (double)0.035f + (double)yAdjust), (double)(this.globalZ + (double)zAdjust));
                GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WALL: {
                switch (this.getAngle()) {
                    case SOUTH: {
                        GlStateManager.func_179137_b((double)(this.globalX + (double)0.965f + (double)xAdjust), (double)(this.globalY + 0.0 + (double)yAdjust), (double)(this.globalZ + 1.0 + (double)zAdjust));
                        GlStateManager.func_179114_b((float)rot, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break block43;
                    }
                    case WEST: {
                        GlStateManager.func_179137_b((double)(this.globalX + (double)xAdjust), (double)(this.globalY + 0.0 + (double)yAdjust), (double)(this.globalZ + 0.965 + (double)zAdjust));
                        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
                        break block43;
                    }
                    case NORTH: {
                        GlStateManager.func_179137_b((double)(this.globalX + 0.035 + (double)xAdjust), (double)(this.globalY + (double)yAdjust + 0.0), (double)(this.globalZ + (double)zAdjust));
                        GlStateManager.func_179114_b((float)rot, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                        break block43;
                    }
                    case EAST: {
                        GlStateManager.func_179137_b((double)(this.globalX + 1.0 + (double)xAdjust), (double)(this.globalY + 0.0 + (double)yAdjust), (double)(this.globalZ + 0.035 + (double)zAdjust));
                        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break block43;
                    }
                }
                break;
            }
            case CEILING: {
                GlStateManager.func_179137_b((double)(this.globalX + (double)xAdjust), (double)(this.globalY + 0.965 + (double)yAdjust), (double)(this.globalZ + 1.0 + (double)zAdjust));
                GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179152_a((float)0.00782f, (float)0.00782f, (float)0.00782f);
        GlStateManager.func_179140_f();
        MapData mapdata = Items.field_151098_aY.func_77873_a(stack, this.func_178459_a());
        if (mapdata != null) {
            this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void initModel() {
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)this.modelLocation);
        }
        catch (IOException e) {
            model = ModelLoaderRegistry.getMissingModel();
        }
        model = ((IModelCustomData)model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        ArrayList<String> part = new ArrayList<String>();
        part.add("pin");
        OBJModel.OBJState state = new OBJModel.OBJState(part, true);
        this.pin = model.bake((IModelState)state, Attributes.DEFAULT_BAKED_FORMAT, this.textureGetter);
    }
}

