/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.helpers.BiblioEnums;
import jds.bibliocraft.helpers.EnumPaintingFrame;
import jds.bibliocraft.helpers.PaintingUtil;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class TileEntityPaintingRenderer
extends TileEntityBiblioRenderer {
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/paintingframe.obj");
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private int paintingType = 0;
    private String paintingTitle = "blank";
    private boolean connectedTop = false;
    private boolean connectedLeft = false;
    private boolean connectedBottom = false;
    private boolean connectedRight = false;
    private EnumPaintingFrame style = EnumPaintingFrame.BORDERLESS;
    private int paintingMasterCorner = 0;
    private int paintingScale = 1;
    private int paintingAspectRatio = 0;
    private int paintingPixelRes = 0;
    private int paintingRotation = 0;
    private int customPaintingAspectX = 1;
    private int customPaintingAspectY = 1;
    private boolean hideFrame = false;
    private String customTex = "none";

    @Override
    public void render(BiblioTileEntity te, double x, double y, double z, float tick) {
        TileEntityPainting tile = (TileEntityPainting)te;
        this.style = tile.getFrameStyle();
        this.paintingType = tile.getPaintingType();
        this.paintingTitle = tile.getPaintingTitle();
        this.connectedTop = tile.getConnectTop();
        this.connectedLeft = tile.getConnectLeft();
        this.connectedBottom = tile.getConnectBottom();
        this.connectedRight = tile.getConnectRight();
        this.paintingRotation = tile.getPaintingRotation();
        this.paintingMasterCorner = tile.getPaintingCorner();
        this.paintingScale = tile.getPaintingScale();
        this.paintingPixelRes = tile.getPaintingRes();
        this.paintingAspectRatio = tile.getPaintingAspectRatio();
        this.customPaintingAspectX = tile.getCustomPaintingAspectX();
        this.customPaintingAspectY = tile.getCustomPaintingAspectY();
        this.hideFrame = tile.getHideFrame();
        this.customTex = tile.getCustomTextureString();
        if (tile.hasPainting()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)(x + (double)this.xshift), (double)y, (double)(z + (double)this.zshift));
            GlStateManager.func_179114_b((float)((float)this.degreeAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.01, (double)0.5, (double)-0.5);
            this.func_147499_a(CommonProxy.PAINTINGCANVAS);
            GlStateManager.func_179114_b((float)(-this.paintingRotation * 90), (float)1.0f, (float)0.0f, (float)0.0f);
            block0 : switch (this.paintingMasterCorner) {
                case 0: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 3;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 2;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 1;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 0;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 3;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 2;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 1;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 0;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 3;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 2;
                            break block0;
                        }
                        case 2: {
                            this.paintingMasterCorner = 1;
                            break block0;
                        }
                        case 3: {
                            this.paintingMasterCorner = 0;
                        }
                    }
                }
            }
            switch (this.paintingType) {
                case 0: {
                    for (int i = 0; i < this.biblioArtList.length; ++i) {
                        if (!this.paintingTitle.contentEquals(this.biblioArtList[i].title)) continue;
                        this.func_147499_a(this.biblioArtList[i].paintingTextures[this.paintingAspectRatio][this.paintingPixelRes]);
                        switch (this.paintingMasterCorner) {
                            case 0: {
                                GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * (double)this.biblioArtList[i].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(0.5 - 0.5 * (double)this.biblioArtList[i].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 1: {
                                GlStateManager.func_179137_b((double)0.0, (double)(0.5 - 0.5 * (double)this.biblioArtList[i].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(0.5 - 0.5 * (double)this.biblioArtList[i].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 2: {
                                GlStateManager.func_179137_b((double)0.0, (double)(0.5 - 0.5 * (double)this.biblioArtList[i].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(-0.5 + 0.5 * (double)this.biblioArtList[i].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 3: {
                                GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * (double)this.biblioArtList[i].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(-0.5 + 0.5 * (double)this.biblioArtList[i].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                            }
                        }
                        GlStateManager.func_179139_a((double)1.0, (double)(1.0 * (double)this.biblioArtList[i].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(1.0 * (double)this.biblioArtList[i].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.vanillaArtList.length; ++i) {
                        if (!this.paintingTitle.contentEquals(this.vanillaArtList[i].field_75702_A)) continue;
                        double aspectDiff = (double)this.vanillaArtList[i].field_75703_B * 1.0 / ((double)this.vanillaArtList[i].field_75704_C * 1.0);
                        switch (this.paintingMasterCorner) {
                            case 0: {
                                GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75704_C / 16.0))), (double)(0.5 - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75703_B / 16.0))));
                                break;
                            }
                            case 1: {
                                GlStateManager.func_179137_b((double)0.0, (double)(0.5 - (double)this.vanillaArtList[i].field_75704_C / 16.0 * (double)this.paintingScale + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75704_C / 16.0))), (double)(0.5 - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75703_B / 16.0))));
                                break;
                            }
                            case 2: {
                                GlStateManager.func_179137_b((double)0.0, (double)(0.5 - (double)this.vanillaArtList[i].field_75704_C / 16.0 * (double)this.paintingScale + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75704_C / 16.0))), (double)(-0.5 + (double)this.vanillaArtList[i].field_75703_B / 16.0 * (double)this.paintingScale - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75703_B / 16.0))));
                                break;
                            }
                            case 3: {
                                GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75704_C / 16.0))), (double)(-0.5 + (double)this.vanillaArtList[i].field_75703_B / 16.0 * (double)this.paintingScale - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75703_B / 16.0))));
                            }
                        }
                        GlStateManager.func_179139_a((double)1.0, (double)(1.0 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75704_C / 16.0))), (double)(1.0 * ((double)this.paintingScale * ((double)this.vanillaArtList[i].field_75703_B / 16.0))));
                        this.func_147499_a(CommonProxy.PAINTINGSHEET);
                        this.renderVanillaPainting(i);
                    }
                    break;
                }
                case 2: {
                    boolean foundMatch = false;
                    if (PaintingUtil.customArtNames != null && PaintingUtil.customArtNames.length > 0 && PaintingUtil.customArtResources != null) {
                        for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
                            if (!this.paintingTitle.contentEquals(PaintingUtil.customArtNames[i])) continue;
                            this.func_147499_a(PaintingUtil.customArtResources[i]);
                            switch (this.paintingMasterCorner) {
                                case 0: {
                                    GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 1: {
                                    GlStateManager.func_179137_b((double)0.0, (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 2: {
                                    GlStateManager.func_179137_b((double)0.0, (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 3: {
                                    GlStateManager.func_179137_b((double)0.0, (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                }
                            }
                            GlStateManager.func_179139_a((double)1.0, (double)(1.0 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(1.0 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                            foundMatch = true;
                        }
                    }
                    if (foundMatch) break;
                    this.func_147499_a(CommonProxy.PAINTINGNOTFOUND);
                    break;
                }
            }
            if (!(this.connectedBottom || this.connectedLeft || this.connectedRight || this.connectedTop || this.style == EnumPaintingFrame.BORDERLESS || this.paintingType == 1 || this.paintingScale != 1 || this.paintingAspectRatio != 0)) {
                this.renderPainting(true);
            } else if (this.paintingType != 1) {
                this.renderPainting(false);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    private void renderPart(IFlexibleBakedModel model) {
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_177550_a()) {
            LightUtil.renderQuadColor((WorldRenderer)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
    }

    private void renderVanillaPainting(int i) {
        float x1 = (float)this.vanillaArtList[i].field_75699_D / 256.0f;
        float x2 = (float)(this.vanillaArtList[i].field_75699_D + this.vanillaArtList[i].field_75703_B) / 256.0f;
        float y1 = (float)this.vanillaArtList[i].field_75700_E / 256.0f;
        float y2 = (float)(this.vanillaArtList[i].field_75700_E + this.vanillaArtList[i].field_75704_C) / 256.0f;
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.worldRenderer.func_181662_b(0.024, -0.5, -0.5).func_181673_a((double)x2, (double)y2).func_181675_d();
        this.worldRenderer.func_181662_b(0.024, 0.5, -0.5).func_181673_a((double)x2, (double)y1).func_181675_d();
        this.worldRenderer.func_181662_b(0.024, 0.5, 0.5).func_181673_a((double)x1, (double)y1).func_181675_d();
        this.worldRenderer.func_181662_b(0.024, -0.5, 0.5).func_181673_a((double)x1, (double)y2).func_181675_d();
        this.tessellator.func_78381_a();
    }

    private void renderPainting(boolean smallCanvas) {
        double adjust = 0.0;
        if (smallCanvas) {
            adjust = 0.1;
        }
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.worldRenderer.func_181662_b(0.028, -0.5 + adjust, -0.5 + adjust).func_181673_a(0.0, 1.0).func_181675_d();
        this.worldRenderer.func_181662_b(0.028, 0.5 - adjust, -0.5 + adjust).func_181673_a(0.0, 0.0).func_181675_d();
        this.worldRenderer.func_181662_b(0.028, 0.5 - adjust, 0.5 - adjust).func_181673_a(1.0, 0.0).func_181675_d();
        this.worldRenderer.func_181662_b(0.028, -0.5 + adjust, 0.5 - adjust).func_181673_a(1.0, 1.0).func_181675_d();
        this.tessellator.func_78381_a();
    }
}

