/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityArmorStand
extends BiblioTileEntity {
    public boolean helm = false;
    public boolean cuirass = false;
    public boolean greaves = false;
    public boolean boots = false;
    public int showArmorText = 0;
    private boolean isBottomStand = true;

    public TileEntityArmorStand() {
        super(4, true);
    }

    public void setIsBottomStand(boolean isBottom) {
        this.isBottomStand = isBottom;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean getIsBottomStand() {
        return this.isBottomStand;
    }

    public void checkArmorSlots() {
        ItemStack stackTest0 = this.func_70301_a(0);
        this.helm = stackTest0 != null;
        ItemStack stackTest1 = this.func_70301_a(1);
        this.cuirass = stackTest1 != null;
        ItemStack stackTest2 = this.func_70301_a(2);
        this.greaves = stackTest2 != null;
        ItemStack stackTest3 = this.func_70301_a(3);
        this.boots = stackTest3 != null;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public boolean getHelm() {
        return this.helm;
    }

    public boolean getCuirass() {
        return this.cuirass;
    }

    public boolean getGreaves() {
        return this.greaves;
    }

    public boolean getBoots() {
        return this.boots;
    }

    public boolean addArmor(ItemStack stack, int armorType) {
        this.checkArmorSlots();
        switch (armorType) {
            case 0: {
                if (this.helm) break;
                this.func_70299_a(0, stack);
                return true;
            }
            case 1: {
                if (this.cuirass) break;
                this.func_70299_a(1, stack);
                return true;
            }
            case 2: {
                if (this.greaves) break;
                this.func_70299_a(2, stack);
                return true;
            }
            case 3: {
                if (this.boots) break;
                this.func_70299_a(3, stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        ItemArmor armorItem;
        if (!this.getIsBottomStand()) {
            return false;
        }
        Item stackItem = itemstack.func_77973_b();
        if (stackItem instanceof ItemArmor && (armorItem = (ItemArmor)stackItem) != null) {
            int armorType = armorItem.field_77881_a;
            if (slot == 0 && armorType == 0) {
                return true;
            }
            if (slot == 1 && armorType == 1) {
                return true;
            }
            if (slot == 2 && armorType == 2) {
                return true;
            }
            return slot == 3 && armorType == 3;
        }
        return false;
    }

    public String func_70005_c_() {
        return "ArmorStand";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        this.checkArmorSlots();
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.helm = nbt.func_74767_n("helm");
        this.cuirass = nbt.func_74767_n("cuirass");
        this.greaves = nbt.func_74767_n("greaves");
        this.boots = nbt.func_74767_n("boots");
        this.isBottomStand = nbt.func_74767_n("isBottom");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a("helm", this.helm);
        nbt.func_74757_a("cuirass", this.cuirass);
        nbt.func_74757_a("greaves", this.greaves);
        nbt.func_74757_a("boots", this.boots);
        nbt.func_74757_a("isBottom", this.isBottomStand);
        return nbt;
    }

    public IChatComponent func_145748_c_() {
        ChatComponentText chat = new ChatComponentText(this.func_70005_c_());
        return chat;
    }
}

