/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import java.util.List;
import jds.bibliocraft.containers.ContainerFramedChest;
import jds.bibliocraft.helpers.BiblioSortingHelper;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;

public class TileEntityFramedChest
extends BiblioTileEntity
implements ITickable {
    private boolean openChest = false;
    private ItemStack labelStack = null;
    private boolean isDouble = false;
    private boolean isLeft = true;
    private int ticksSinceSync = 0;
    private int numPlayersUsing = 0;
    private float prevLidAngle = 0.0f;
    private float lidAngle = 0.0f;
    public TileEntityFramedChest adjacentDoubleChest = null;

    public TileEntityFramedChest() {
        super(27, true);
    }

    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public void addUsingPlayer(boolean add) {
        if (add) {
            ++this.numPlayersUsing;
        } else {
            --this.numPlayersUsing;
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
        }
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public ItemStack getLabelStack() {
        return this.labelStack;
    }

    private void setLabelStack(ItemStack stack) {
        this.labelStack = stack;
    }

    public boolean getIsDouble() {
        return this.isDouble;
    }

    public boolean getIsLeft() {
        return this.isLeft;
    }

    public void setIsDouble(boolean dub, boolean left, TileEntityFramedChest secondChest) {
        this.isDouble = dub;
        this.isLeft = left;
        this.adjacentDoubleChest = secondChest;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setAdjacentChest(TileEntityFramedChest secondChest) {
        this.adjacentDoubleChest = secondChest;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void setOpenChest(boolean chest) {
        this.openChest = chest;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean getOpenChest() {
        return this.openChest;
    }

    public void func_73660_a() {
        float f;
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numPlayersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_178781_a((double)((float)this.field_174879_c.func_177958_n() - f), (double)((float)this.field_174879_c.func_177956_o() - f), (double)((float)this.field_174879_c.func_177952_p() - f), (double)((float)(this.field_174879_c.func_177958_n() + 1) + f), (double)((float)(this.field_174879_c.func_177956_o() + 1) + f), (double)((float)(this.field_174879_c.func_177952_p() + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                TileEntityFramedChest iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerFramedChest) || (iinventory = ((ContainerFramedChest)entityplayer.field_71070_bA).getMainTile()) != this && (!(iinventory instanceof TileEntityFramedChest) || !this.checkIfIsAdjacentDoubleChest(iinventory))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f && !this.field_145850_b.field_72995_K) {
            double d1 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (this.getIsDouble() && this.adjacentDoubleChest != null) {
                if (this.adjacentDoubleChest.field_174879_c.func_177952_p() == this.field_174879_c.func_177952_p() + 1) {
                    d2 += 0.5;
                }
                if (this.adjacentDoubleChest.field_174879_c.func_177958_n() == this.field_174879_c.func_177958_n() + 1) {
                    d1 += 0.5;
                }
            }
            if (this.getIsDouble() && this.getIsLeft() || !this.getIsDouble()) {
                this.field_145850_b.func_72908_a(d1, (double)this.field_174879_c.func_177956_o() + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2 && !this.field_145850_b.field_72995_K) {
                double d2 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d0 = (double)this.field_174879_c.func_177952_p() + 0.5;
                if (this.getIsDouble() && this.adjacentDoubleChest != null) {
                    if (this.adjacentDoubleChest.field_174879_c.func_177952_p() == this.field_174879_c.func_177952_p() + 1) {
                        d0 += 0.5;
                    }
                    if (this.adjacentDoubleChest.field_174879_c.func_177958_n() == this.field_174879_c.func_177958_n() + 1) {
                        d2 += 0.5;
                    }
                }
                if (this.getIsDouble() && this.getIsLeft() || !this.getIsDouble()) {
                    this.field_145850_b.func_72908_a(d2, (double)this.field_174879_c.func_177956_o() + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void setLidAngle(float langle) {
        this.lidAngle = langle;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    private boolean checkIfIsAdjacentDoubleChest(TileEntityFramedChest tile) {
        return tile != null && this.adjacentDoubleChest != null && tile.getIsDouble() && this.adjacentDoubleChest.getIsDouble() && this.getIsDouble() && this.getIsLeft() && tile.field_174879_c.func_177958_n() == this.adjacentDoubleChest.field_174879_c.func_177958_n() && tile.field_174879_c.func_177956_o() == this.adjacentDoubleChest.field_174879_c.func_177956_o() && tile.field_174879_c.func_177952_p() == this.adjacentDoubleChest.field_174879_c.func_177952_p();
    }

    public String func_70005_c_() {
        return "FramedChest";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        ItemStack bestStack = BiblioSortingHelper.getLargestStackInList(BiblioSortingHelper.getStackForBuiltinLabel(this));
        if (bestStack != null) {
            bestStack.field_77994_a = 1;
        }
        this.labelStack = bestStack;
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.openChest = nbt.func_74767_n("openChest");
        this.isDouble = nbt.func_74767_n("isDouble");
        this.isLeft = nbt.func_74767_n("isLeft");
        this.numPlayersUsing = nbt.func_74762_e("numPlayersUsing");
        this.labelStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("labelStack"));
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a("openChest", this.openChest);
        nbt.func_74757_a("isDouble", this.isDouble);
        nbt.func_74757_a("isLeft", this.isLeft);
        nbt.func_74768_a("numPlayersUsing", this.numPlayersUsing);
        if (this.labelStack != null) {
            nbt.func_74782_a("labelStack", (NBTBase)this.labelStack.func_77955_b(new NBTTagCompound()));
        } else {
            nbt.func_74782_a("labelStack", (NBTBase)new NBTTagCompound());
        }
        return nbt;
    }

    public IChatComponent func_145748_c_() {
        ChatComponentText chat = new ChatComponentText(this.func_70005_c_());
        return chat;
    }
}

