/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockPaintingFrameBorderless;
import jds.bibliocraft.helpers.EnumPaintingFrame;
import jds.bibliocraft.items.ItemPaintingCanvas;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPainting
extends BiblioTileEntity {
    public int paintingType = 0;
    public String paintingTitle = "blank";
    public int paintingRotation = 0;
    public int paintingMasterCorner = 0;
    public int paintingScale = 1;
    public int paintingAspectRatio = 0;
    public int paintingPixelRes = 0;
    public int customPaintingAspectX = 1;
    public int customPaintingAspectY = 1;
    public boolean connectedTop = false;
    public boolean connectedLeft = false;
    public boolean connectedBottom = false;
    public boolean connectedRight = false;
    public boolean showTLCorner = true;
    public boolean showTRCorner = true;
    public boolean showBRCorner = true;
    public boolean showBLCorner = true;
    public boolean containerUpdate = false;
    public boolean hideFrame;
    public EnumPaintingFrame style = EnumPaintingFrame.BORDERLESS;

    public TileEntityPainting() {
        super(1, true);
    }

    public void setFrameStyle(EnumPaintingFrame frame) {
        this.style = frame;
    }

    public EnumPaintingFrame getFrameStyle() {
        return this.style;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double distance = Config.renderDistancePainting;
        return distance * distance;
    }

    public void setHideFrame(boolean hide) {
        this.hideFrame = hide;
    }

    public boolean getHideFrame() {
        return this.hideFrame;
    }

    public void setConnectTop(boolean connect) {
        this.connectedTop = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setConnectLeft(boolean connect) {
        this.connectedLeft = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setConnectBottom(boolean connect) {
        this.connectedBottom = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setConnectRight(boolean connect) {
        this.connectedRight = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setPaintingRotation(int rot) {
        this.paintingRotation = rot;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setPacketUpdate(int corner, int scale, int pixels, int aspect, int rotation, int aspectX, int aspectY) {
        this.paintingMasterCorner = corner;
        this.paintingScale = scale;
        this.paintingPixelRes = pixels;
        this.paintingAspectRatio = aspect;
        this.paintingRotation = rotation;
        this.customPaintingAspectX = aspectX;
        this.customPaintingAspectY = aspectY;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setPacketAspectsUpdate(int aspectX, int aspectY) {
        this.customPaintingAspectX = aspectX;
        this.customPaintingAspectY = aspectY;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setContainterUpdate(boolean update) {
        this.containerUpdate = update;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean getContainerUpdate() {
        return this.containerUpdate;
    }

    public int getCustomPaintingAspectX() {
        return this.customPaintingAspectX;
    }

    public int getCustomPaintingAspectY() {
        return this.customPaintingAspectY;
    }

    public void resetPaintingData() {
        this.paintingRotation = 0;
        this.paintingMasterCorner = 0;
        this.paintingScale = 1;
        this.paintingAspectRatio = 0;
        this.paintingPixelRes = 0;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void checkDiagnoalsForCorners(boolean checkFurtherPaintings) {
        TileEntityPainting paintTile;
        TileEntity topLeftdiagTile = null;
        TileEntity topRightdiagTile = null;
        TileEntity bottomRightdiagTile = null;
        TileEntity bottomLeftdiagTile = null;
        switch (this.getAngle()) {
            case SOUTH: {
                topLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 1));
                topRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1));
                bottomRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1));
                bottomLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1));
                break;
            }
            case WEST: {
                topLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                topRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                bottomLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                break;
            }
            case NORTH: {
                topLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1));
                topRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 1));
                bottomRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1));
                bottomLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1));
                break;
            }
            case EAST: {
                topLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                topRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomRightdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                bottomLeftdiagTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                break;
            }
        }
        this.showTLCorner = true;
        this.showTRCorner = true;
        this.showBRCorner = true;
        this.showBLCorner = true;
        if (topLeftdiagTile != null && topLeftdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)topLeftdiagTile).getConnectBottom() && paintTile.getConnectRight()) {
            this.showTLCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            paintTile.updateLocalPaintings();
        }
        if (topRightdiagTile != null && topRightdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)topRightdiagTile).getConnectBottom() && paintTile.getConnectLeft()) {
            this.showTRCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            paintTile.updateLocalPaintings();
        }
        if (bottomRightdiagTile != null && bottomRightdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)bottomRightdiagTile).getConnectTop() && paintTile.getConnectLeft()) {
            this.showBRCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            paintTile.updateLocalPaintings();
        }
        if (bottomLeftdiagTile != null && bottomLeftdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)bottomLeftdiagTile).getConnectTop() && paintTile.getConnectRight()) {
            this.showBLCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            paintTile.updateLocalPaintings();
        }
    }

    public void updateLocalPaintings() {
        TileEntityPainting tile;
        TileEntity topTile = null;
        TileEntity bottomTile = null;
        TileEntity rightTile = null;
        TileEntity leftTile = null;
        switch (this.getAngle()) {
            case SOUTH: {
                topTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                rightTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1));
                leftTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1));
                break;
            }
            case WEST: {
                topTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                rightTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                leftTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                break;
            }
            case NORTH: {
                topTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                rightTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1));
                leftTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1));
                break;
            }
            case EAST: {
                topTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()));
                bottomTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()));
                rightTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                leftTile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                break;
            }
        }
        if (topTile != null && topTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)topTile;
            tile.updateMe();
        }
        if (bottomTile != null && bottomTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)bottomTile;
            tile.updateMe();
        }
        if (rightTile != null && rightTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)rightTile;
            tile.updateMe();
        }
        if (leftTile != null && leftTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)leftTile;
            tile.updateMe();
        }
    }

    public void updateMe() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    private void sendUpdateNotify() {
        if (this.getAngle() == EnumFacing.SOUTH || this.getAngle() == EnumFacing.NORTH) {
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 1), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1), (Block)BlockPaintingFrameBorderless.instance);
        } else {
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()), (Block)BlockPaintingFrameBorderless.instance);
            this.field_145850_b.func_180496_d(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()), (Block)BlockPaintingFrameBorderless.instance);
        }
    }

    public boolean getConnectTop() {
        return this.connectedTop;
    }

    public boolean getConnectLeft() {
        return this.connectedLeft;
    }

    public boolean getConnectBottom() {
        return this.connectedBottom;
    }

    public boolean getConnectRight() {
        return this.connectedRight;
    }

    public boolean getShowTLCorner() {
        return this.showTLCorner;
    }

    public boolean getShowTRCorner() {
        return this.showTRCorner;
    }

    public boolean getShowBRCorner() {
        return this.showBRCorner;
    }

    public boolean getShowBLCorner() {
        return this.showBLCorner;
    }

    public int getPaintingRotation() {
        return this.paintingRotation;
    }

    public int getPaintingCorner() {
        return this.paintingMasterCorner;
    }

    public int getPaintingScale() {
        return this.paintingScale;
    }

    public int getPaintingRes() {
        return this.paintingPixelRes;
    }

    public int getPaintingAspectRatio() {
        return this.paintingAspectRatio;
    }

    public boolean hasPainting() {
        return this.func_70301_a(0) != null;
    }

    public int getPaintingType() {
        return this.paintingType;
    }

    public String getPaintingTitle() {
        return this.paintingTitle;
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = AxisAlignedBB.func_178781_a((double)(this.field_174879_c.func_177958_n() - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_174879_c.func_177956_o() - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_174879_c.func_177952_p() - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_174879_c.func_177958_n() + 4 + this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_174879_c.func_177956_o() + 4 + this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_174879_c.func_177952_p() + 4 + this.paintingScale * (this.paintingAspectRatio + 1)));
        return bb;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackitem = itemstack.func_77973_b();
        return stackitem != null && stackitem == ItemPaintingCanvas.instance;
    }

    public String func_70005_c_() {
        String output = "PaintingFrameBorderless";
        switch (this.getFrameStyle()) {
            case BORDERLESS: {
                output = "PaintingFrameBorderless";
                break;
            }
            case FANCY: {
                output = "PaintingFrameFancy";
                break;
            }
            case FLAT: {
                output = "PaintingFrameFlat";
                break;
            }
            case MIDDLE: {
                output = "PaintingFrameMiddle";
                break;
            }
            case SIMPLE: {
                output = "PaintingFrameSimple";
            }
        }
        return output;
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        NBTTagCompound tags;
        if (stack != null && stack.func_77973_b() == ItemPaintingCanvas.instance && (tags = stack.func_77978_p()) != null) {
            this.paintingTitle = tags.func_74779_i("paintingTitle");
            this.paintingType = tags.func_74762_e("paintingType");
        }
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.paintingType = nbt.func_74762_e("paintingType");
        this.paintingTitle = nbt.func_74779_i("paintingTitle");
        this.connectedTop = nbt.func_74767_n("connectedTop");
        this.connectedLeft = nbt.func_74767_n("connectedLeft");
        this.connectedBottom = nbt.func_74767_n("connectedBottom");
        this.connectedRight = nbt.func_74767_n("connectedRight");
        this.paintingRotation = nbt.func_74762_e("paintingRotation");
        this.showTLCorner = nbt.func_74767_n("showTLCorner");
        this.showTRCorner = nbt.func_74767_n("showTRCorner");
        this.showBRCorner = nbt.func_74767_n("showBRCorner");
        this.showBLCorner = nbt.func_74767_n("showBLCorner");
        this.paintingMasterCorner = nbt.func_74762_e("masterCorner");
        this.paintingScale = nbt.func_74762_e("paintingScale");
        this.paintingPixelRes = nbt.func_74762_e("paintingPixelRes");
        this.paintingAspectRatio = nbt.func_74762_e("paintingAspectRatio");
        this.customPaintingAspectX = nbt.func_74762_e("customPaintingAspectX");
        this.customPaintingAspectY = nbt.func_74762_e("customPaintingAspectY");
        this.hideFrame = nbt.func_74767_n("hideFrame");
        this.style = EnumPaintingFrame.getEnumFromID(nbt.func_74762_e("frameStyle"));
        this.containerUpdate = nbt.func_74767_n("containerUpdate");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74768_a("paintingType", this.paintingType);
        nbt.func_74778_a("paintingTitle", this.paintingTitle);
        nbt.func_74757_a("connectedTop", this.connectedTop);
        nbt.func_74757_a("connectedLeft", this.connectedLeft);
        nbt.func_74757_a("connectedBottom", this.connectedBottom);
        nbt.func_74757_a("connectedRight", this.connectedRight);
        nbt.func_74768_a("paintingRotation", this.paintingRotation);
        nbt.func_74757_a("showTLCorner", this.showTLCorner);
        nbt.func_74757_a("showTRCorner", this.showTRCorner);
        nbt.func_74757_a("showBRCorner", this.showBRCorner);
        nbt.func_74757_a("showBLCorner", this.showBLCorner);
        nbt.func_74768_a("masterCorner", this.paintingMasterCorner);
        nbt.func_74768_a("paintingScale", this.paintingScale);
        nbt.func_74768_a("paintingPixelRes", this.paintingPixelRes);
        nbt.func_74768_a("paintingAspectRatio", this.paintingAspectRatio);
        nbt.func_74768_a("customPaintingAspectX", this.customPaintingAspectX);
        nbt.func_74768_a("customPaintingAspectY", this.customPaintingAspectY);
        nbt.func_74757_a("hideFrame", this.hideFrame);
        nbt.func_74768_a("frameStyle", this.style.getID());
        nbt.func_74757_a("containerUpdate", this.containerUpdate);
        return nbt;
    }

    public IChatComponent func_145748_c_() {
        ChatComponentText chat = new ChatComponentText(this.func_70005_c_());
        return chat;
    }
}

