/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.Config;
import jds.bibliocraft.helpers.FileUtil;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.items.ItemAtlasPlate;
import jds.bibliocraft.items.ItemBigBook;
import jds.bibliocraft.items.ItemChase;
import jds.bibliocraft.items.ItemEnchantedPlate;
import jds.bibliocraft.items.ItemPlate;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.items.ItemStockroomCatalog;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TileEntityTypeMachine
extends BiblioTileEntity {
    public String nameofbook = StatCollector.func_74838_a((String)"typesetting.bookSelect");
    public boolean bookIsSaved;
    public String listofbooks = "";
    public String listofAuthors = "";
    public String listofPublicBooks = "";
    public boolean showBookname = false;
    public boolean showChaseText = false;
    public int requiredlevels = 0;
    public boolean showLevels = false;

    public TileEntityTypeMachine() {
        super(3, false);
    }

    public int getLevels() {
        return this.requiredlevels;
    }

    public void booklistset() {
        if (MinecraftServer.func_71276_C().func_71262_S()) {
            FileUtil util = new FileUtil();
            String[] blist = util.scanBookDir(false);
            String[] alist = util.getAuthorList(blist, false);
            boolean[] plist = util.getPublistList(blist, false);
            String bookstring = "";
            String authorString = "";
            String publicsString = "";
            for (int g = 0; g < blist.length; ++g) {
                if (g != blist.length - 1) {
                    bookstring = bookstring + blist[g] + "&_";
                    authorString = authorString + alist[g] + "&_";
                    if (plist[g]) {
                        publicsString = publicsString + "true&_";
                        continue;
                    }
                    publicsString = publicsString + "false&_";
                    continue;
                }
                bookstring = bookstring + blist[g];
                authorString = authorString + alist[g];
                publicsString = plist[g] ? publicsString + "true" : publicsString + "false";
            }
            this.setBookList(bookstring, authorString, publicsString);
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void writePlateNBT(ItemStack stack, String bookName) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("bookName", bookName);
        stack.func_77982_d(tag);
    }

    public boolean signedBookCheck() {
        Item booktest;
        ItemStack stack = this.func_70301_a(0);
        return stack != null && ((booktest = stack.func_77973_b()) instanceof ItemEditableBook || booktest instanceof ItemBigBook || booktest instanceof ItemRecipeBook || booktest instanceof ItemAtlas || booktest instanceof ItemStockroomCatalog);
    }

    public boolean enchantedBookCheck() {
        Item booktest;
        ItemStack stack = this.func_70301_a(0);
        return stack != null && (booktest = stack.func_77973_b()) instanceof ItemEnchantedBook;
    }

    public boolean atlasBookCheck() {
        Item booktest;
        ItemStack stack = this.func_70301_a(0);
        return stack != null && (booktest = stack.func_77973_b()) instanceof ItemAtlas;
    }

    public boolean chaseCheck() {
        ItemStack stack = this.func_70301_a(1);
        return stack != null;
    }

    public int getChaseNum() {
        int stacksize = 0;
        if (this.chaseCheck()) {
            ItemStack stack = this.func_70301_a(1);
            int sizetest = stack.field_77994_a;
            if (sizetest > 0 && sizetest < 17) {
                stacksize = 1;
            }
            if (sizetest > 16 && sizetest < 33) {
                stacksize = 2;
            }
            if (sizetest > 32 && sizetest < 49) {
                stacksize = 3;
            }
            if (sizetest > 48) {
                stacksize = 4;
            }
        }
        return stacksize;
    }

    public int addChase(ItemStack chaseStack) {
        ItemStack stack = this.func_70301_a(1);
        if (stack != null) {
            int sizetest = stack.field_77994_a;
            int chaseSize = chaseStack.field_77994_a;
            int totaltest = sizetest + chaseSize;
            if (totaltest < 65) {
                stack.field_77994_a = totaltest;
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return 0;
            }
            stack.field_77994_a = 64;
            this.field_145850_b.func_175689_h(this.field_174879_c);
            return totaltest - 64;
        }
        this.func_70299_a(1, chaseStack);
        this.field_145850_b.func_175689_h(this.field_174879_c);
        return 0;
    }

    public boolean addBookorPlate(ItemStack playerstack, World world) {
        ItemStack bookstack = this.func_70301_a(0);
        if (bookstack == null && playerstack != null) {
            NBTTagCompound tags;
            NBTTagCompound nbt;
            Item itemtest = playerstack.func_77973_b();
            boolean testForCustomBooks = false;
            if ((itemtest instanceof ItemBigBook || itemtest instanceof ItemRecipeBook) && (nbt = playerstack.func_77978_p()) != null && nbt.func_74767_n("signed")) {
                testForCustomBooks = true;
            }
            if (itemtest instanceof ItemStockroomCatalog) {
                testForCustomBooks = true;
            }
            if (itemtest instanceof ItemPlate || itemtest instanceof ItemEditableBook || itemtest instanceof ItemEnchantedBook || testForCustomBooks) {
                FileUtil util = new FileUtil();
                this.bookIsSaved = util.isBookSaved(playerstack, world);
                if (itemtest instanceof ItemEnchantedBook) {
                    int levelcost;
                    NBTTagList enchbookTagList = this.getEnchantmentTagList(playerstack);
                    int enchCount = enchbookTagList.func_74745_c();
                    float slidingScale = 1.0f;
                    float levelCalc = 0.0f;
                    for (int x = 0; x < enchbookTagList.func_74745_c(); ++x) {
                        int enchlvl = enchbookTagList.func_150305_b(x).func_74765_d("lvl");
                        short enchid = enchbookTagList.func_150305_b(x).func_74765_d("id");
                        int maxlvl = 1;
                        if (enchid < Enchantment.field_77331_b.length) {
                            maxlvl = Enchantment.field_77331_b[enchid].func_77325_b();
                        }
                        switch (maxlvl) {
                            case 1: {
                                enchlvl += 4;
                                break;
                            }
                            case 2: {
                                enchlvl += 3;
                                break;
                            }
                            case 3: {
                                enchlvl += 2;
                                break;
                            }
                            case 4: {
                                ++enchlvl;
                            }
                        }
                        if (x > 0) {
                            slidingScale = 0.5f * (1.0f / (float)x);
                        }
                        levelCalc += ((float)(enchlvl * enchlvl) + 15.0f) * slidingScale;
                    }
                    this.requiredlevels = levelcost = (int)(levelCalc *= (float)Config.enchantmentMultiplyer / 10.0f);
                }
                this.func_70299_a(0, playerstack);
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return true;
            }
            if (itemtest instanceof ItemAtlas && (tags = playerstack.func_77978_p()) != null) {
                InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
                NBTTagList tagList = tags.func_150295_c("Inventory", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                    ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                    atlasInventory.func_70299_a((int)slot, invStack);
                }
                int mapCount = 0;
                for (int i = 6; i < atlasInventory.func_70302_i_(); ++i) {
                    ItemStack mapTest = atlasInventory.func_70301_a(i);
                    if (mapTest == null || mapTest.func_77973_b() != Items.field_151098_aY) continue;
                    ++mapCount;
                }
                if (mapCount > 0) {
                    int enchant;
                    this.requiredlevels = enchant = this.getLevelFromXP(mapCount * 32);
                    this.func_70299_a(0, playerstack);
                    this.field_145850_b.func_175689_h(this.field_174879_c);
                    return true;
                }
            }
        }
        return false;
    }

    private int getLevelFromXP(int xp) {
        int xpcounter = 0;
        boolean levelcounter = true;
        for (int i = 0; i <= 30; ++i) {
            xpcounter = i < 16 ? xpcounter + 2 * i + 7 : xpcounter + 5 * i - 38;
            if (xp > xpcounter) continue;
            return i;
        }
        return 0;
    }

    public boolean resetPlate() {
        if (this.hasOldPlate()) {
            ItemStack newChase = new ItemStack((Item)ItemChase.instance, 1, 0);
            ItemStack chaseStack = this.func_70301_a(1);
            this.func_70299_a(0, null);
            if (chaseStack != null) {
                if (chaseStack.field_77994_a < 64) {
                    ++chaseStack.field_77994_a;
                } else {
                    this.func_70299_a(0, newChase);
                }
            } else {
                this.func_70299_a(1, newChase);
            }
            this.field_145850_b.func_175689_h(this.field_174879_c);
            return true;
        }
        return false;
    }

    public boolean saveBook(World world) {
        ItemStack booktosave = this.func_70301_a(0);
        if (booktosave != null) {
            Item bookItem = booktosave.func_77973_b();
            if (bookItem instanceof ItemEditableBook) {
                FileUtil util = new FileUtil();
                util.saveBook(booktosave, world);
                this.bookIsSaved = true;
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return true;
            }
            if (bookItem instanceof ItemBigBook) {
                FileUtil util = new FileUtil();
                util.saveNBTtoFile(booktosave, world, 0);
                this.bookIsSaved = true;
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return true;
            }
            if (bookItem instanceof ItemRecipeBook) {
                FileUtil util = new FileUtil();
                util.saveNBTtoFile(booktosave, world, 1);
                this.bookIsSaved = true;
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return true;
            }
            if (bookItem instanceof ItemStockroomCatalog) {
                FileUtil util = new FileUtil();
                util.saveNBTtoFile(booktosave, world, 2);
                this.bookIsSaved = true;
                this.field_145850_b.func_175689_h(this.field_174879_c);
                return true;
            }
        }
        return false;
    }

    public boolean enchantPlate(EntityPlayer player) {
        Item enchBook;
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && this.chaseCheck() && this.func_70301_a(2) == null && (enchBook = stack.func_77973_b()) instanceof ItemEnchantedBook) {
            NBTTagList enchbookTagList = this.getEnchantmentTagList(stack);
            int enchCount = enchbookTagList.func_74745_c();
            float levelCalc = 0.0f;
            for (int x = 0; x < enchbookTagList.func_74745_c(); ++x) {
                int enchlvl = enchbookTagList.func_150305_b(x).func_74765_d("lvl");
                short enchid = enchbookTagList.func_150305_b(x).func_74765_d("id");
                int maxlvl = 1;
                if (enchid < Enchantment.field_77331_b.length) {
                    maxlvl = Enchantment.field_77331_b[enchid].func_77325_b();
                }
                float slidingScale = 1.0f;
                switch (maxlvl) {
                    case 1: {
                        enchlvl += 4;
                        break;
                    }
                    case 2: {
                        enchlvl += 3;
                        break;
                    }
                    case 3: {
                        enchlvl += 2;
                        break;
                    }
                    case 4: {
                        ++enchlvl;
                    }
                }
                if (x > 0) {
                    slidingScale = 0.5f * (1.0f / (float)x);
                }
                levelCalc += ((float)(enchlvl * enchlvl) + 15.0f) * slidingScale;
            }
            int levelcost = (int)(levelCalc *= (float)Config.enchantmentMultiplyer / 10.0f);
            if (player.field_71068_ca < levelcost) {
                return false;
            }
            ItemStack enchplate = new ItemStack((Item)ItemEnchantedPlate.instance, 1, 0);
            if (stack.func_77942_o()) {
                enchplate.func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                this.func_70299_a(2, enchplate);
                ItemStack chases = this.func_70301_a(1);
                --chases.field_77994_a;
                this.func_70299_a(0, null);
            }
            player.func_82242_a(-levelcost);
            this.field_145850_b.func_175689_h(this.field_174879_c);
            return true;
        }
        return false;
    }

    public boolean createAtlasPlate(EntityPlayer player) {
        ItemStack atlas = this.func_70301_a(0);
        if (atlas != null && atlas.func_77973_b() instanceof ItemAtlas && this.chaseCheck() && this.func_70301_a(2) == null) {
            int i;
            atlas = atlas.func_77946_l();
            if (this.requiredlevels > player.field_71068_ca) {
                return false;
            }
            NBTTagCompound tags = atlas.func_77978_p();
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            for (i = 0; i < atlasInventory.func_70302_i_(); ++i) {
                ItemStack testStack = atlasInventory.func_70301_a(i);
                if (testStack == null || testStack.func_77973_b() == Items.field_151098_aY) continue;
                atlasInventory.func_70299_a(i, null);
            }
            NBTTagList itemList = new NBTTagList();
            for (int i2 = 0; i2 < atlasInventory.func_70302_i_(); ++i2) {
                ItemStack stack = atlasInventory.func_70301_a(i2);
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i2);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tags.func_74782_a("Inventory", (NBTBase)itemList);
            ItemStack chases = this.func_70301_a(1);
            ItemStack plate = new ItemStack((Item)ItemAtlasPlate.instance, 1, 0);
            plate.func_77982_d(tags);
            player.func_82242_a(-this.requiredlevels);
            this.func_70299_a(2, plate);
            if (chases.field_77994_a > 1) {
                --chases.field_77994_a;
                this.func_70299_a(1, chases);
            } else {
                this.func_70299_a(1, null);
            }
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
        return false;
    }

    public ItemStack getEntchantedBook() {
        return this.func_70301_a(0);
    }

    public NBTTagList getEnchantmentTagList(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StoredEnchantments") ? (NBTTagList)stack.func_77978_p().func_74781_a("StoredEnchantments") : new NBTTagList();
    }

    public void setPlate() {
        if (this.chaseCheck() && this.func_70301_a(2) == null) {
            ItemStack stack = this.func_70301_a(1);
            ItemStack newPlate = new ItemStack((Item)ItemPlate.instance, 1, 0);
            this.writePlateNBT(newPlate, this.getBookname());
            this.inventory[2] = newPlate;
            if (stack.field_77994_a != 1) {
                --stack.field_77994_a;
                this.inventory[1] = stack;
            } else {
                this.inventory[1] = null;
            }
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public String getBookname() {
        return this.nameofbook;
    }

    public void setBookname(String name) {
        this.nameofbook = name;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean hasSavedBook() {
        return this.bookIsSaved;
    }

    public boolean hasNewPlate() {
        ItemStack stack = this.func_70301_a(2);
        return stack != null;
    }

    public boolean hasEnchantedPlate() {
        Item item;
        ItemStack stack = this.func_70301_a(2);
        return stack != null && (item = stack.func_77973_b()) instanceof ItemEnchantedPlate;
    }

    public boolean hasAtlasPlate() {
        Item item;
        ItemStack stack = this.func_70301_a(2);
        return stack != null && (item = stack.func_77973_b()) instanceof ItemAtlasPlate;
    }

    public boolean hasOldPlate() {
        Item booktest;
        ItemStack stack = this.func_70301_a(0);
        return stack != null && (booktest = stack.func_77973_b()) instanceof ItemPlate;
    }

    public boolean hasLowerChase() {
        Item booktest;
        ItemStack stack = this.func_70301_a(0);
        return stack != null && (booktest = stack.func_77973_b()) instanceof ItemChase;
    }

    public void setBookList(String books, String authors, String publics) {
        this.listofbooks = books;
        this.listofAuthors = authors;
        this.listofPublicBooks = publics;
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public String getbookListString() {
        return this.listofbooks;
    }

    public String getAuthorListString() {
        return this.listofAuthors;
    }

    public String getPublicListString() {
        return this.listofPublicBooks;
    }

    public String[] getbookList() {
        String[] booklist = this.listofbooks.split("&_");
        return booklist;
    }

    public String[] getAuthorList() {
        String[] authorlist = this.listofAuthors.split("&_");
        return authorlist;
    }

    public boolean[] getPublicList() {
        String[] publist = this.listofPublicBooks.split("&_");
        boolean[] publiclist = new boolean[publist.length];
        for (int h = 0; h < publist.length; ++h) {
            publiclist[h] = publist[h].contains("true");
        }
        return publiclist;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackitem = itemstack.func_77973_b();
        if (stackitem != null) {
            if (slot == 0 && (stackitem instanceof ItemPlate || stackitem instanceof ItemEditableBook)) {
                return true;
            }
            if (slot == 1 && stackitem instanceof ItemChase) {
                return true;
            }
        }
        return false;
    }

    public String func_70005_c_() {
        return "TypesettingTable";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.bookIsSaved = nbt.func_74767_n("savedbook");
        this.nameofbook = nbt.func_74779_i("SavedBookName");
        this.listofbooks = nbt.func_74779_i("ListOfBooks");
        this.listofAuthors = nbt.func_74779_i("listofAuthors");
        this.listofPublicBooks = nbt.func_74779_i("listofPublicBooks");
        this.requiredlevels = nbt.func_74762_e("levelreq");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a("savedbook", this.bookIsSaved);
        nbt.func_74778_a("SavedBookName", this.nameofbook);
        nbt.func_74778_a("ListOfBooks", this.listofbooks);
        nbt.func_74778_a("listofAuthors", this.listofAuthors);
        nbt.func_74778_a("listofPublicBooks", this.listofPublicBooks);
        nbt.func_74768_a("levelreq", this.requiredlevels);
        return nbt;
    }

    public IChatComponent func_145748_c_() {
        ChatComponentText chat = new ChatComponentText(this.func_70005_c_());
        return chat;
    }
}

