/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.ForbiddenTileHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemTile;

public class ItemEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        EntityItem eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof EntityItem && (item = (stack = (eitem = (EntityItem)e).func_92059_d()).func_77973_b()) == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            BlockPos pos;
            BlockPos finalPos = pos = eitem.func_180425_c();
            Block block = ItemTile.getBlock(stack);
            if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !block.func_176196_c(world, pos)) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos offsetPos = pos.func_177972_a(facing);
                    if (!world.func_180495_p(offsetPos).func_177230_c().func_176200_f((IBlockAccess)world, offsetPos) || !block.func_176196_c(world, offsetPos)) continue;
                    finalPos = offsetPos;
                    break;
                }
            }
            world.func_175656_a(finalPos, ItemTile.getBlockState(stack));
            TileEntity tile = world.func_175625_s(finalPos);
            tile.func_145839_a(ItemTile.getTileData(stack));
            tile.func_174878_a(finalPos);
            ItemTile.clearTileData(stack);
            eitem.func_92058_a(ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        IBlockState state = world.func_180495_p(pos);
        if (main.func_190926_b() && off.func_190926_b() && player.func_70093_af() && !ForbiddenTileHandler.isForbidden(block)) {
            double distance;
            ItemStack stack = new ItemStack(RegistrationHandler.itemTile);
            TileEntity te = world.func_175625_s(pos);
            if ((CarryOnConfig.settings.pickupAllBlocks || te != null) && (block.func_176195_g(state, world, pos) != -1.0f || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0) && !ItemTile.isLocked(pos, world) && ItemTile.storeTileData(te, world, pos, state.func_185899_b((IBlockAccess)world, pos), stack)) {
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                player.func_184611_a(EnumHand.MAIN_HAND, stack);
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }
}

