/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.config;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.helper.ReflectionUtil;

@Config(modid="carryon")
public class CarryOnConfig {
    @Config.LangKey(value="carryon")
    @Config.Comment(value={"General Mod Settings"})
    public static Configs.Settings settings = new Configs.Settings();
    @Config.LangKey(value="carryon")
    @Config.Comment(value={"Tile Entities that the Player is not allowed to pick up"})
    public static Configs.ForbiddenTiles forbiddenTiles = new Configs.ForbiddenTiles();
    @Config.LangKey(value="carryon")
    @Config.Comment(value={"Model Overrides based on NBT or on Meta. Advanced Users Only!"})
    public static Configs.ModelOverrides modelOverrides = new Configs.ModelOverrides();

    @Mod.EventBusSubscriber
    public static class EventHandler {
        private static final MethodHandle CONFIGS_GETTER = ReflectionUtil.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "carryon.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "carryon.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    entryOptional.ifPresent(stringConfigurationEntry -> {
                        configuration = (Configuration)stringConfigurationEntry.getValue();
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("carryon")) {
                ConfigManager.load((String)"carryon", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

