/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemTile;

public class RenderEvents {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onScroll(MouseEvent event) {
        ItemStack stack;
        if ((event.getDwheel() > 0 || event.getDwheel() < 0) && (stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca()) != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() != null) {
            boolean inventory = event.getGui() instanceof GuiContainer;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (inventory && stack != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
                    event.setCanceled(true);
                    Minecraft.func_71410_x().field_71462_r = null;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void inputEvent(InputEvent event) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        Field field = KeyBinding.class.getDeclaredFields()[7];
        field.setAccessible(true);
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            if (settings.field_74316_C.func_151468_f()) {
                field.set(settings.field_74316_C, false);
            }
            if (settings.field_186718_X.func_151468_f()) {
                field.set(settings.field_186718_X, false);
            }
            for (KeyBinding keyBind : settings.field_151456_ac) {
                if (!keyBind.func_151468_f()) continue;
                field.set(keyBind, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AbstractClientPlayer aplayer = (AbstractClientPlayer)player;
        ItemStack stack = player.func_184614_ca();
        int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        if (stack != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            Block block = ItemTile.getBlock(stack);
            BlockPos pos = player.func_180425_c();
            NBTTagCompound tag = ItemTile.getTileData(stack);
            IBlockState state = ItemTile.getBlockState(stack);
            ItemStack tileStack = ItemTile.getItemStack(stack);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)2.5, (double)2.5, (double)2.5);
            GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)-1.0);
            if (CarryOnConfig.settings.facePlayer ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (perspective == 0) {
                Minecraft.func_71410_x().func_175599_af().func_180454_a(tileStack == null ? stack : tileStack, ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileStack, (World)world, (EntityLivingBase)player));
            }
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            if (perspective == 0) {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(false);
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager manager = mc.func_175598_ae();
            RenderPlayer renderPlayer = (RenderPlayer)manager.getSkinMap().get(aplayer.func_175154_l());
            ModelPlayer modelPlayer = renderPlayer.func_177087_b();
            modelPlayer.field_178724_i.field_78807_k = false;
            modelPlayer.field_178723_h.field_78807_k = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayer player = event.getEntityPlayer();
        ModelPlayer modelPlayer = event.getRenderer().func_177087_b();
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (stack != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            Block block = ItemTile.getBlock(stack);
            IBlockState state = ItemTile.getBlockState(stack);
            NBTTagCompound tag = ItemTile.getTileData(stack);
            ItemStack tileItem = ItemTile.getItemStack(stack);
            EntityItem entityItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0);
            entityItem.field_70290_d = 0.0f;
            entityItem.func_92058_a(tileItem);
            float rotation = -player.field_70761_aq;
            int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            double xOffset = player.field_70165_t - clientPlayer.field_70165_t;
            double yOffset = player.field_70163_u - clientPlayer.field_70163_u;
            double zOffset = player.field_70161_v - clientPlayer.field_70161_v;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)zOffset);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            if (CarryOnConfig.settings.facePlayer ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)1.6, (double)0.65);
            } else {
                GlStateManager.func_179114_b((float)(rotation + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)1.6, (double)-0.65);
            }
            if (player.func_70093_af()) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.3, (double)0.0);
            }
            IBakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileItem, (World)world, (EntityLivingBase)player);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(tileItem == null ? stack : tileItem, model);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        } else {
            modelPlayer.field_178724_i.field_78807_k = false;
            modelPlayer.field_178723_h.field_78807_k = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        AbstractClientPlayer aplayer = (AbstractClientPlayer)player;
        ItemStack stack = player.func_184614_ca();
        ModelPlayer model = event.getRenderer().func_177087_b();
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        ResourceLocation skinLoc = DefaultPlayerSkin.func_177334_a((UUID)player.getPersistentID());
        if (stack != null && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            model.field_178724_i.field_78807_k = true;
            model.field_178723_h.field_78807_k = true;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skinLoc);
            float rotation = -player.field_70761_aq;
            ModelRenderer fakeLeftArm = new ModelRenderer((ModelBase)model, 32, 48);
            if (aplayer.func_175154_l().equals("default")) {
                fakeLeftArm.func_78790_a(model.field_178724_i.field_82906_o + 4.2f, model.field_178724_i.field_82908_p, model.field_178724_i.field_82907_q, 4, 12, 4, 0.08f);
            } else {
                fakeLeftArm.func_78790_a(model.field_178724_i.field_82906_o + 4.2f, model.field_178724_i.field_82908_p, model.field_178724_i.field_82907_q, 3, 12, 4, 0.08f);
            }
            ModelRenderer fakeRightArm = new ModelRenderer((ModelBase)model, 40, 16);
            if (aplayer.func_175154_l().equals("default")) {
                fakeRightArm.func_78790_a(model.field_178723_h.field_82906_o - 7.9f, model.field_178723_h.field_82908_p, model.field_178723_h.field_82907_q, 4, 12, 4, 0.08f);
            } else {
                fakeRightArm.func_78790_a(model.field_178723_h.field_82906_o - 7.2f, model.field_178723_h.field_82908_p, model.field_178723_h.field_82907_q, 3, 12, 4, 0.08f);
            }
            fakeRightArm.field_78795_f = -0.9f;
            fakeLeftArm.field_78795_f = -0.9f;
            model.field_78115_e.func_78792_a(fakeLeftArm);
            model.field_78115_e.func_78792_a(fakeRightArm);
        } else {
            model.field_178724_i.field_78807_k = false;
            model.field_178723_h.field_78807_k = false;
            if (model.field_78115_e.field_78805_m != null && !model.field_78115_e.field_78805_m.isEmpty()) {
                model.field_78115_e.field_78805_m.clear();
            }
        }
        if (stack == null || stack.func_77973_b() != RegistrationHandler.itemTile || !ItemTile.hasTileData(stack)) {
            model.field_178724_i.field_78807_k = false;
            model.field_178723_h.field_78807_k = false;
        }
    }

    public static boolean isChest(Block block) {
        return block == Blocks.field_150486_ae || block == Blocks.field_150477_bB || block == Blocks.field_150447_bR;
    }

    @SideOnly(value=Side.CLIENT)
    private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
    }

    @SideOnly(value=Side.CLIENT)
    private static ModelPlayer getPlayerModel(AbstractClientPlayer player) {
        return RenderEvents.getRenderPlayer(player).func_177087_b();
    }
}

