/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.worldgen;

import com.inventorypets.InventoryPets;
import com.inventorypets.worldgen.WorldGenDungeon;
import com.inventorypets.worldgen.WorldGenSeaCave;
import com.inventorypets.worldgen.WorldGenSkyDungeon;
import com.inventorypets.worldgen.WorldGenTreeTop;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenInventoryPets
implements IWorldGenerator {
    private int genFlag = 0;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int BlockX, int BlockZ) {
        Biome biomegenbase = world.func_180494_b(new BlockPos(BlockX, 60, BlockZ));
        BlockPos bposchk = new BlockPos(BlockX, 0, BlockZ);
        if (!InventoryPets.disableAllDungeons && world.func_72912_H().func_76067_t() != WorldType.field_77138_c) {
            int Ycoord;
            int Zcoord;
            int Xcoord;
            int i;
            boolean makeDungeon;
            int fud;
            int ftt;
            int dir;
            int fsd;
            if (!InventoryPets.disableSkyDungeons && (fsd = InventoryPets.frequencySkyDungeons) > 0 && fsd <= 10) {
                fsd *= fsd;
                int dm = random.nextInt(800);
                if (dm <= fsd) {
                    dir = random.nextInt(2);
                    dir = dir == 0 ? 1 : -1;
                    int RandPosX = BlockX + random.nextInt(7) * dir;
                    int RandPosY = 150;
                    int RandPosZ = BlockZ + random.nextInt(7) * dir;
                    new WorldGenSkyDungeon().func_180709_b(world, random, new BlockPos(RandPosX, RandPosY, RandPosZ));
                }
            }
            if (!InventoryPets.disableTreeTops && (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && (ftt = InventoryPets.frequencyTreeTops) > 0 && ftt <= 10) {
                for (int i2 = 0; i2 < ftt; ++i2) {
                    dir = random.nextInt(2);
                    dir = dir == 0 ? 1 : -1;
                    int Xcoord2 = BlockX + (random.nextInt(3) + 3) * dir;
                    int Zcoord2 = BlockZ + (random.nextInt(3) + 3) * dir;
                    int Ycoord2 = 60 + random.nextInt(60);
                    new WorldGenTreeTop(false).func_180709_b(world, random, new BlockPos(Xcoord2, Ycoord2, Zcoord2));
                }
            }
            if (!InventoryPets.disableSeaCaveDungeons && BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextBoolean()) {
                fud = InventoryPets.frequencySeaCaveDungeons;
                makeDungeon = true;
                if (fud > 0 && fud <= 10) {
                    for (i = 10; i > fud; --i) {
                        if (random.nextBoolean()) continue;
                        makeDungeon = false;
                    }
                }
                if (makeDungeon) {
                    Xcoord = BlockX;
                    Zcoord = BlockZ;
                    Ycoord = random.nextInt(10);
                    Ycoord = 62;
                    new WorldGenSeaCave().func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                }
            }
            if (!InventoryPets.disableUndergroundDungeons && random.nextBoolean()) {
                fud = InventoryPets.frequencyUndergroundDungeons;
                makeDungeon = true;
                if (fud > 0 && fud <= 10) {
                    for (i = 11; i > fud; --i) {
                        if (random.nextBoolean()) continue;
                        makeDungeon = false;
                    }
                }
                if (makeDungeon) {
                    Xcoord = BlockX;
                    Zcoord = BlockZ;
                    Ycoord = random.nextInt(10);
                    Ycoord = 10 + Ycoord;
                    new WorldGenDungeon().func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                }
            }
        }
    }
}

