/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import java.util.Arrays;

public class FluidTypeHandler {

    public static enum FluidType {
        NONE(0x888888, 0x888888, 0, 1, 1, "hbmfluid.none"),
        WATER(0x3333FF, 0x3333FF, 1, 1, 1, "hbmfluid.water"),
        STEAM(0xE5E5E5, 0xE5E5E5, 9, 2, 1, "hbmfluid.steam"),
        HOTSTEAM(15193814, 15193814, 1, 1, 2, "hbmfluid.hotsteam"),
        SUPERHOTSTEAM(0xE7B7B7, 0xE7B7B7, 2, 1, 2, "hbmfluid.superhotsteam"),
        COOLANT(14220543, 14220543, 2, 1, 1, "hbmfluid.coolant"),
        LAVA(0xFF3300, 0xFF3300, 3, 1, 1, "hbmfluid.lava"),
        DEUTERIUM(255, 255, 4, 1, 1, "hbmfluid.deuterium"),
        TRITIUM(153, 153, 5, 1, 1, "hbmfluid.tritium"),
        OIL(131586, 131586, 6, 1, 1, "hbmfluid.oil"),
        HOTOIL(0x300900, 0x300900, 8, 2, 1, "hbmfluid.hotoil"),
        HEAVYOIL(1315602, 1315602, 2, 2, 1, "hbmfluid.heavyoil"),
        BITUMEN(2040870, 2040870, 3, 2, 1, "hbmfluid.bitumen"),
        SMEAR(1642241, 1642241, 7, 1, 1, "hbmfluid.smear"),
        HEATINGOIL(2168838, 2168838, 4, 2, 1, "hbmfluid.heatingoil"),
        RECLAIMED(0x332B22, 0x332B22, 8, 1, 1, "hbmfluid.reclaimed"),
        PETROIL(4473149, 4473149, 9, 1, 1, "hbmfluid.petroil"),
        LUBRICANT(0x606060, 0x606060, 10, 1, 1, "hbmfluid.lubricant"),
        NAPHTHA(5855044, 5855044, 5, 2, 1, "hbmfluid.naphtha"),
        DIESEL(15920853, 15920853, 11, 1, 1, "hbmfluid.diesel"),
        LIGHTOIL(9204817, 9204817, 6, 2, 1, "hbmfluid.lightoil"),
        KEROSENE(16754130, 16754130, 12, 1, 1, "hbmfluid.kerosene"),
        GAS(0xFFFEED, 0xFFFEED, 13, 1, 1, "hbmfluid.gas"),
        PETROLEUM(8173513, 8173513, 7, 2, 1, "hbmfluid.petroleum"),
        BIOGAS(12571516, 12571516, 12, 2, 1, "hbmfluid.biogas"),
        BIOFUEL(15659636, 15659636, 13, 2, 1, "hbmfluid.biofuel"),
        NITAN(8394925, 8394925, 15, 2, 1, "hbmfluid.nitan"),
        UF6(13749950, 13749950, 14, 1, 1, "hbmfluid.uf6"),
        PUF6(0x4C4C4C, 0x4C4C4C, 15, 1, 1, "hbmfluid.puf6"),
        SAS3(0x4FFFFC, 0x4FFFFC, 14, 2, 1, "hbmfluid.sas3"),
        AMAT(65793, 65793, 0, 2, 1, "hbmfluid.amat"),
        ASCHRAB(0xB50000, 0xB50000, 1, 2, 1, "hbmfluid.aschrab"),
        ACID(0xFFF7AA, 0xFFF7AA, 10, 2, 1, "hbmfluid.acid"),
        WATZ(8807742, 8807742, 11, 2, 1, "hbmfluid.watz"),
        CRYOGEL(0x32FFFF, 0x32FFFF, 0, 1, 2, "hbmfluid.cryogel");

        private int color;
        private int msa;
        private int textureX;
        private int textureY;
        private int sheetID;
        private String name;

        private FluidType(int color, int msa, int x, int y, int sheet, String name) {
            this.color = color;
            this.msa = msa;
            this.textureX = x;
            this.textureY = y;
            this.name = name;
            this.sheetID = sheet;
        }

        public int getColor() {
            return this.color;
        }

        public int getMSAColor() {
            return this.msa;
        }

        public int textureX() {
            return this.textureX;
        }

        public int textureY() {
            return this.textureY;
        }

        public int getSheetID() {
            return this.sheetID;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public static FluidType getEnum(int i) {
            if (i < FluidType.values().length) {
                return FluidType.values()[i];
            }
            return NONE;
        }

        public static FluidType getEnumFromName(String s) {
            for (int i = 0; i < FluidType.values().length; ++i) {
                if (!FluidType.values()[i].getName().equals(s)) continue;
                return FluidType.values()[i];
            }
            return NONE;
        }

        public int getID() {
            return Arrays.asList(FluidType.values()).indexOf((Object)this);
        }

        public String getName() {
            return this.toString();
        }
    }
}

