/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.inventory.MachineRecipes;
import com.hbm.inventory.gui.GUIMachineReactor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ReactorRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<Fuel> fuels;

    public String getRecipeName() {
        return "Breeding Reactor";
    }

    public String getGuiTexture() {
        return GUIMachineReactor.texture.toString();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("breeding") && ((Object)((Object)this)).getClass() == ReactorRecipeHandler.class) {
            Map<Object, Object> recipes = MachineRecipes.instance().getReactorRecipes();
            for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<Object, Object> recipes = MachineRecipes.instance().getReactorRecipes();
        for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("breeding") && ((Object)((Object)this)).getClass() == ReactorRecipeHandler.class) {
            this.loadCraftingRecipes("breeding", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<Object, Object> recipes = MachineRecipes.instance().getReactorRecipes();
        for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)ingredient, (ItemStack)((ItemStack)recipe.getKey()))) continue;
            this.arecipes.add(new SmeltingSet((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUIMachineReactor.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "breeding", new Object[0]));
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(50, 24, 176, 0, 14, 14, 144, 7);
        this.drawProgressBar(74, 23, 176, 16, 24, 16, 48, 0);
    }

    public TemplateRecipeHandler newInstance() {
        if (fuels == null || fuels.isEmpty()) {
            fuels = new ArrayList();
        }
        for (ItemStack i : MachineRecipes.instance().getReactorFuels()) {
            fuels.add(new Fuel(i));
        }
        return super.newInstance();
    }

    public static class Fuel {
        public PositionedStack stack;

        public Fuel(ItemStack ingred) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
        }
    }

    public class SmeltingSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack result;

        public SmeltingSet(ItemStack input, ItemStack result) {
            super((TemplateRecipeHandler)ReactorRecipeHandler.this);
            input.field_77994_a = 1;
            this.input = new PositionedStack((Object)input, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ReactorRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public PositionedStack getOtherStack() {
            return ReactorRecipeHandler.fuels.get((int)(ReactorRecipeHandler.this.cycleticks / 48 % ReactorRecipeHandler.fuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

