/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ModItems;
import com.hbm.items.gear.JetpackBooster;
import com.hbm.items.gear.JetpackBreak;
import com.hbm.items.gear.JetpackRegular;
import com.hbm.items.gear.JetpackVectorized;
import com.hbm.items.tool.ItemFluidIdentifier;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFluidPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class FluidTank {
    FluidTypeHandler.FluidType type;
    int fluid;
    int maxFluid;
    public int index;
    public static int x = 16;
    public static int y = 100;

    public FluidTank(FluidTypeHandler.FluidType type, int maxFluid, int index) {
        this.type = type;
        this.maxFluid = maxFluid;
        this.index = index;
    }

    public void setFill(int i) {
        this.fluid = i;
    }

    public void setTankType(FluidTypeHandler.FluidType type) {
        if (this.type.name().equals(type.name())) {
            return;
        }
        this.type = type;
        this.setFill(0);
    }

    public FluidTypeHandler.FluidType getTankType() {
        return this.type;
    }

    public int getFill() {
        return this.fluid;
    }

    public int getMaxFill() {
        return this.maxFluid;
    }

    public int changeTankSize(int size) {
        this.maxFluid = size;
        if (this.fluid > this.maxFluid) {
            int dif = this.fluid - this.maxFluid;
            this.fluid = this.maxFluid;
            return dif;
        }
        return 0;
    }

    public void updateTank(int x, int y, int z) {
        PacketDispatcher.wrapper.sendToAll((IMessage)new TEFluidPacket(x, y, z, this.fluid, this.index, this.type));
    }

    public void loadTank(int in, int out, ItemStack[] slots) {
        FluidTypeHandler.FluidType inType = FluidTypeHandler.FluidType.NONE;
        if (slots[in] != null) {
            inType = FluidContainerRegistry.getFluidType(slots[in]);
            if (slots[in].func_77973_b() == ModItems.fluid_barrel_infinite) {
                this.fluid = this.maxFluid;
                return;
            }
            if (slots[in].func_77973_b() == ModItems.inf_water && this.type.name().equals(FluidTypeHandler.FluidType.WATER.name())) {
                this.fluid += 50;
                if (this.fluid > this.maxFluid) {
                    this.fluid = this.maxFluid;
                }
                return;
            }
            if (FluidContainerRegistry.getFluidContent(slots[in], this.type) <= 0) {
                return;
            }
        } else {
            return;
        }
        if (slots[in] != null && inType.name().equals(this.type.name()) && this.fluid + FluidContainerRegistry.getFluidContent(slots[in], this.type) <= this.maxFluid) {
            if (slots[out] == null) {
                this.fluid += FluidContainerRegistry.getFluidContent(slots[in], this.type);
                slots[out] = FluidContainerRegistry.getEmptyContainer(slots[in]);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
            } else if (slots[out] != null && slots[out].func_77973_b() == FluidContainerRegistry.getEmptyContainer(slots[in]).func_77973_b() && slots[out].field_77994_a < slots[out].func_77976_d()) {
                this.fluid += FluidContainerRegistry.getFluidContent(slots[in], this.type);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
                ++slots[out].field_77994_a;
            }
        }
    }

    public void unloadTank(int in, int out, ItemStack[] slots) {
        ItemStack full = null;
        if (slots[in] != null) {
            for (int i = 0; i < 25; ++i) {
                if (slots[in].func_77973_b() == ModItems.jetpack_boost && this.type.name().equals(FluidTypeHandler.FluidType.KEROSENE.name())) {
                    if (this.fluid > 0 && JetpackBooster.getFuel(slots[in]) < JetpackBooster.maxFuel) {
                        --this.fluid;
                        JetpackBooster.setFuel(slots[in], JetpackBooster.getFuel(slots[in]) + 1);
                        continue;
                    }
                    return;
                }
                if (slots[in].func_77973_b() == ModItems.jetpack_break && this.type.name().equals(FluidTypeHandler.FluidType.KEROSENE.name())) {
                    if (this.fluid > 0 && JetpackBreak.getFuel(slots[in]) < JetpackBreak.maxFuel) {
                        --this.fluid;
                        JetpackBreak.setFuel(slots[in], JetpackBreak.getFuel(slots[in]) + 1);
                        continue;
                    }
                    return;
                }
                if (slots[in].func_77973_b() == ModItems.jetpack_fly && this.type.name().equals(FluidTypeHandler.FluidType.KEROSENE.name())) {
                    if (this.fluid > 0 && JetpackRegular.getFuel(slots[in]) < JetpackRegular.maxFuel) {
                        --this.fluid;
                        JetpackRegular.setFuel(slots[in], JetpackRegular.getFuel(slots[in]) + 1);
                        continue;
                    }
                    return;
                }
                if (slots[in].func_77973_b() != ModItems.jetpack_vector || !this.type.name().equals(FluidTypeHandler.FluidType.KEROSENE.name())) break;
                if (this.fluid > 0 && JetpackVectorized.getFuel(slots[in]) < JetpackVectorized.maxFuel) {
                    --this.fluid;
                    JetpackVectorized.setFuel(slots[in], JetpackVectorized.getFuel(slots[in]) + 1);
                    continue;
                }
                return;
            }
            if (slots[in].func_77973_b() == ModItems.fluid_barrel_infinite) {
                this.fluid = 0;
                return;
            }
            if (slots[in].func_77973_b() == ModItems.inf_water && this.type.name().equals(FluidTypeHandler.FluidType.WATER.name())) {
                this.fluid -= 50;
                if (this.fluid < 0) {
                    this.fluid = 0;
                }
                return;
            }
            full = FluidContainerRegistry.getFullContainer(slots[in], this.type);
        }
        if (full == null) {
            return;
        }
        if (slots[in] != null && this.fluid - FluidContainerRegistry.getFluidContent(full, this.type) >= 0) {
            if (slots[out] == null) {
                this.fluid -= FluidContainerRegistry.getFluidContent(full, this.type);
                slots[out] = full.func_77946_l();
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
            } else if (slots[out] != null && slots[out].func_77973_b() == FluidContainerRegistry.getFullContainer(slots[in], this.type).func_77973_b() && slots[out].field_77994_a < slots[out].func_77976_d()) {
                this.fluid -= FluidContainerRegistry.getFluidContent(full, this.type);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
                ++slots[out].field_77994_a;
            }
        }
    }

    public void setType(int in, int out, ItemStack[] slots) {
        if (slots[in] != null && slots[out] == null && slots[in].func_77973_b() instanceof ItemFluidIdentifier) {
            FluidTypeHandler.FluidType newType = ItemFluidIdentifier.getType(slots[in].func_77946_l());
            if (!this.type.name().equals(newType.name())) {
                this.type = newType;
                slots[out] = slots[in].func_77946_l();
                slots[in] = null;
                this.fluid = 0;
            }
        }
    }

    public void renderTank(GuiContainer gui, int x, int y, int tx, int ty, int width, int height) {
        int i = this.fluid * height / this.maxFluid;
        gui.func_73729_b(x, y - i, tx, ty - i, width, i);
    }

    public void renderTankInfo(GuiContainer gui, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (gui instanceof GuiInfoContainer) {
            this.renderTankInfo((GuiInfoContainer)gui, mouseX, mouseY, x, y, width, height);
        }
    }

    public void renderTankInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (x <= mouseX && x + width > mouseX && y < mouseY && y + height >= mouseY) {
            gui.drawFluidInfo(new String[]{I18n.func_135052_a((String)this.type.getUnlocalizedName(), (Object[])new Object[0]), this.fluid + "/" + this.maxFluid + "mB"}, mouseX, mouseY);
        }
    }

    public ResourceLocation getSheet() {
        return new ResourceLocation("hbm:textures/gui/fluids" + this.type.getSheetID() + ".png");
    }

    public void writeToNBT(NBTTagCompound nbt, String s) {
        nbt.func_74768_a(s, this.fluid);
        nbt.func_74778_a(s + "_type", this.type.getName());
    }

    public void readFromNBT(NBTTagCompound nbt, String s) {
        this.fluid = nbt.func_74762_e(s);
        this.type = FluidTypeHandler.FluidType.getEnum(nbt.func_74762_e(s + "_type"));
        if (this.type.name().equals(FluidTypeHandler.FluidType.NONE.name())) {
            this.type = FluidTypeHandler.FluidType.getEnumFromName(nbt.func_74779_i(s + "_type"));
        }
    }
}

