/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerRadioRec;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityRadioRec;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIRadioRec
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_radiorec.png");
    private TileEntityRadioRec diFurnace;
    private GuiTextField freqField;
    List<RadioButton> buttons = new ArrayList<RadioButton>();

    public GUIRadioRec(InventoryPlayer invPlayer, TileEntityRadioRec tedf) {
        super(new ContainerRadioRec(invPlayer, tedf));
        this.diFurnace = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 54;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttons.clear();
        this.buttons.add(new RadioButton(this.field_147003_i + 25, this.field_147009_r + 16, 0, "Save"));
        this.buttons.add(new RadioButton(this.field_147003_i + 61, this.field_147009_r + 16, 1, "On/Off"));
        Keyboard.enableRepeatEvents((boolean)true);
        this.freqField = new GuiTextField(this.field_146289_q, this.field_147003_i + 100, this.field_147009_r + 21, 48, 12);
        this.freqField.func_146193_g(-1);
        this.freqField.func_146204_h(-1);
        this.freqField.func_146185_a(false);
        this.freqField.func_146203_f(5);
        this.freqField.func_146180_a(String.valueOf(this.diFurnace.freq));
        if (this.diFurnace.freq == 0.0) {
            double d = 100 + this.diFurnace.func_145831_w().field_73012_v.nextInt(900);
            this.freqField.func_146180_a(String.valueOf(d += (double)this.diFurnace.func_145831_w().field_73012_v.nextInt(10) * 0.1));
        }
        this.save();
    }

    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        this.freqField.func_146194_f();
        for (RadioButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = I18n.func_135052_a((String)"container.radiorec", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.freqField.func_146206_l()) {
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 16, 0, 202, 54, 18);
        } else {
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 16, 0, 184, 54, 18);
        }
        for (RadioButton b : this.buttons) {
            b.drawButton();
        }
    }

    public void func_73876_c() {
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.freqField.func_146201_a(p_73869_1_, p_73869_2_)) {
            super.func_73869_a(p_73869_1_, p_73869_2_);
        }
    }

    protected void rectify() {
        String s = this.freqField.func_146179_b();
        if (NumberUtils.isNumber((String)s)) {
            double d = Double.parseDouble(s);
            d = Math.max(100.0, Math.min(999.9, d));
            d = this.truncateDecimal(d, 1).doubleValue();
            s = String.valueOf(d);
        } else {
            s = "100.0";
        }
        this.freqField.func_146180_a(s);
    }

    private BigDecimal truncateDecimal(double x, int numberofDecimals) {
        if (x > 0.0) {
            return new BigDecimal(String.valueOf(x)).setScale(numberofDecimals, 3);
        }
        return new BigDecimal(String.valueOf(x)).setScale(numberofDecimals, 2);
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.freqField.func_146192_a(i, j, k);
        for (RadioButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.executeAction();
        }
    }

    protected void toggle() {
        this.rectify();
        PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.field_145851_c, this.diFurnace.field_145848_d, this.diFurnace.field_145849_e, this.diFurnace.isOn ? 0 : 1, 0));
    }

    protected void save() {
        this.rectify();
        String s = this.freqField.func_146179_b();
        double d = Double.parseDouble(s);
        PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.field_145851_c, this.diFurnace.field_145848_d, this.diFurnace.field_145849_e, (int)(d * 10.0), 1));
    }

    class RadioButton {
        int xPos;
        int yPos;
        int buttonType;
        String info;

        public RadioButton(int x, int y, int t, String i) {
            this.xPos = x;
            this.yPos = y;
            this.buttonType = t;
            this.info = i;
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton() {
            switch (this.buttonType) {
                case 0: {
                    GUIRadioRec.this.func_73729_b(this.xPos, this.yPos, 176, 0, 18, 18);
                    break;
                }
                case 1: {
                    GUIRadioRec.this.func_73729_b(this.xPos, this.yPos, 194, 0, 18, 18);
                }
            }
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            String s = this.info;
            if (this.buttonType == 1) {
                s = ((GUIRadioRec)GUIRadioRec.this).diFurnace.isOn ? "Turn Off" : "Turn On";
            }
            GUIRadioRec.this.func_146283_a(Arrays.asList(s), x, y);
        }

        public void executeAction() {
            GUIRadioRec.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            switch (this.buttonType) {
                case 0: {
                    GUIRadioRec.this.save();
                    break;
                }
                case 1: {
                    GUIRadioRec.this.toggle();
                }
            }
        }
    }
}

