/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerRadiobox;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.tileentity.machine.TileEntityRadiobox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIRadiobox
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_radiobox.png");
    private TileEntityRadiobox diFurnace;
    private int type;
    private int music;
    private GuiTextField freqField;
    private GuiTextField messageField;
    List<RadioButton> buttons = new ArrayList<RadioButton>();

    public GUIRadiobox(InventoryPlayer invPlayer, TileEntityRadiobox tedf) {
        super(new ContainerRadiobox(invPlayer, tedf));
        this.diFurnace = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 90;
        this.type = this.diFurnace.type;
        this.music = this.diFurnace.music;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttons.clear();
        this.buttons.add(new RadioButton(this.field_147003_i + 25, this.field_147009_r + 16, 0, "Save"));
        this.buttons.add(new RadioButton(this.field_147003_i + 61, this.field_147009_r + 16, 1, "Cycle"));
        this.buttons.add(new RadioButton(this.field_147003_i + 25, this.field_147009_r + 52, 2, "1"));
        this.buttons.add(new RadioButton(this.field_147003_i + 61, this.field_147009_r + 52, 3, "2"));
        this.buttons.add(new RadioButton(this.field_147003_i + 97, this.field_147009_r + 52, 4, "3"));
        this.buttons.add(new RadioButton(this.field_147003_i + 133, this.field_147009_r + 52, 5, "4"));
        Keyboard.enableRepeatEvents((boolean)true);
        this.freqField = new GuiTextField(this.field_146289_q, this.field_147003_i + 100, this.field_147009_r + 21, 48, 12);
        this.freqField.func_146193_g(-1);
        this.freqField.func_146204_h(-1);
        this.freqField.func_146185_a(false);
        this.freqField.func_146203_f(5);
        this.freqField.func_146180_a(String.valueOf(this.diFurnace.freq));
        this.messageField = new GuiTextField(this.field_146289_q, this.field_147003_i + 28, this.field_147009_r + 57, 120, 12);
        this.messageField.func_146193_g(-1);
        this.messageField.func_146204_h(-1);
        this.messageField.func_146185_a(false);
        this.messageField.func_146203_f(20);
        if (this.diFurnace.message != null) {
            this.messageField.func_146180_a(this.diFurnace.message);
        }
        if (this.diFurnace.freq == 0.0) {
            double d = 100 + this.diFurnace.func_145831_w().field_73012_v.nextInt(900);
            this.freqField.func_146180_a(String.valueOf(d += (double)this.diFurnace.func_145831_w().field_73012_v.nextInt(10) * 0.1));
        }
        this.rectify();
    }

    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        this.freqField.func_146194_f();
        this.messageField.func_146194_f();
        for (RadioButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = I18n.func_135052_a((String)"container.radiobox", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.freqField.func_146206_l()) {
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 16, 0, 202, 54, 18);
        } else {
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 16, 0, 184, 54, 18);
        }
        if (this.messageField.func_146176_q()) {
            if (this.messageField.func_146206_l()) {
                this.func_73729_b(this.field_147003_i + 25, this.field_147009_r + 52, 0, 238, 126, 18);
            } else {
                this.func_73729_b(this.field_147003_i + 25, this.field_147009_r + 52, 0, 220, 126, 18);
            }
        }
        for (RadioButton b : this.buttons) {
            b.drawButton();
        }
    }

    public void func_73876_c() {
        if (this.type == 2 && this.messageField.func_146176_q()) {
            this.messageField.func_146189_e(false);
        }
        if (this.type != 2 && !this.messageField.func_146176_q()) {
            this.messageField.func_146189_e(true);
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.freqField.func_146201_a(p_73869_1_, p_73869_2_) && !this.messageField.func_146201_a(p_73869_1_, p_73869_2_)) {
            super.func_73869_a(p_73869_1_, p_73869_2_);
        }
    }

    protected void rectify() {
        String s = this.freqField.func_146179_b();
        if (NumberUtils.isNumber((String)s)) {
            double d = Double.parseDouble(s);
            d = Math.max(100.0, Math.min(999.9, d));
            d = this.truncateDecimal(d, 1).doubleValue();
            s = String.valueOf(d);
        } else {
            s = "100.0";
        }
        this.freqField.func_146180_a(s);
    }

    private BigDecimal truncateDecimal(double x, int numberofDecimals) {
        if (x > 0.0) {
            return new BigDecimal(String.valueOf(x)).setScale(numberofDecimals, 3);
        }
        return new BigDecimal(String.valueOf(x)).setScale(numberofDecimals, 2);
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.freqField.func_146192_a(i, j, k);
        this.messageField.func_146192_a(i, j, k);
        for (RadioButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.executeAction();
        }
    }

    protected void cycleType() {
        ++this.type;
        if (this.type >= 3) {
            this.type -= 3;
        }
    }

    protected void save() {
        this.rectify();
    }

    class RadioButton {
        int xPos;
        int yPos;
        int buttonType;
        String info;

        public RadioButton(int x, int y, int t, String i) {
            this.xPos = x;
            this.yPos = y;
            this.buttonType = t;
            this.info = i;
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton() {
            if (this.buttonType > 1 && GUIRadiobox.this.type != 2) {
                return;
            }
            switch (this.buttonType) {
                case 0: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 176, 0, 18, 18);
                    break;
                }
                case 1: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 176 + 18 * (GUIRadiobox.this.type + 1), 0, 18, 18);
                    break;
                }
                case 2: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 176, 18 * (GUIRadiobox.this.music == 0 ? 2 : 1), 18, 18);
                    break;
                }
                case 3: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 194, 18 * (GUIRadiobox.this.music == 1 ? 2 : 1), 18, 18);
                    break;
                }
                case 4: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 212, 18 * (GUIRadiobox.this.music == 2 ? 2 : 1), 18, 18);
                    break;
                }
                case 5: {
                    GUIRadiobox.this.func_73729_b(this.xPos, this.yPos, 230, 18 * (GUIRadiobox.this.music == 3 ? 2 : 1), 18, 18);
                }
            }
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            if (this.buttonType > 1 && GUIRadiobox.this.type != 2) {
                return;
            }
            String s = this.info;
            if (this.buttonType == 1) {
                switch (GUIRadiobox.this.type) {
                    case 0: {
                        s = "Morse";
                        break;
                    }
                    case 1: {
                        s = "Vocals";
                        break;
                    }
                    case 2: {
                        s = "Recordings";
                    }
                }
            }
            GUIRadiobox.this.func_146283_a(Arrays.asList(s), x, y);
        }

        public void executeAction() {
            if (this.buttonType > 1 && GUIRadiobox.this.type != 2) {
                return;
            }
            GUIRadiobox.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            switch (this.buttonType) {
                case 0: {
                    GUIRadiobox.this.rectify();
                    break;
                }
                case 1: {
                    GUIRadiobox.this.cycleType();
                    break;
                }
                case 2: {
                    GUIRadiobox.this.music = 0;
                    break;
                }
                case 3: {
                    GUIRadiobox.this.music = 1;
                    break;
                }
                case 4: {
                    GUIRadiobox.this.music = 2;
                    break;
                }
                case 5: {
                    GUIRadiobox.this.music = 3;
                }
            }
        }
    }
}

