/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.FluidTank;
import com.hbm.inventory.container.ContainerReactorMultiblock;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityMachineReactorLarge;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIReactorMultiblock
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_reactor_large_experimental.png");
    private TileEntityMachineReactorLarge diFurnace;

    public GUIReactorMultiblock(InventoryPlayer invPlayer, TileEntityMachineReactorLarge tedf) {
        super(new ContainerReactorMultiblock(invPlayer, tedf));
        this.diFurnace = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.diFurnace.tanks[0].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 88 - 52, 16, 52);
        this.diFurnace.tanks[1].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 26, this.field_147009_r + 88 - 52, 16, 52);
        this.diFurnace.tanks[2].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 80, this.field_147009_r + 108, 88, 4);
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 80, this.field_147009_r + 114, 88, 4, new String[]{"Hull Temperature:", "   " + Math.round((double)this.diFurnace.hullHeat * 1.0E-5 * 980.0 + 20.0) + "\u00b0C"});
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 80, this.field_147009_r + 120, 88, 4, new String[]{"Core Temperature:", "   " + Math.round((double)this.diFurnace.coreHeat * 2.0E-5 * 980.0 + 20.0) + "\u00b0C"});
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 115, this.field_147009_r + 17, 18, 90, new String[]{"Operating Level: " + this.diFurnace.rods + "%"});
        String fuel = "";
        switch (this.diFurnace.type) {
            case URANIUM: {
                fuel = "Uranium";
                break;
            }
            case MOX: {
                fuel = "MOX";
                break;
            }
            case PLUTONIUM: {
                fuel = "Plutonium";
                break;
            }
            case SCHRABIDIUM: {
                fuel = "Schrabidium";
                break;
            }
            case THORIUM: {
                fuel = "Thorium";
                break;
            }
            default: {
                fuel = "ERROR";
            }
        }
        String[] stringArray = new String[1];
        stringArray[0] = fuel + ": " + this.diFurnace.fuel / TileEntityMachineReactorLarge.fuelMult + "/" + this.diFurnace.maxFuel / TileEntityMachineReactorLarge.fuelMult + "ng";
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 98, this.field_147009_r + 18, 16, 88, stringArray);
        String[] stringArray2 = new String[1];
        stringArray2[0] = "Depleted " + fuel + ": " + this.diFurnace.waste / TileEntityMachineReactorLarge.fuelMult + "/" + this.diFurnace.maxWaste / TileEntityMachineReactorLarge.fuelMult + "ng";
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 134, this.field_147009_r + 18, 16, 88, stringArray2);
        String[] text0 = new String[]{this.diFurnace.rods > 0 ? "Reactor is ON" : "Reactor is OFF"};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 52, this.field_147009_r + 53, 18, 18, mouseX, mouseY, text0);
        String s = "0";
        switch (this.diFurnace.tanks[2].getTankType()) {
            case STEAM: {
                s = "1x";
                break;
            }
            case HOTSTEAM: {
                s = "10x";
                break;
            }
            case SUPERHOTSTEAM: {
                s = "100x";
            }
        }
        String[] text4 = new String[]{"Steam compression switch", "Current compression level: " + s};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 63, this.field_147009_r + 107, 14, 18, mouseX, mouseY, text4);
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 115 <= x && this.field_147003_i + 115 + 18 > x && this.field_147009_r + 17 < y && this.field_147009_r + 17 + 90 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            int rods = (y - (this.field_147009_r + 24)) * 100 / 76;
            if (rods < 0) {
                rods = 0;
            }
            if (rods > 100) {
                rods = 100;
            }
            rods = 100 - rods;
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.field_145851_c, this.diFurnace.field_145848_d, this.diFurnace.field_145849_e, rods, 0));
        }
        if (this.field_147003_i + 63 <= x && this.field_147003_i + 63 + 14 > x && this.field_147009_r + 107 < y && this.field_147009_r + 107 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            int c = 0;
            switch (this.diFurnace.tanks[2].getTankType()) {
                case STEAM: {
                    c = 0;
                    break;
                }
                case HOTSTEAM: {
                    c = 1;
                    break;
                }
                case SUPERHOTSTEAM: {
                    c = 2;
                }
            }
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.field_145851_c, this.diFurnace.field_145848_d, this.diFurnace.field_145849_e, c, 1));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.diFurnace.func_145818_k_() ? this.diFurnace.func_145825_b() : I18n.func_135052_a((String)this.diFurnace.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = this.diFurnace.rods;
        this.func_73729_b(this.field_147003_i + 115, this.field_147009_r + 107 - 14 - k * 76 / 100, 208, 36, 18, 14);
        if (this.diFurnace.rods > 0) {
            this.func_73729_b(this.field_147003_i + 52, this.field_147009_r + 53, 212, 0, 18, 18);
        }
        int q = this.diFurnace.getFuelScaled(88);
        this.func_73729_b(this.field_147003_i + 98, this.field_147009_r + 106 - q, 176, 124 - q, 16, q);
        int j = this.diFurnace.getWasteScaled(88);
        this.func_73729_b(this.field_147003_i + 134, this.field_147009_r + 106 - j, 192, 124 - j, 16, j);
        int s = this.diFurnace.size;
        if (s < 8) {
            this.func_73729_b(this.field_147003_i + 50, this.field_147009_r + 17, 208, 50 + s * 18, 22, 18);
        } else {
            this.func_73729_b(this.field_147003_i + 50, this.field_147009_r + 17, 230, 50 + (s - 8) * 18, 22, 18);
        }
        switch (this.diFurnace.tanks[2].getTankType()) {
            case STEAM: {
                this.func_73729_b(this.field_147003_i + 63, this.field_147009_r + 107, 176, 18, 14, 18);
                break;
            }
            case HOTSTEAM: {
                this.func_73729_b(this.field_147003_i + 63, this.field_147009_r + 107, 190, 18, 14, 18);
                break;
            }
            case SUPERHOTSTEAM: {
                this.func_73729_b(this.field_147003_i + 63, this.field_147009_r + 107, 204, 18, 14, 18);
            }
        }
        if (this.diFurnace.hasHullHeat()) {
            i = this.diFurnace.getHullHeatScaled(88);
            i = Math.min(i, 160);
            this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 114, 0, 226, i, 4);
        }
        if (this.diFurnace.hasCoreHeat()) {
            i = this.diFurnace.getCoreHeatScaled(88);
            i = Math.min(i, 160);
            this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 120, 0, 230, i, 4);
        }
        if (this.diFurnace.tanks[2].getFill() > 0) {
            i = this.diFurnace.getSteamScaled(88);
            int offset = 234;
            switch (this.diFurnace.tanks[2].getTankType()) {
                case HOTSTEAM: {
                    offset += 4;
                    break;
                }
                case SUPERHOTSTEAM: {
                    offset += 8;
                }
            }
            this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 108, 0, offset, i, 4);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.diFurnace.tanks[0].getSheet());
        this.diFurnace.tanks[0].renderTank(this, this.field_147003_i + 8, this.field_147009_r + 88, this.diFurnace.tanks[0].getTankType().textureX() * FluidTank.x, this.diFurnace.tanks[0].getTankType().textureY() * FluidTank.y, 16, 52);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.diFurnace.tanks[1].getSheet());
        this.diFurnace.tanks[1].renderTank(this, this.field_147003_i + 26, this.field_147009_r + 88, this.diFurnace.tanks[1].getTankType().textureX() * FluidTank.x, this.diFurnace.tanks[1].getTankType().textureY() * FluidTank.y, 16, 52);
    }
}

