/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemSatChip;
import com.hbm.items.tool.ItemSatInterface;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.SatLaserPacket;
import com.hbm.saveddata.SatelliteSaveStructure;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GUIScreenSatInterface
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_sat_interface.png");
    protected int xSize = 216;
    protected int ySize = 216;
    protected int guiLeft;
    protected int guiTop;
    private final EntityPlayer player;
    protected SatelliteSaveStructure connectedSat;
    int x;
    int z;
    private int scanPos = 0;
    private long lastMilli = 0L;
    private int[][] map = new int[200][200];

    public GUIScreenSatInterface(EntityPlayer player) {
        this.player = player;
    }

    public void func_73876_c() {
    }

    protected void func_73864_a(int i, int j, int k) {
        if (this.connectedSat != null && this.connectedSat.satelliteType == SatelliteSaveStructure.SatelliteType.LASER && i >= this.guiLeft + 8 && i < this.guiLeft + 208 && j >= this.guiTop + 8 && j < this.guiTop + 208 && this.player != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("hbm:item.techBleep"), (float)1.0f));
            int x = this.x - this.guiLeft + i - 8 - 100;
            int z = this.z - this.guiTop + j - 8 - 100;
            PacketDispatcher.wrapper.sendToServer((IMessage)new SatLaserPacket(x, z, this.connectedSat.satelliteID));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.x = (int)this.player.field_70165_t;
        this.z = (int)this.player.field_70161_v;
        if (ItemSatInterface.satData != null && this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() == ModItems.sat_interface) {
            int freq = ItemSatChip.getFreq(this.player.func_70694_bm());
            this.connectedSat = ItemSatInterface.satData.getSatFromFreq(freq);
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        if (this.connectedSat != null && this.connectedSat.satelliteType == SatelliteSaveStructure.SatelliteType.LASER && i >= this.guiLeft + 8 && i < this.guiLeft + 208 && j >= this.guiTop + 8 && j < this.guiTop + 208 && this.player != null) {
            int x = this.x - this.guiLeft + i - 8 - 100;
            int z = this.z - this.guiTop + j - 8 - 100;
            this.func_146283_a(Arrays.asList(x + " / " + z), i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.connectedSat == null) {
            this.drawNotConnected();
        } else if (this.connectedSat.satDim != this.player.field_71093_bK) {
            this.drawNoService();
        } else {
            switch (this.connectedSat.satelliteType) {
                case LASER: {
                    this.drawMap();
                    break;
                }
                case MAPPER: {
                    this.drawMap();
                    break;
                }
                case RADAR: {
                    this.drawRadar();
                    break;
                }
                case SCANNER: {
                    this.drawScan();
                    break;
                }
                case RELAY: 
                case RESONATOR: {
                    this.drawNoService();
                }
            }
        }
    }

    private void progresScan() {
        if (this.lastMilli + 25L < System.currentTimeMillis()) {
            this.lastMilli = System.currentTimeMillis();
            ++this.scanPos;
        }
        if (this.scanPos >= 200) {
            this.scanPos -= 200;
        }
    }

    private void drawMap() {
        World world = this.player.field_70170_p;
        for (int i = -100; i < 100; ++i) {
            int x = this.x + i;
            int z = this.z + this.scanPos - 100;
            int y = world.func_72976_f(x, z) - 1;
            this.map[i + 100][this.scanPos] = world.func_147439_a((int)x, (int)y, (int)z).func_149688_o().func_151565_r().field_76291_p;
        }
        this.prontMap();
        this.progresScan();
    }

    private void drawScan() {
        World world = this.player.field_70170_p;
        block0: for (int i = -100; i < 100; ++i) {
            int x = this.x + i;
            int z = this.z + this.scanPos - 100;
            for (int j = 255; j >= 0; --j) {
                int c = this.getColorFromBlock(new ItemStack(world.func_147439_a(x, j, z), 1, world.func_72805_g(x, j, z)));
                if (c == 0) continue;
                this.map[i + 100][this.scanPos] = c;
                continue block0;
            }
        }
        this.prontMap();
        this.progresScan();
    }

    private int getColorFromBlock(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        if (MachineRecipes.mODE(stack, "oreCoal")) {
            return 0x333333;
        }
        if (MachineRecipes.mODE(stack, "oreIron")) {
            return 11709074;
        }
        if (MachineRecipes.mODE(stack, "oreGold")) {
            return 16770144;
        }
        if (MachineRecipes.mODE(stack, "oreSilver")) {
            return 0xE5E5E5;
        }
        if (MachineRecipes.mODE(stack, "oreDiamond")) {
            return 7263727;
        }
        if (MachineRecipes.mODE(stack, "oreEmerald")) {
            return 7141206;
        }
        if (MachineRecipes.mODE(stack, "oreLapis")) {
            return 601978;
        }
        if (MachineRecipes.mODE(stack, "oreRedstone")) {
            return 0xE50000;
        }
        if (MachineRecipes.mODE(stack, "oreTin")) {
            return 10524567;
        }
        if (MachineRecipes.mODE(stack, "oreCopper")) {
            return 13722120;
        }
        if (MachineRecipes.mODE(stack, "oreLead")) {
            return 3689320;
        }
        if (MachineRecipes.mODE(stack, "oreAluminum")) {
            return 0xDBDBDB;
        }
        if (MachineRecipes.mODE(stack, "oreTungsten")) {
            return 0x333333;
        }
        if (MachineRecipes.mODE(stack, "oreTitanium")) {
            return 0xDDDDDD;
        }
        if (MachineRecipes.mODE(stack, "oreUranium")) {
            return 4083516;
        }
        if (MachineRecipes.mODE(stack, "oreBeryllium")) {
            return 9342333;
        }
        if (MachineRecipes.mODE(stack, "oreSulfur")) {
            return 10195721;
        }
        if (MachineRecipes.mODE(stack, "oreSalpeter") || MachineRecipes.mODE(stack, "oreNiter")) {
            return 10854557;
        }
        if (MachineRecipes.mODE(stack, "oreFluorite")) {
            return 0xFFFFFF;
        }
        if (MachineRecipes.mODE(stack, "oreSchrabidium")) {
            return 0x1CFFFF;
        }
        if (MachineRecipes.mODE(stack, "oreRareEarth")) {
            return 0xFFCC99;
        }
        return GUIScreenSatInterface.isOre(stack) ? 12189871 : 0;
    }

    private static boolean isOre(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()));
        for (int i = 0; i < ids.length; ++i) {
            String s = OreDictionary.getOreName((int)ids[i]);
            if (s.length() <= 3 || !s.substring(0, 3).equals("ore")) continue;
            return true;
        }
        return false;
    }

    private void drawRadar() {
        List entities = this.player.field_70170_p.func_72839_b((Entity)this.player, AxisAlignedBB.func_72330_a((double)(this.player.field_70165_t - 100.0), (double)0.0, (double)(this.player.field_70161_v - 100.0), (double)(this.player.field_70165_t + 100.0), (double)5000.0, (double)(this.player.field_70161_v + 100.0)));
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                if (!((double)(e.field_70130_N * e.field_70130_N * e.field_70131_O) >= 0.5)) continue;
                int x = (int)((e.field_70165_t - (double)this.x) / 201.0 * 192.0) - 4;
                int z = (int)((e.field_70161_v - (double)this.z) / 201.0 * 192.0) - 4 - 9;
                int t = 5;
                if (e instanceof EntityMissileBaseAdvanced) {
                    t = ((EntityMissileBaseAdvanced)e).getMissileType();
                }
                if (e instanceof EntityMob) {
                    t = 6;
                }
                if (e instanceof EntityPlayer) {
                    t = 7;
                }
                this.func_73729_b(this.guiLeft + 108 + x, this.guiTop + 117 + z, 216, 8 * t, 8, 8);
            }
        }
    }

    private void prontMap() {
        for (int x = 0; x < 200; ++x) {
            for (int z = 0; z < 200; ++z) {
                if (this.map[x][z] == 0) continue;
                GL11.glColor3ub((byte)((byte)((this.map[x][z] & 0xFF0000) >> 16)), (byte)((byte)((this.map[x][z] & 0xFF00) >> 8)), (byte)((byte)(this.map[x][z] & 0xFF)));
                this.func_73729_b(this.guiLeft + 8 + x, this.guiTop + 8 + z, 216, 216, 1, 1);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawNoService() {
        this.func_73729_b((this.field_146294_l - 77) / 2, (this.field_146295_m - 12) / 2, 0, 228, 77, 12);
    }

    private void drawNotConnected() {
        this.func_73729_b((this.field_146294_l - 121) / 2, (this.field_146295_m - 12) / 2, 0, 216, 121, 12);
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.z -= 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.z += 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.x -= 50;
            this.map = new int[200][200];
        }
        if (p_73869_2_ == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.x += 50;
            this.map = new int[200][200];
        }
    }
}

