/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBattery
extends Item {
    private long maxCharge;
    private long chargeRate;
    private long dischargeRate;

    public ItemBattery(long dura, long chargeRate, long dischargeRate) {
        this.maxCharge = dura;
        this.chargeRate = chargeRate;
        this.dischargeRate = dischargeRate;
        this.func_77656_e(100);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        long charge = this.maxCharge;
        if (itemstack.func_77942_o()) {
            charge = ItemBattery.getCharge(itemstack);
        }
        if (itemstack.func_77973_b() != ModItems.fusion_core && itemstack.func_77973_b() != ModItems.factory_core_titanium && itemstack.func_77973_b() != ModItems.factory_core_advanced && itemstack.func_77973_b() != ModItems.energy_core && itemstack.func_77973_b() != ModItems.dynosphere_desh && itemstack.func_77973_b() != ModItems.dynosphere_schrabidium && itemstack.func_77973_b() != ModItems.dynosphere_euphemium && itemstack.func_77973_b() != ModItems.dynosphere_dineutronium) {
            list.add("Energy stored: " + Library.getShortNumber(charge * 100L) + "/" + Library.getShortNumber(this.maxCharge * 100L) + "HE");
        } else {
            String charge1 = Library.getShortNumber(charge * 100L / this.maxCharge);
            list.add("Charge: " + charge1 + "%");
            list.add("(" + Library.getShortNumber(charge * 100L) + "/" + Library.getShortNumber(this.maxCharge * 100L) + "HE)");
        }
        list.add("Charge rate: " + Library.getShortNumber(this.chargeRate * 100L) + "HE/t");
        list.add("Discharge rate: " + Library.getShortNumber(this.dischargeRate * 100L) + "HE/t");
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        if (this == ModItems.battery_schrabidium) {
            return EnumRarity.rare;
        }
        if (this == ModItems.fusion_core || this == ModItems.factory_core_titanium || this == ModItems.factory_core_advanced || this == ModItems.energy_core || this == ModItems.dynosphere_desh || this == ModItems.dynosphere_schrabidium || this == ModItems.dynosphere_euphemium || this == ModItems.dynosphere_dineutronium) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public void chargeBattery(ItemStack stack, int i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + (long)i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", (long)i);
            }
        }
    }

    public void setCharge(ItemStack stack, int i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", (long)i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", (long)i);
            }
        }
    }

    public void dischargeBattery(ItemStack stack, int i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - (long)i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", this.maxCharge - (long)i);
            }
        }
    }

    public static long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("charge");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ItemBattery)stack.func_77973_b()).maxCharge);
            return stack.field_77990_d.func_74763_f("charge");
        }
        return 0L;
    }

    public long getMaxCharge() {
        return this.maxCharge;
    }

    public long getChargeRate() {
        return this.chargeRate;
    }

    public long getDischargeRate() {
        return this.dischargeRate;
    }

    public static long getMaxChargeStatic(ItemStack stack) {
        return ((ItemBattery)stack.func_77973_b()).maxCharge;
    }

    public static ItemStack getEmptyBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", 0L);
            stack.func_77964_b(100);
            return stack.func_77946_l();
        }
        return null;
    }

    public static ItemStack getFullBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ItemBattery.getMaxChargeStatic(stack));
            return stack.func_77946_l();
        }
        return null;
    }

    public static void updateDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack = ItemBattery.getFullBattery(stack.func_77973_b()).func_77946_l();
        }
        stack.func_77964_b(100 - (int)((double)ItemBattery.getCharge(stack) / (double)ItemBattery.getMaxChargeStatic(stack) * 100.0));
    }
}

