/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.HbmChestContents;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntitySafe;
import com.hbm.world.Antenna;
import com.hbm.world.Barrel;
import com.hbm.world.Bunker;
import com.hbm.world.CrashedVertibird;
import com.hbm.world.DesertAtom001;
import com.hbm.world.Dud;
import com.hbm.world.Factory;
import com.hbm.world.LibraryDungeon;
import com.hbm.world.OilBubble;
import com.hbm.world.OilSandBubble;
import com.hbm.world.Radio01;
import com.hbm.world.Relay;
import com.hbm.world.Satellite;
import com.hbm.world.Sellafield;
import com.hbm.world.Silo;
import com.hbm.world.Spaceship;
import com.hbm.world.Vertibird;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class HbmWorldGen
implements IWorldGenerator {
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                if (!MainRegistry.enableMDOres) break;
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random rand, int i, int j) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int k;
        for (k = 0; k < MainRegistry.uraniumSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(25);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_uranium, 5).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.titaniumSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_titanium, 6).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.sulfurSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_sulfur, 8).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.aluminiumSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(45);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_aluminium, 6).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.copperSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(50);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_copper, 6).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.fluoriteSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(40);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_fluorite, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.niterSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_niter, 6).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.tungstenSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_tungsten, 8).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.leadSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_lead, 9).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.berylliumSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_beryllium, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 6; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(35);
            randPosZ = j + rand.nextInt(16);
            if (randPosX > 50 || randPosX < -50 || randPosZ > 50 || randPosZ < -50) continue;
            new WorldGenMinable(ModBlocks.ore_reiium, 12).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 80; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(128);
            randPosZ = j + rand.nextInt(16);
            if (randPosX > 250 || randPosX < 150 || randPosZ > 250 || randPosZ < 150) continue;
            new WorldGenMinable(ModBlocks.ore_unobtainium, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < rand.nextInt(4); ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(15) + 15;
            randPosZ = j + rand.nextInt(16);
            if (randPosX > -350 || randPosX < -450 || randPosZ > -350 || randPosZ < -450) continue;
            new WorldGenMinable(ModBlocks.ore_australium, 50).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 12; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(25);
            randPosZ = j + rand.nextInt(16);
            if (randPosX > 50 || randPosX < -50 || randPosZ > 350 || randPosZ < 250) continue;
            new WorldGenMinable(ModBlocks.ore_weidanium, 6).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 24; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(10);
            randPosZ = j + rand.nextInt(16);
            if (randPosX > 450 || randPosX < 350 || randPosZ > -150 || randPosZ < -250) continue;
            new WorldGenMinable(ModBlocks.ore_daffergon, 16).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 12; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(25) + 25;
            randPosZ = j + rand.nextInt(16);
            if (randPosX > -250 || randPosX < -350 || randPosZ > 250 || randPosZ < 150) continue;
            new WorldGenMinable(ModBlocks.ore_verticium, 16).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < MainRegistry.niterSpawn; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(25);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_rare, 5).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        if (MainRegistry.enableDungeons) {
            int y;
            int z;
            int x;
            int y2;
            int z2;
            int x2;
            int a;
            BiomeGenBase biome = world.func_72959_q().func_76935_a(i, j);
            if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76769_d) && rand.nextInt(MainRegistry.radioStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    new Radio01().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76767_f || biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76780_h || biome == BiomeGenBase.field_76770_e) && rand.nextInt(MainRegistry.antennaStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    new Antenna().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if ((biome == BiomeGenBase.field_76769_d || biome == BiomeGenBase.field_76787_r || biome == BiomeGenBase.field_150589_Z || biome == BiomeGenBase.field_150608_ab) && rand.nextInt(MainRegistry.atomStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    new DesertAtom001().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if (biome == BiomeGenBase.field_76769_d && rand.nextInt(MainRegistry.vertibirdStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    if (rand.nextInt(2) == 0) {
                        new Vertibird().func_76484_a(world, rand, x2, y2, z2);
                        continue;
                    }
                    new CrashedVertibird().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if (rand.nextInt(MainRegistry.dungeonStructure) == 0) {
                x = i + rand.nextInt(16);
                int y3 = rand.nextInt(256);
                z2 = j + rand.nextInt(16);
                new LibraryDungeon().func_76484_a(world, rand, x, y3, z2);
            }
            if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76769_d) && rand.nextInt(MainRegistry.relayStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    new Relay().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76769_d) && rand.nextInt(MainRegistry.satelliteStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    new Satellite().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if (biome == BiomeGenBase.field_76769_d && rand.nextInt(200) == 0) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x2, z2);
                    OilSandBubble.spawnOil(world, x2, y2, z2, 15 + rand.nextInt(31));
                }
            }
            if (rand.nextInt(MainRegistry.bunkerStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Bunker().func_76484_a(world, rand, x, y, z);
            }
            if (rand.nextInt(MainRegistry.siloStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Silo().func_76484_a(world, rand, x, y, z);
            }
            if (rand.nextInt(MainRegistry.factoryStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Factory().func_76484_a(world, rand, x, y, z);
            }
            if (rand.nextInt(MainRegistry.dudStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Dud().func_76484_a(world, rand, x, y, z);
            }
            if (rand.nextInt(MainRegistry.spaceshipStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Spaceship().func_76484_a(world, rand, x, y, z);
            }
            if (biome == BiomeGenBase.field_76769_d && rand.nextInt(MainRegistry.barrelStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new Barrel().func_76484_a(world, rand, x, y, z);
            }
            if (rand.nextInt(MainRegistry.broadcaster) == 0) {
                x = i + rand.nextInt(16);
                if (world.func_147439_a(x, y = world.func_72976_f(x, z = j + rand.nextInt(16)), z).canPlaceTorchOnTop(world, x, y, z)) {
                    world.func_147465_d(x, y + 1, z, ModBlocks.broadcaster_pc, rand.nextInt(4) + 2, 2);
                }
                if (MainRegistry.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned corrupted broadcaster at " + x + " " + (y + 1) + " " + z);
                }
            }
            if (MainRegistry.enableMines && rand.nextInt(MainRegistry.minefreq) == 0 && world.func_147439_a(x = i + rand.nextInt(16), y = world.func_72976_f(x, z = j + rand.nextInt(16)), z).canPlaceTorchOnTop(world, x, y, z)) {
                world.func_147449_b(x, y + 1, z, ModBlocks.mine_ap);
                if (MainRegistry.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned landmine at " + x + " " + (y + 1) + " " + z);
                }
            }
            if (MainRegistry.enableRad && rand.nextInt(MainRegistry.radfreq) == 0 && biome == BiomeGenBase.field_76769_d) {
                for (a = 0; a < 1; ++a) {
                    x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    double r = rand.nextInt(15) + 10;
                    if (rand.nextInt(50) == 0) {
                        r = 50.0;
                    }
                    new Sellafield().generate(world, x2, z2, r, r * 0.35);
                    if (!MainRegistry.enableDebugMode) continue;
                    MainRegistry.logger.info("[Debug] Successfully spawned raditation hotspot at " + x2 + " " + z2);
                }
            }
            if (MainRegistry.enableVaults && rand.nextInt(MainRegistry.vaultfreq) == 0 && world.func_147439_a(x = i + rand.nextInt(16), y = world.func_72976_f(x, z = j + rand.nextInt(16)), z).canPlaceTorchOnTop(world, x, y, z)) {
                world.func_147465_d(x, y + 1, z, ModBlocks.safe, rand.nextInt(4) + 2, 2);
                switch (rand.nextInt(10)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setMod(1.0);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(10), (IInventory)((TileEntitySafe)world.func_147438_o(x, y + 1, z)), (int)(rand.nextInt(4) + 3));
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setMod(0.1);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(11), (IInventory)((TileEntitySafe)world.func_147438_o(x, y + 1, z)), (int)(rand.nextInt(3) + 2));
                        break;
                    }
                    case 7: 
                    case 8: {
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setMod(0.02);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(12), (IInventory)((TileEntitySafe)world.func_147438_o(x, y + 1, z)), (int)(rand.nextInt(3) + 1));
                        break;
                    }
                    case 9: {
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).setMod(0.0);
                        ((TileEntitySafe)world.func_147438_o(x, y + 1, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(13), (IInventory)((TileEntitySafe)world.func_147438_o(x, y + 1, z)), (int)(rand.nextInt(2) + 1));
                    }
                }
                if (MainRegistry.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned safe at " + x + " " + (y + 1) + " " + z);
                }
            }
        }
        if (rand.nextInt(25) == 0) {
            int randPosX2 = i + rand.nextInt(16);
            int randPosY2 = rand.nextInt(25);
            int randPosZ2 = j + rand.nextInt(16);
            OilBubble.spawnOil(world, randPosX2, randPosY2, randPosZ2, 7 + rand.nextInt(9));
        }
        if (MainRegistry.enableNITAN) {
            if (i <= 10000 && i + 16 >= 10000 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(10000, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, 10000)), (int)29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(0, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(0, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(0, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(0, 250, 10000)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(-10000, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, 10000)), (int)29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= 0 && j + 16 >= 0 && world.func_147439_a(10000, 250, 0) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, 0, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, 0) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, 0)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 0 && j + 16 >= 0 && world.func_147439_a(-10000, 250, 0) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, 0, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, 0) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, 0)), (int)29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(10000, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, -10000)), (int)29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(0, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(0, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(0, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(0, 250, -10000)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(-10000, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, -10000)), (int)29);
                }
            }
        }
    }

    private void generateNether(World world, Random rand, int i, int j) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int k;
        for (k = 0; k < 8; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(127);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_nether_uranium, 6, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        if (MainRegistry.enablePlutoniumOre) {
            for (k = 0; k < 6; ++k) {
                randPosX = i + rand.nextInt(16);
                randPosY = rand.nextInt(127);
                randPosZ = j + rand.nextInt(16);
                new WorldGenMinable(ModBlocks.ore_nether_plutonium, 4, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
        for (k = 0; k < 10; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(127);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_nether_tungsten, 10, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 26; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(127);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_nether_sulfur, 12, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (k = 0; k < 24; ++k) {
            randPosX = i + rand.nextInt(16);
            randPosY = rand.nextInt(127);
            randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_nether_fire, 3, Blocks.field_150424_aL).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
    }

    private void generateEnd(World world, Random rand, int i, int j) {
        for (int k = 0; k < 8; ++k) {
            int randPosX = i + rand.nextInt(16);
            int randPosY = rand.nextInt(127);
            int randPosZ = j + rand.nextInt(16);
            new WorldGenMinable(ModBlocks.ore_tikite, 6, Blocks.field_150377_bs).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
    }
}

