/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class RadEntitySavedData
extends WorldSavedData {
    public List<RadEntry> contaminated = new ArrayList<RadEntry>();
    public World worldObj;

    public RadEntitySavedData(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public RadEntitySavedData(World p_i1678_1_) {
        super("radentity");
        this.worldObj = p_i1678_1_;
        this.func_76185_a();
    }

    public float getRadFromEntity(Entity e) {
        for (int i = 0; i < this.contaminated.size(); ++i) {
            if (!new UUID(this.contaminated.get((int)i).hID, this.contaminated.get((int)i).lID).equals(e.func_110124_au())) continue;
            return this.contaminated.get((int)i).rad;
        }
        return 0.0f;
    }

    public void setRadForEntity(Entity e, float rad) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        for (int i = 0; i < this.contaminated.size(); ++i) {
            if (!new UUID(this.contaminated.get((int)i).hID, this.contaminated.get((int)i).lID).equals(e.func_110124_au())) continue;
            this.contaminated.get((int)i).rad = rad;
            if (this.contaminated.get((int)i).rad > 2500.0f) {
                this.contaminated.get((int)i).rad = 2500.0f;
            }
            this.func_76185_a();
            return;
        }
        this.contaminated.add(new RadEntry(e.func_110124_au().getMostSignificantBits(), e.func_110124_au().getLeastSignificantBits(), rad));
        this.func_76185_a();
    }

    public void increaseRad(Entity e, float rad) {
        this.setRadForEntity(e, this.getRadFromEntity(e) + rad);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int count = nbt.func_74762_e("contCount");
        for (int i = 0; i < count; ++i) {
            this.contaminated.add(new RadEntry(nbt.func_74763_f("uH_" + i), nbt.func_74763_f("uL_" + i), nbt.func_74760_g("cont_" + i)));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("contCount", this.contaminated.size());
        int i = 0;
        for (RadEntry entry : this.contaminated) {
            nbt.func_74772_a("uH_" + i, entry.hID);
            nbt.func_74772_a("uL_" + i, entry.lID);
            nbt.func_74776_a("cont_" + i, entry.rad);
            ++i;
        }
    }

    public static RadEntitySavedData getData(World worldObj) {
        RadEntitySavedData data = (RadEntitySavedData)worldObj.perWorldStorage.func_75742_a(RadEntitySavedData.class, "radentity");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("radentity", (WorldSavedData)new RadEntitySavedData(worldObj));
            data = (RadEntitySavedData)worldObj.perWorldStorage.func_75742_a(RadEntitySavedData.class, "radentity");
        }
        return data;
    }

    public class RadEntry {
        long hID;
        long lID;
        float rad;

        public RadEntry(long hID, long lID, float rad) {
            this.hID = hID;
            this.lID = lID;
            this.rad = rad;
        }
    }
}

