/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.saveddata.RadiationSaveStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;

public class RadiationSavedData
extends WorldSavedData {
    public List<RadiationSaveStructure> contamination = new ArrayList<RadiationSaveStructure>();
    private World worldObj;

    public RadiationSavedData(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public RadiationSavedData(World p_i1678_1_) {
        super("radiation");
        this.worldObj = p_i1678_1_;
        this.func_76185_a();
    }

    public boolean doesEntryExist(int x, int y) {
        return this.getRadFromCoord(x, y) != null;
    }

    public void createEntry(int x, int y, float rad) {
        this.contamination.add(new RadiationSaveStructure(x, y, rad));
        this.func_76185_a();
    }

    public void deleteEntry(RadiationSaveStructure struct) {
        this.contamination.remove(struct);
        this.func_76185_a();
    }

    public void jettisonData() {
        this.contamination.clear();
        this.func_76185_a();
    }

    public void setRadForCoord(int x, int y, float radiation) {
        RadiationSaveStructure entry = null;
        for (RadiationSaveStructure rad : this.contamination) {
            if (rad.chunkX != x || rad.chunkY != y) continue;
            entry = rad;
            break;
        }
        if (entry == null) {
            entry = new RadiationSaveStructure(x, y, radiation);
            this.contamination.add(entry);
        }
        entry.radiation = radiation;
        this.func_76185_a();
    }

    public RadiationSaveStructure getRadFromCoord(int x, int y) {
        for (RadiationSaveStructure rad : this.contamination) {
            if (rad.chunkX != x || rad.chunkY != y) continue;
            return rad;
        }
        return null;
    }

    public float getRadNumFromCoord(int x, int y) {
        for (RadiationSaveStructure rad : this.contamination) {
            if (rad.chunkX != x || rad.chunkY != y) continue;
            return rad.radiation;
        }
        return 0.0f;
    }

    public void updateSystem() {
        ArrayList<RadiationSaveStructure> tempList = new ArrayList<RadiationSaveStructure>(this.contamination);
        this.contamination.clear();
        for (RadiationSaveStructure struct : tempList) {
            if (struct.radiation == 0.0f) continue;
            struct.radiation *= 0.999f;
            struct.radiation -= 0.5f;
            if (struct.radiation <= 0.0f) {
                struct.radiation = 0.0f;
            }
            if (struct.radiation > 1.0f) {
                float[] rads = new float[]{this.getRadNumFromCoord(struct.chunkX + 1, struct.chunkY + 1), this.getRadNumFromCoord(struct.chunkX, struct.chunkY + 1), this.getRadNumFromCoord(struct.chunkX - 1, struct.chunkY + 1), this.getRadNumFromCoord(struct.chunkX - 1, struct.chunkY), this.getRadNumFromCoord(struct.chunkX - 1, struct.chunkY - 1), this.getRadNumFromCoord(struct.chunkX, struct.chunkY - 1), this.getRadNumFromCoord(struct.chunkX + 1, struct.chunkY - 1), this.getRadNumFromCoord(struct.chunkX + 1, struct.chunkY), this.getRadNumFromCoord(struct.chunkX, struct.chunkY)};
                float main = 0.6f;
                float side = 0.075f;
                float corner = 0.025f;
                this.setRadForCoord(struct.chunkX + 1, struct.chunkY + 1, rads[0] + struct.radiation * corner);
                this.setRadForCoord(struct.chunkX, struct.chunkY + 1, rads[1] + struct.radiation * side);
                this.setRadForCoord(struct.chunkX - 1, struct.chunkY + 1, rads[2] + struct.radiation * corner);
                this.setRadForCoord(struct.chunkX - 1, struct.chunkY, rads[3] + struct.radiation * side);
                this.setRadForCoord(struct.chunkX - 1, struct.chunkY - 1, rads[4] + struct.radiation * corner);
                this.setRadForCoord(struct.chunkX, struct.chunkY - 1, rads[5] + struct.radiation * side);
                this.setRadForCoord(struct.chunkX + 1, struct.chunkY - 1, rads[6] + struct.radiation * corner);
                this.setRadForCoord(struct.chunkX + 1, struct.chunkY, rads[7] + struct.radiation * side);
                this.setRadForCoord(struct.chunkX, struct.chunkY, rads[8] + struct.radiation * main);
                continue;
            }
            this.setRadForCoord(struct.chunkX, struct.chunkY, this.getRadNumFromCoord(struct.chunkX, struct.chunkY) + struct.radiation);
        }
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int count = nbt.func_74762_e("radCount");
        for (int i = 0; i < count; ++i) {
            RadiationSaveStructure struct = new RadiationSaveStructure();
            struct.readFromNBT(nbt, i);
            this.contamination.add(struct);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("radCount", this.contamination.size());
        for (int i = 0; i < this.contamination.size(); ++i) {
            this.contamination.get(i).writeToNBT(nbt, i);
        }
    }

    public static RadiationSavedData getData(World worldObj) {
        RadiationSavedData data = (RadiationSavedData)worldObj.perWorldStorage.func_75742_a(RadiationSavedData.class, "radiation");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("radiation", (WorldSavedData)new RadiationSavedData(worldObj));
            data = (RadiationSavedData)worldObj.perWorldStorage.func_75742_a(RadiationSavedData.class, "radiation");
        }
        return data;
    }

    public static void incrementRad(World worldObj, int x, int z, float rad, float maxRad) {
        RadiationSavedData data = RadiationSavedData.getData(worldObj);
        Chunk chunk = worldObj.func_72938_d(x, z);
        float r = data.getRadNumFromCoord(chunk.field_76635_g, chunk.field_76647_h);
        if (r < maxRad) {
            data.setRadForCoord(chunk.field_76635_g, chunk.field_76647_h, r + rad);
        }
    }
}

