/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class SatelliteSaveStructure {
    public int satelliteID;
    public int satDim;
    public SatelliteType satelliteType;
    public long lastOp;

    public SatelliteSaveStructure() {
    }

    public SatelliteSaveStructure(int id, SatelliteType type, int dim) {
        this.satelliteID = id;
        this.satelliteType = type;
        this.satDim = dim;
    }

    public void readFromNBT(NBTTagCompound nbt, int index) {
        this.satelliteID = nbt.func_74762_e("sat_" + index + "_id");
        this.satelliteType = SatelliteType.getEnum(nbt.func_74762_e("sat_" + index + "_type"));
        this.satDim = nbt.func_74762_e("sat_" + index + "_dim");
        this.lastOp = nbt.func_74763_f("sat_" + index + "_op");
    }

    public void writeToNBT(NBTTagCompound nbt, int index) {
        nbt.func_74768_a("sat_" + index + "_id", this.satelliteID);
        nbt.func_74768_a("sat_" + index + "_type", this.satelliteType.getID());
        nbt.func_74768_a("sat_" + index + "_dim", this.satDim);
        nbt.func_74772_a("sat_" + index + "_op", this.lastOp);
    }

    public static enum SatelliteType {
        MAPPER,
        RADAR,
        SCANNER,
        RELAY,
        LASER,
        RESONATOR;


        public static SatelliteType getEnum(int i) {
            if (i < SatelliteType.values().length) {
                return SatelliteType.values()[i];
            }
            return RELAY;
        }

        public int getID() {
            return Arrays.asList(SatelliteType.values()).indexOf((Object)this);
        }
    }
}

