/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBattery;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFFPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class TileEntityForceField
extends TileEntity
implements ISidedInventory,
IConsumer {
    private ItemStack[] slots;
    public int health = 100;
    public int maxHealth = 100;
    public long power;
    public int powerCons;
    public int cooldown = 0;
    public int blink = 0;
    public float radius = 16.0f;
    public boolean isOn = false;
    public int color = 255;
    public final int baseCon = 1000;
    public final int radCon = 500;
    public final int shCon = 250;
    public static final long maxPower = 1000000L;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0};
    private static final int[] slots_side = new int[]{0};
    private String customName;
    List<Entity> outside = new ArrayList<Entity>();
    List<Entity> inside = new ArrayList<Entity>();

    public TileEntityForceField() {
        this.slots = new ItemStack[3];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.forceField";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof ItemBattery) {
            return true;
        }
        return i == 1;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.health = nbt.func_74762_e("health");
        this.maxHealth = nbt.func_74762_e("maxHealth");
        this.cooldown = nbt.func_74762_e("cooldown");
        this.blink = nbt.func_74762_e("blink");
        this.radius = nbt.func_74760_g("radius");
        this.isOn = nbt.func_74767_n("isOn");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("health", this.health);
        nbt.func_74768_a("maxHealth", this.maxHealth);
        nbt.func_74768_a("cooldown", this.cooldown);
        nbt.func_74768_a("blink", this.blink);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74757_a("isOn", this.isOn);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public int getHealthScaled(int i) {
        return this.health * i / this.maxHealth;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int rStack = 0;
            int hStack = 0;
            this.radius = 16.0f;
            this.maxHealth = 100;
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.upgrade_radius) {
                rStack = this.slots[1].field_77994_a;
                this.radius += (float)(rStack * 16);
            }
            if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.upgrade_health) {
                hStack = this.slots[2].field_77994_a;
                this.maxHealth += hStack * 50;
            }
            this.powerCons = this.baseCon + rStack * this.radCon + hStack * this.shCon;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000000L);
            if (this.blink > 0) {
                --this.blink;
                this.color = 0xFF0000;
            } else {
                this.color = 65280;
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            if (this.health < this.maxHealth) {
                this.health += this.maxHealth / 100;
            }
            if (this.health > this.maxHealth) {
                this.health = this.maxHealth;
            }
        }
        if (this.isOn && this.cooldown == 0 && this.health > 0 && this.power >= (long)this.powerCons) {
            this.doField(this.radius);
            if (!this.field_145850_b.field_72995_K) {
                this.power -= (long)this.powerCons;
            }
        } else {
            this.outside.clear();
            this.inside.clear();
        }
        if (!this.field_145850_b.field_72995_K && this.power < (long)this.powerCons) {
            this.power = 0L;
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new TEFFPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.radius, this.health, this.maxHealth, (int)this.power, this.isOn, this.color, this.cooldown));
        }
    }

    private int impact(Entity e) {
        double mass = e.field_70131_O * e.field_70130_N * e.field_70130_N;
        double speed = this.getMotionWithFallback(e);
        return (int)(mass * speed * 50.0);
    }

    private void damage(int ouch) {
        this.health -= ouch;
        if (ouch >= this.maxHealth / 250) {
            this.blink = 5;
        }
        if (this.health <= 0) {
            this.health = 0;
            this.cooldown = (int)(100.0f + this.radius);
        }
    }

    private void doField(float rad) {
        ArrayList<Entity> oLegacy = new ArrayList<Entity>(this.outside);
        ArrayList<Entity> iLegacy = new ArrayList<Entity>(this.inside);
        this.outside.clear();
        this.inside.clear();
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)(rad + 25.0f)), (double)((double)this.field_145848_d + 0.5 - (double)(rad + 25.0f)), (double)((double)this.field_145849_e + 0.5 - (double)(rad + 25.0f)), (double)((double)this.field_145851_c + 0.5 + (double)(rad + 25.0f)), (double)((double)this.field_145848_d + 0.5 + (double)(rad + 25.0f)), (double)((double)this.field_145849_e + 0.5 + (double)(rad + 25.0f))));
        for (Object o : list) {
            double mo;
            double mz;
            double my;
            double mx;
            Vec3 vec;
            boolean out;
            if (!(o instanceof Entity) || o instanceof EntityPlayer) continue;
            Entity entity = (Entity)o;
            double dist = Math.sqrt(Math.pow((double)this.field_145851_c + 0.5 - entity.field_70165_t, 2.0) + Math.pow((double)this.field_145848_d + 0.5 - entity.field_70163_u, 2.0) + Math.pow((double)this.field_145849_e + 0.5 - entity.field_70161_v, 2.0));
            boolean bl = out = dist > (double)rad;
            if (!oLegacy.contains(entity) && !iLegacy.contains(entity)) {
                if (out) {
                    this.outside.add(entity);
                    continue;
                }
                this.inside.add(entity);
                continue;
            }
            if (oLegacy.contains(entity) && !out) {
                vec = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 - entity.field_70165_t), (double)((double)this.field_145848_d + 0.5 - entity.field_70163_u), (double)((double)this.field_145849_e + 0.5 - entity.field_70161_v));
                vec = vec.func_72432_b();
                mx = -vec.field_72450_a * (double)(rad + 1.0f);
                my = -vec.field_72448_b * (double)(rad + 1.0f);
                mz = -vec.field_72449_c * (double)(rad + 1.0f);
                entity.func_70012_b((double)this.field_145851_c + 0.5 + mx, (double)this.field_145848_d + 0.5 + my, (double)this.field_145849_e + 0.5 + mz, 0.0f, 0.0f);
                mo = Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70181_x, 2.0) + Math.pow(entity.field_70179_y, 2.0));
                entity.field_70159_w = vec.field_72450_a * -mo;
                entity.field_70181_x = vec.field_72448_b * -mo;
                entity.field_70179_y = vec.field_72449_c * -mo;
                entity.field_70165_t -= entity.field_70159_w;
                entity.field_70163_u -= entity.field_70181_x;
                entity.field_70161_v -= entity.field_70179_y;
                this.field_145850_b.func_72956_a(entity, "hbm:weapon.sparkShoot", 2.5f, 1.0f);
                this.outside.add(entity);
                if (this.field_145850_b.field_72995_K) continue;
                this.damage(this.impact(entity));
                continue;
            }
            if (iLegacy.contains(entity) && out) {
                vec = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 - entity.field_70165_t), (double)((double)this.field_145848_d + 0.5 - entity.field_70163_u), (double)((double)this.field_145849_e + 0.5 - entity.field_70161_v));
                vec = vec.func_72432_b();
                mx = -vec.field_72450_a * (double)(rad - 1.0f);
                my = -vec.field_72448_b * (double)(rad - 1.0f);
                mz = -vec.field_72449_c * (double)(rad - 1.0f);
                entity.func_70012_b((double)this.field_145851_c + 0.5 + mx, (double)this.field_145848_d + 0.5 + my, (double)this.field_145849_e + 0.5 + mz, 0.0f, 0.0f);
                mo = Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70181_x, 2.0) + Math.pow(entity.field_70179_y, 2.0));
                entity.field_70159_w = vec.field_72450_a * mo;
                entity.field_70181_x = vec.field_72448_b * mo;
                entity.field_70179_y = vec.field_72449_c * mo;
                entity.field_70165_t -= entity.field_70159_w;
                entity.field_70163_u -= entity.field_70181_x;
                entity.field_70161_v -= entity.field_70179_y;
                this.field_145850_b.func_72956_a(entity, "hbm:weapon.sparkShoot", 2.5f, 1.0f);
                this.inside.add(entity);
                if (this.field_145850_b.field_72995_K) continue;
                this.damage(this.impact(entity));
                continue;
            }
            if (out) {
                this.outside.add(entity);
                continue;
            }
            this.inside.add(entity);
        }
    }

    private double getMotionWithFallback(Entity e) {
        Vec3 v1 = Vec3.func_72443_a((double)e.field_70159_w, (double)e.field_70181_x, (double)e.field_70179_y);
        Vec3 v2 = Vec3.func_72443_a((double)(e.field_70165_t - e.field_70167_r), (double)(e.field_70163_u - e.field_70167_r), (double)(e.field_70161_v - e.field_70166_s));
        double s1 = v1.func_72433_c();
        double s2 = v2.func_72433_c();
        if (s1 == 0.0) {
            return s2;
        }
        if (s2 == 0.0) {
            return s1;
        }
        return Math.min(s1, s2);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

