/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBattery;
import com.hbm.items.tool.ItemAssemblyTemplate;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEAssemblerPacket;
import com.hbm.tileentity.machine.TileEntityCrateIron;
import com.hbm.tileentity.machine.TileEntityCrateSteel;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineAssembler
extends TileEntity
implements ISidedInventory,
IConsumer {
    private ItemStack[] slots;
    public long power;
    public static final long maxPower = 100000L;
    public int progress;
    public int maxProgress = 100;
    public float rotation = 0.0f;
    public boolean isProgressing;
    int age = 0;
    int consumption = 100;
    int speed = 100;
    Random rand = new Random();
    private String customName;

    public TileEntityMachineAssembler() {
        this.slots = new ItemStack[18];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.assembler";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof ItemBattery) {
            return true;
        }
        return i == 1;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public void func_145845_h() {
        this.consumption = 100;
        this.speed = 100;
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null) continue;
            if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                this.speed -= 25;
                this.consumption += 300;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                this.speed -= 50;
                this.consumption += 600;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                this.speed -= 75;
                this.consumption += 900;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                this.consumption -= 30;
                this.speed += 5;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                this.consumption -= 60;
                this.speed += 10;
            }
            if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
            this.consumption -= 90;
            this.speed += 15;
        }
        if (this.speed < 25) {
            this.speed = 25;
        }
        if (this.consumption < 10) {
            this.consumption = 10;
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            Object hopper;
            TileEntityChest chest;
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            if (MachineRecipes.getOutputFromTempate(this.slots[4]) != null && MachineRecipes.getRecipeFromTempate(this.slots[4]) != null) {
                this.maxProgress = ItemAssemblyTemplate.getProcessTime(this.slots[4]) * this.speed / 100;
                if (this.power >= (long)this.consumption && this.removeItems(MachineRecipes.getRecipeFromTempate(this.slots[4]), this.cloneItemStackProper(this.slots))) {
                    if (this.slots[5] == null || this.slots[5] != null && this.slots[5].func_77973_b() == MachineRecipes.getOutputFromTempate(this.slots[4]).func_77946_l().func_77973_b() && this.slots[5].field_77994_a + MachineRecipes.getOutputFromTempate((ItemStack)this.slots[4]).func_77946_l().field_77994_a <= this.slots[5].func_77976_d()) {
                        ++this.progress;
                        this.isProgressing = true;
                        this.rotation += 5.0f;
                        if (this.rotation >= 360.0f) {
                            this.rotation -= 360.0f;
                        }
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.slots[5] == null) {
                                this.slots[5] = MachineRecipes.getOutputFromTempate(this.slots[4]).func_77946_l();
                            } else {
                                this.slots[5].field_77994_a += MachineRecipes.getOutputFromTempate((ItemStack)this.slots[4]).func_77946_l().field_77994_a;
                            }
                            this.removeItems(MachineRecipes.getRecipeFromTempate(this.slots[4]), this.slots);
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TileEntity te = null;
            if (meta == 2) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
            }
            if (meta == 3) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
            }
            if (meta == 4) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
            }
            if (meta == 5) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
            }
            if (te != null && te instanceof TileEntityChest) {
                chest = (TileEntityChest)te;
                this.tryFillContainer((IInventory)chest, 5);
            }
            if (te != null && te instanceof TileEntityHopper) {
                hopper = (TileEntityHopper)te;
                this.tryFillContainer((IInventory)hopper, 5);
            }
            if (te != null && te instanceof TileEntityCrateIron) {
                hopper = (TileEntityCrateIron)te;
                this.tryFillContainer((IInventory)hopper, 5);
            }
            if (te != null && te instanceof TileEntityCrateSteel) {
                hopper = (TileEntityCrateSteel)te;
                this.tryFillContainer((IInventory)hopper, 5);
            }
            te = null;
            if (meta == 2) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1);
            }
            if (meta == 3) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1);
            }
            if (meta == 4) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3);
            }
            if (meta == 5) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3);
            }
            if (te != null && te instanceof TileEntityChest) {
                chest = (TileEntityChest)te;
                for (i = 0; i < chest.func_70302_i_() && !this.tryFillAssembler((IInventory)chest, i); ++i) {
                }
            }
            if (te != null && te instanceof TileEntityHopper) {
                hopper = (TileEntityHopper)te;
                for (i = 0; i < hopper.func_70302_i_() && !this.tryFillAssembler((IInventory)hopper, i); ++i) {
                }
            }
            if (te != null && te instanceof TileEntityCrateIron) {
                hopper = (TileEntityCrateIron)te;
                for (i = 0; i < ((TileEntityCrateIron)((Object)hopper)).func_70302_i_() && !this.tryFillAssembler((IInventory)hopper, i); ++i) {
                }
            }
            if (te != null && te instanceof TileEntityCrateSteel) {
                hopper = (TileEntityCrateSteel)te;
                for (i = 0; i < ((TileEntityCrateSteel)((Object)hopper)).func_70302_i_() && !this.tryFillAssembler((IInventory)hopper, i); ++i) {
                }
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new TEAssemblerPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rotation, this.isProgressing));
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    public ItemStack[] cloneItemStackProper(ItemStack[] array) {
        ItemStack[] stack = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            stack[i] = array[i] != null ? array[i].func_77946_l() : null;
        }
        return stack;
    }

    public boolean tryFillContainer(IInventory inventory, int slot) {
        int i;
        int size = inventory.func_70302_i_();
        for (i = 0; i < size; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta1 = inventory.func_70301_a(i).func_77946_l();
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || inventory.func_70301_a((int)i).field_77994_a >= inventory.func_70301_a(i).func_77976_d()) continue;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            ItemStack sta3 = inventory.func_70301_a(i).func_77946_l();
            ++sta3.field_77994_a;
            inventory.func_70299_a(i, sta3);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (inventory.func_70301_a(i) != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            inventory.func_70299_a(i, sta2);
            return true;
        }
        return false;
    }

    public boolean tryFillAssembler(IInventory inventory, int slot) {
        int i;
        if (MachineRecipes.getOutputFromTempate(this.slots[4]) == null || MachineRecipes.getRecipeFromTempate(this.slots[4]) == null) {
            return false;
        }
        List<ItemStack> list = MachineRecipes.getRecipeFromTempate(this.slots[4]);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.get((int)i2).field_77994_a = 1;
        }
        if (inventory.func_70301_a(slot) == null) {
            return false;
        }
        ItemStack stack = inventory.func_70301_a(slot).func_77946_l();
        stack.field_77994_a = 1;
        boolean flag = false;
        for (int i3 = 0; i3 < list.size(); ++i3) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)list.get(i3)) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)list.get(i3))) continue;
            flag = true;
        }
        if (!flag) {
            return false;
        }
        for (i = 6; i < 18; ++i) {
            if (this.slots[i] == null) continue;
            ItemStack sta1 = inventory.func_70301_a(slot).func_77946_l();
            ItemStack sta2 = this.slots[i].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            ++this.slots[i].field_77994_a;
            return true;
        }
        for (i = 6; i < 18; ++i) {
            ItemStack sta2 = inventory.func_70301_a(slot).func_77946_l();
            if (this.slots[i] != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            this.slots[i] = sta2.func_77946_l();
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            return true;
        }
        return false;
    }

    public boolean removeItems(List<ItemStack> stack, ItemStack[] array) {
        if (stack == null) {
            return false;
        }
        for (int i = 0; i < stack.size(); ++i) {
            for (int j = 0; j < stack.get((int)i).field_77994_a; ++j) {
                ItemStack sta = stack.get(i).func_77946_l();
                sta.field_77994_a = 1;
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(ItemStack stack, ItemStack[] array) {
        ItemStack st = stack.func_77946_l();
        if (st == null) {
            return true;
        }
        for (int i = 6; i < 18; ++i) {
            if (array[i] == null) continue;
            ItemStack sta = array[i].func_77946_l();
            sta.field_77994_a = 1;
            if (sta == null || !this.isItemAcceptible(sta, st) || array[i].field_77994_a <= 0) continue;
            --array[i].field_77994_a;
            if (array[i].field_77994_a <= 0) {
                array[i] = null;
            }
            return true;
        }
        return false;
    }

    public boolean isItemAcceptible(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null) {
            if (ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1 != null && ids2 != null && ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

