/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineCentrifuge
extends TileEntity
implements ISidedInventory,
IConsumer {
    private ItemStack[] slots = new ItemStack[6];
    public int dualCookTime;
    public long power;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 200;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 3, 4, 5};
    private static final int[] slots_side = new int[]{1};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.centrifuge";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i != 2 && i != 3 && i != 4 && i != 5;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.dualCookTime = nbt.func_74765_d("CookTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74777_a("cookTime", (short)this.dualCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return j != 0 || i != 1 || itemStack.func_77973_b() == Items.field_151133_ar;
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.dualCookTime * i / 200;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack[] itemStack = MachineRecipes.getCentrifugeProcessingResult(this.slots[0]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[2] == null && this.slots[3] == null && this.slots[4] == null && this.slots[5] == null) {
            return true;
        }
        return (this.slots[2] == null || itemStack[0] != null && this.slots[2].func_77969_a(itemStack[0]) && this.slots[2].field_77994_a + itemStack[0].field_77994_a <= itemStack[0].func_77976_d()) && (this.slots[3] == null || itemStack[1] != null && this.slots[3].func_77969_a(itemStack[1]) && this.slots[3].field_77994_a + itemStack[1].field_77994_a <= itemStack[1].func_77976_d()) && (this.slots[4] == null || itemStack[2] != null && this.slots[4].func_77969_a(itemStack[2]) && this.slots[4].field_77994_a + itemStack[2].field_77994_a <= itemStack[2].func_77976_d()) && (this.slots[5] == null || itemStack[3] != null && this.slots[5].func_77969_a(itemStack[3]) && this.slots[5].field_77994_a + itemStack[3].field_77994_a <= itemStack[3].func_77976_d());
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack[] itemStack = MachineRecipes.getCentrifugeProcessingResult(this.slots[0]);
            if (this.slots[2] == null && itemStack[0] != null) {
                this.slots[2] = itemStack[0].func_77946_l();
            } else if (itemStack[0] != null && this.slots[2].func_77969_a(itemStack[0])) {
                this.slots[2].field_77994_a += itemStack[0].field_77994_a;
            }
            if (this.slots[3] == null && itemStack[1] != null) {
                this.slots[3] = itemStack[1].func_77946_l();
            } else if (itemStack[1] != null && this.slots[3].func_77969_a(itemStack[1])) {
                this.slots[3].field_77994_a += itemStack[1].field_77994_a;
            }
            if (this.slots[4] == null && itemStack[2] != null) {
                this.slots[4] = itemStack[2].func_77946_l();
            } else if (itemStack[2] != null && this.slots[4].func_77969_a(itemStack[2])) {
                this.slots[4].field_77994_a += itemStack[2].field_77994_a;
            }
            if (this.slots[5] == null && itemStack[3] != null) {
                this.slots[5] = itemStack[3].func_77946_l();
            } else if (itemStack[3] != null && this.slots[5].func_77969_a(itemStack[3])) {
                this.slots[5].field_77994_a += itemStack[3].field_77994_a;
            }
            for (int i = 0; i < 1; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.hasPower();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            if (this.hasPower() && this.isProcessing()) {
                this.power -= 200L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            this.isProgressing = this.hasPower() && this.canProcess();
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.dualCookTime, 0));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isProgressing ? 1 : 0, 1));
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        if (this.hasPower() && this.canProcess()) {
            ++this.dualCookTime;
            if (this.dualCookTime >= 200) {
                this.dualCookTime = 0;
                this.processItem();
            }
        } else {
            this.dualCookTime = 0;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

