/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBattery;
import com.hbm.items.tool.ItemChemistryTemplate;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEChemplantPacket;
import com.hbm.tileentity.machine.TileEntityCrateIron;
import com.hbm.tileentity.machine.TileEntityCrateSteel;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineChemplant
extends TileEntity
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidAcceptor,
IFluidSource {
    private ItemStack[] slots;
    public long power;
    public static final long maxPower = 100000L;
    public int progress;
    public int maxProgress = 100;
    public float rotation = 0.0f;
    public boolean isProgressing;
    int age = 0;
    int consumption = 100;
    int speed = 100;
    public FluidTank[] tanks;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    Random rand = new Random();
    private String customName;

    public TileEntityMachineChemplant() {
        this.slots = new ItemStack[21];
        this.tanks = new FluidTank[4];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.NONE, 16000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.NONE, 16000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.NONE, 16000, 2);
        this.tanks[3] = new FluidTank(FluidTypeHandler.FluidType.NONE, 16000, 3);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.chemplant";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof ItemBattery) {
            return true;
        }
        return i == 1;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "input1");
        this.tanks[1].readFromNBT(nbt, "input2");
        this.tanks[2].readFromNBT(nbt, "output1");
        this.tanks[3].readFromNBT(nbt, "output2");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "input1");
        this.tanks[1].writeToNBT(nbt, "input2");
        this.tanks[2].writeToNBT(nbt, "output1");
        this.tanks[3].writeToNBT(nbt, "output2");
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public void func_145845_h() {
        int i;
        this.consumption = 100;
        this.speed = 100;
        for (i = 1; i < 4; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null) continue;
            if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                this.speed -= 25;
                this.consumption += 300;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                this.speed -= 50;
                this.consumption += 600;
            }
            if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                this.speed -= 75;
                this.consumption += 900;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                this.consumption -= 30;
                this.speed += 5;
            }
            if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                this.consumption -= 60;
                this.speed += 10;
            }
            if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
            this.consumption -= 90;
            this.speed += 15;
        }
        if (this.speed < 25) {
            this.speed = 25;
        }
        if (this.consumption < 10) {
            this.consumption = 10;
        }
        if (!this.field_145850_b.field_72995_K) {
            Object hopper;
            int i2;
            Object chest;
            this.isProgressing = false;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[2].getTankType());
                this.fillFluidInit(this.tanks[3].getTankType());
            }
            this.setContainers();
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            this.tanks[0].loadTank(17, 19, this.slots);
            this.tanks[1].loadTank(18, 20, this.slots);
            this.tanks[2].unloadTank(9, 11, this.slots);
            this.tanks[3].unloadTank(10, 12, this.slots);
            for (i = 0; i < 4; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            Object[] inputs = MachineRecipes.getFluidInputFromTempate(this.slots[4]);
            Object[] outputs = MachineRecipes.getFluidOutputFromTempate(this.slots[4]);
            if (!(MachineRecipes.getChemInputFromTempate(this.slots[4]) == null && Library.isArrayEmpty(inputs) || MachineRecipes.getChemOutputFromTempate(this.slots[4]) == null && Library.isArrayEmpty(outputs))) {
                this.maxProgress = ItemChemistryTemplate.getProcessTime(this.slots[4]) * this.speed / 100;
                if (this.power >= (long)this.consumption && this.removeItems(MachineRecipes.getChemInputFromTempate(this.slots[4]), this.cloneItemStackProper(this.slots)) && this.hasFluidsStored((FluidStack[])inputs)) {
                    if (this.hasSpaceForItems(MachineRecipes.getChemOutputFromTempate(this.slots[4])) && this.hasSpaceForFluids((FluidStack[])outputs)) {
                        ++this.progress;
                        this.isProgressing = true;
                        this.rotation += 5.0f;
                        if (this.rotation >= 360.0f) {
                            this.rotation -= 360.0f;
                        }
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            this.addItems(MachineRecipes.getChemOutputFromTempate(this.slots[4]));
                            this.addFluids((FluidStack[])outputs);
                            this.removeItems(MachineRecipes.getChemInputFromTempate(this.slots[4]), this.slots);
                            this.removeFluids((FluidStack[])inputs);
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TileEntity te = null;
            if (meta == 2) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
            }
            if (meta == 3) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
            }
            if (meta == 4) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
            }
            if (meta == 5) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
            }
            if (te != null && te instanceof TileEntityChest) {
                chest = (TileEntityChest)te;
                for (i2 = 5; i2 < 9; ++i2) {
                    this.tryFillContainer((IInventory)chest, i2);
                }
            }
            if (te != null && te instanceof TileEntityHopper) {
                hopper = (TileEntityHopper)te;
                for (i2 = 5; i2 < 9; ++i2) {
                    this.tryFillContainer((IInventory)hopper, i2);
                }
            }
            if (te != null && te instanceof TileEntityCrateIron) {
                hopper = (TileEntityCrateIron)te;
                for (i2 = 5; i2 < 9; ++i2) {
                    this.tryFillContainer((IInventory)hopper, i2);
                }
            }
            if (te != null && te instanceof TileEntityCrateSteel) {
                hopper = (TileEntityCrateSteel)te;
                for (i2 = 5; i2 < 9; ++i2) {
                    this.tryFillContainer((IInventory)hopper, i2);
                }
            }
            te = null;
            if (meta == 2) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1);
            }
            if (meta == 3) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1);
            }
            if (meta == 4) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3);
            }
            if (meta == 5) {
                te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3);
            }
            if (te != null && te instanceof TileEntityChest) {
                chest = (TileEntityChest)te;
                for (i2 = 0; i2 < chest.func_70302_i_() && !this.tryFillAssembler((IInventory)chest, i2); ++i2) {
                }
            }
            if (te != null && te instanceof TileEntityHopper) {
                hopper = (TileEntityHopper)te;
                for (i2 = 0; i2 < hopper.func_70302_i_() && !this.tryFillAssembler((IInventory)hopper, i2); ++i2) {
                }
            }
            if (te != null && te instanceof TileEntityCrateIron) {
                chest = (TileEntityCrateIron)te;
                for (i2 = 0; i2 < ((TileEntityCrateIron)((Object)chest)).func_70302_i_() && !this.tryFillAssembler((IInventory)chest, i2); ++i2) {
                }
            }
            if (te != null && te instanceof TileEntityCrateSteel) {
                hopper = (TileEntityCrateSteel)te;
                for (i2 = 0; i2 < ((TileEntityCrateSteel)((Object)hopper)).func_70302_i_() && !this.tryFillAssembler((IInventory)hopper, i2); ++i2) {
                }
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new TEChemplantPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rotation, this.isProgressing));
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    private void setContainers() {
        if (this.slots[4] != null && (this.slots[4] == null || this.slots[4].func_77973_b() instanceof ItemChemistryTemplate)) {
            FluidStack[] inputs = MachineRecipes.getFluidInputFromTempate(this.slots[4]);
            FluidStack[] outputs = MachineRecipes.getFluidOutputFromTempate(this.slots[4]);
            this.tanks[0].setTankType(inputs[0] == null ? FluidTypeHandler.FluidType.NONE : inputs[0].type);
            this.tanks[1].setTankType(inputs[1] == null ? FluidTypeHandler.FluidType.NONE : inputs[1].type);
            this.tanks[2].setTankType(outputs[0] == null ? FluidTypeHandler.FluidType.NONE : outputs[0].type);
            this.tanks[3].setTankType(outputs[1] == null ? FluidTypeHandler.FluidType.NONE : outputs[1].type);
        }
    }

    public boolean hasFluidsStored(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return true;
        }
        return (fluids[0] == null || fluids[0] != null && fluids[0].fill <= this.tanks[0].getFill()) && (fluids[1] == null || fluids[1] != null && fluids[1].fill <= this.tanks[1].getFill());
    }

    public boolean hasSpaceForFluids(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return true;
        }
        return (fluids[0] == null || fluids[0] != null && this.tanks[2].getFill() + fluids[0].fill <= this.tanks[2].getMaxFill()) && (fluids[1] == null || fluids[1] != null && this.tanks[3].getFill() + fluids[1].fill <= this.tanks[3].getMaxFill());
    }

    public void removeFluids(FluidStack[] fluids) {
        if (Library.isArrayEmpty(fluids)) {
            return;
        }
        if (fluids[0] != null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - fluids[0].fill);
        }
        if (fluids[1] != null) {
            this.tanks[1].setFill(this.tanks[1].getFill() - fluids[1].fill);
        }
    }

    public boolean hasSpaceForItems(ItemStack[] stacks) {
        ItemStack sta7;
        ItemStack sta6;
        ItemStack sta5;
        ItemStack sta4;
        ItemStack sta3;
        ItemStack sta2;
        ItemStack sta1;
        if (stacks == null) {
            return true;
        }
        if (stacks != null && Library.isArrayEmpty(stacks)) {
            return true;
        }
        ItemStack sta0 = Library.carefulCopy(this.slots[5]);
        if (sta0 != null) {
            sta0.field_77994_a = 1;
        }
        if ((sta1 = Library.carefulCopy(stacks[0])) != null) {
            sta1.field_77994_a = 1;
        }
        if ((sta2 = Library.carefulCopy(this.slots[6])) != null) {
            sta2.field_77994_a = 1;
        }
        if ((sta3 = Library.carefulCopy(stacks[1])) != null) {
            sta3.field_77994_a = 1;
        }
        if ((sta4 = Library.carefulCopy(this.slots[7])) != null) {
            sta4.field_77994_a = 1;
        }
        if ((sta5 = Library.carefulCopy(stacks[2])) != null) {
            sta5.field_77994_a = 1;
        }
        if ((sta6 = Library.carefulCopy(this.slots[8])) != null) {
            sta6.field_77994_a = 1;
        }
        if ((sta7 = Library.carefulCopy(stacks[3])) != null) {
            sta7.field_77994_a = 1;
        }
        return (this.slots[5] == null || stacks[0] == null || stacks[0] != null && ItemStack.func_77989_b((ItemStack)sta0, (ItemStack)sta1) && ItemStack.func_77970_a((ItemStack)sta0, (ItemStack)sta1) && this.slots[5].field_77994_a + stacks[0].field_77994_a <= this.slots[5].func_77976_d()) && (this.slots[6] == null || stacks[1] == null || stacks[1] != null && ItemStack.func_77989_b((ItemStack)sta2, (ItemStack)sta3) && ItemStack.func_77970_a((ItemStack)sta2, (ItemStack)sta3) && this.slots[6].field_77994_a + stacks[1].field_77994_a <= this.slots[6].func_77976_d()) && (this.slots[7] == null || stacks[2] == null || stacks[2] != null && ItemStack.func_77989_b((ItemStack)sta4, (ItemStack)sta5) && ItemStack.func_77970_a((ItemStack)sta4, (ItemStack)sta5) && this.slots[7].field_77994_a + stacks[2].field_77994_a <= this.slots[7].func_77976_d()) && (this.slots[8] == null || stacks[3] == null || stacks[3] != null && ItemStack.func_77989_b((ItemStack)sta6, (ItemStack)sta7) && ItemStack.func_77970_a((ItemStack)sta6, (ItemStack)sta7) && this.slots[8].field_77994_a + stacks[3].field_77994_a <= this.slots[8].func_77976_d());
    }

    public void addItems(ItemStack[] stacks) {
        if (this.slots[5] == null && stacks[0] != null) {
            this.slots[5] = stacks[0].func_77946_l();
        } else if (this.slots[5] != null && stacks[0] != null) {
            this.slots[5].field_77994_a += stacks[0].field_77994_a;
        }
        if (this.slots[6] == null && stacks[1] != null) {
            this.slots[6] = stacks[1].func_77946_l();
        } else if (this.slots[6] != null && stacks[1] != null) {
            this.slots[6].field_77994_a += stacks[1].field_77994_a;
        }
        if (this.slots[7] == null && stacks[2] != null) {
            this.slots[7] = stacks[2].func_77946_l();
        } else if (this.slots[7] != null && stacks[2] != null) {
            this.slots[7].field_77994_a += stacks[2].field_77994_a;
        }
        if (this.slots[8] == null && stacks[3] != null) {
            this.slots[8] = stacks[3].func_77946_l();
        } else if (this.slots[8] != null && stacks[3] != null) {
            this.slots[8].field_77994_a += stacks[3].field_77994_a;
        }
    }

    public void addFluids(FluidStack[] stacks) {
        if (stacks[0] != null) {
            this.tanks[2].setFill(this.tanks[2].getFill() + stacks[0].fill);
        }
        if (stacks[1] != null) {
            this.tanks[3].setFill(this.tanks[3].getFill() + stacks[1].fill);
        }
    }

    public ItemStack[] cloneItemStackProper(ItemStack[] array) {
        ItemStack[] stack = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            stack[i] = array[i] != null ? array[i].func_77946_l() : null;
        }
        return stack;
    }

    public boolean tryFillContainer(IInventory inventory, int slot) {
        int i;
        int size = inventory.func_70302_i_();
        for (i = 0; i < size; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta1 = inventory.func_70301_a(i).func_77946_l();
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || inventory.func_70301_a((int)i).field_77994_a >= inventory.func_70301_a(i).func_77976_d()) continue;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            ItemStack sta3 = inventory.func_70301_a(i).func_77946_l();
            ++sta3.field_77994_a;
            inventory.func_70299_a(i, sta3);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (inventory.func_70301_a(i) != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            inventory.func_70299_a(i, sta2);
            return true;
        }
        return false;
    }

    public boolean tryFillAssembler(IInventory inventory, int slot) {
        int i;
        Object[] inputs = MachineRecipes.getFluidInputFromTempate(this.slots[4]);
        Object[] outputs = MachineRecipes.getFluidOutputFromTempate(this.slots[4]);
        if (MachineRecipes.getChemInputFromTempate(this.slots[4]) == null && Library.isArrayEmpty(inputs) || MachineRecipes.getChemOutputFromTempate(this.slots[4]) == null && Library.isArrayEmpty(outputs)) {
            return false;
        }
        List<ItemStack> list = MachineRecipes.getChemInputFromTempate(this.slots[4]);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.get((int)i2).field_77994_a = 1;
        }
        if (inventory.func_70301_a(slot) == null) {
            return false;
        }
        ItemStack stack = inventory.func_70301_a(slot).func_77946_l();
        stack.field_77994_a = 1;
        boolean flag = false;
        for (int i3 = 0; i3 < list.size(); ++i3) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)list.get(i3)) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)list.get(i3))) continue;
            flag = true;
        }
        if (!flag) {
            return false;
        }
        for (i = 13; i < 17; ++i) {
            if (this.slots[i] == null) continue;
            ItemStack sta1 = inventory.func_70301_a(slot).func_77946_l();
            ItemStack sta2 = this.slots[i].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            ++this.slots[i].field_77994_a;
            return true;
        }
        for (i = 13; i < 17; ++i) {
            ItemStack sta2 = inventory.func_70301_a(slot).func_77946_l();
            if (this.slots[i] != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            this.slots[i] = sta2.func_77946_l();
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            return true;
        }
        return false;
    }

    public boolean removeItems(List<ItemStack> stack, ItemStack[] array) {
        if (stack == null || stack.isEmpty()) {
            return true;
        }
        for (int i = 0; i < stack.size(); ++i) {
            for (int j = 0; j < stack.get((int)i).field_77994_a; ++j) {
                ItemStack sta = stack.get(i).func_77946_l();
                sta.field_77994_a = 1;
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(ItemStack stack, ItemStack[] array) {
        ItemStack st = stack.func_77946_l();
        if (st == null) {
            return true;
        }
        for (int i = 13; i < 17; ++i) {
            if (array[i] == null) continue;
            ItemStack sta = array[i].func_77946_l();
            sta.field_77994_a = 1;
            if (sta == null || !this.isItemAcceptible(sta, st) || array[i].field_77994_a <= 0) continue;
            --array[i].field_77994_a;
            if (array[i].field_77994_a <= 0) {
                array[i] = null;
            }
            return true;
        }
        return false;
    }

    public boolean isItemAcceptible(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null) {
            if (ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1 != null && ids2 != null && ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 4 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 4 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        } else if (type.name().equals(this.tanks[3].getTankType().name())) {
            this.tanks[3].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.tanks[3].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == 5) {
            this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        }
        if (meta == 3) {
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3, this.getTact(), type);
        }
        if (meta == 2) {
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3, this.getTact(), type);
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3, this.getTact(), type);
        }
        if (meta == 4) {
            this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.list1;
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.list2;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.list1.clear();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            this.list2.clear();
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        list.add(this.tanks[3]);
        return list;
    }
}

