/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionParticleB;
import com.hbm.explosion.ExplosionThermo;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineCyclotron
extends TileEntity
implements ISidedInventory,
ISource {
    private ItemStack[] slots;
    public long power;
    public int progress;
    public int soundCycle = 0;
    public static final long maxPower = 1000000000L;
    public static final int processTime = 690;
    public boolean isOn = false;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    Random rand = new Random();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 0};
    private static final int[] slots_side = new int[]{0};
    private String customName;

    public TileEntityMachineCyclotron() {
        this.slots = new ItemStack[16];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.cyclotron";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.isOn = nbt.func_74767_n("isOn");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74757_a("isOn", this.isOn);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            if (!this.isOn && this.hasFuse() && this.getHeatLevel() != 4 && this.hasEnergy() && (this.isPart(this.slots[0]) || this.isPart(this.slots[1]) || this.isPart(this.slots[2]))) {
                this.isOn = true;
                this.slots[6] = null;
            }
            if (!(!this.isOn || this.hasFuse() && (this.isPart(this.slots[0]) || this.isPart(this.slots[1]) || this.isPart(this.slots[2])))) {
                this.isOn = false;
            }
            if (this.isOn) {
                this.power += (long)this.getPower(this.slots[0]);
                this.power += (long)this.getPower(this.slots[1]);
                this.power += (long)this.getPower(this.slots[2]);
                if (this.power > 1000000000L) {
                    this.power = 1000000000L;
                }
                if (this.progress < 690) {
                    ++this.progress;
                } else {
                    this.progress = 0;
                    this.process();
                }
                if (this.slots[7] != null) {
                    this.slots[7].func_77964_b(this.slots[7].func_77960_j() + 1);
                    if (this.slots[7].func_77960_j() >= this.slots[7].func_77958_k()) {
                        this.slots[7] = null;
                    }
                }
                if (this.getCoolantTicksLeft() == 100) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.shutdown", 10.0f, 1.0f);
                }
                if (this.getHeatLevel() == 1) {
                    ExplosionChaos.flameDeath(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 15);
                }
                if (this.getHeatLevel() == 2) {
                    ExplosionChaos.flameDeath(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 25);
                    ExplosionChaos.burn(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7);
                    ExplosionThermo.setEntitiesOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7);
                }
                if (this.getHeatLevel() == 3) {
                    ExplosionChaos.flameDeath(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
                    ExplosionChaos.burn(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 15);
                    ExplosionThermo.setEntitiesOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 25);
                    ExplosionThermo.scorchLight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5);
                    if (this.rand.nextInt(50) == 0) {
                        ExplosionLarge.spawnTracers(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 5, (double)this.field_145849_e + 0.5, 3);
                    }
                }
                if (this.getHeatLevel() == 4) {
                    int i = this.rand.nextInt(4);
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                    if (i == 0) {
                        ExplosionLarge.explodeFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35 + this.rand.nextInt(21), true, true, true);
                    }
                    if (i == 1) {
                        this.field_145850_b.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(this.field_145850_b, (int)((double)MainRegistry.fatmanRadius * 1.5), this.field_145851_c, this.field_145848_d, this.field_145849_e));
                        ExplosionParticleB.spawnMush(this.field_145850_b, this.field_145851_c, this.field_145848_d - 3, this.field_145849_e);
                    }
                    if (i == 2) {
                        int j;
                        EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(this.field_145850_b);
                        entity.field_70165_t = this.field_145851_c;
                        entity.field_70163_u = this.field_145848_d;
                        entity.field_70161_v = this.field_145849_e;
                        entity.destructionRange = j = 15 + this.rand.nextInt(21);
                        entity.speed = 25;
                        entity.coefficient = 1.0f;
                        entity.waste = false;
                        this.field_145850_b.func_72838_d((Entity)entity);
                        EntityCloudFleija cloud = new EntityCloudFleija(this.field_145850_b, j);
                        cloud.field_70165_t = this.field_145851_c;
                        cloud.field_70163_u = this.field_145848_d;
                        cloud.field_70161_v = this.field_145849_e;
                        this.field_145850_b.func_72838_d((Entity)cloud);
                    }
                    if (i == 3) {
                        EntityBlackHole bl = new EntityBlackHole(this.field_145850_b, 1.5f + this.rand.nextFloat());
                        bl.field_70165_t = (float)this.field_145851_c + 0.5f;
                        bl.field_70163_u = (float)this.field_145848_d + 3.5f;
                        bl.field_70161_v = (float)this.field_145849_e + 0.5f;
                        this.field_145850_b.func_72838_d((Entity)bl);
                    }
                }
            } else {
                this.progress = 0;
            }
            this.power = Library.chargeItemsFromTE(this.slots, 9, this.power, 1000000000L);
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    public void process() {
        ItemStack stack1 = MachineRecipes.getCyclotronOutput(this.slots[0], this.slots[3]);
        ItemStack stack2 = MachineRecipes.getCyclotronOutput(this.slots[1], this.slots[4]);
        ItemStack stack3 = MachineRecipes.getCyclotronOutput(this.slots[2], this.slots[5]);
        if (stack1 != null && this.hasSpaceForItem(stack1.func_77973_b())) {
            this.addItemPlox(stack1.func_77973_b());
            --this.slots[0].field_77994_a;
            --this.slots[3].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            if (this.slots[3].field_77994_a <= 0) {
                this.slots[3] = null;
            }
        }
        if (stack2 != null && this.hasSpaceForItem(stack2.func_77973_b())) {
            this.addItemPlox(stack2.func_77973_b());
            --this.slots[1].field_77994_a;
            --this.slots[4].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
            if (this.slots[4].field_77994_a <= 0) {
                this.slots[4] = null;
            }
        }
        if (stack3 != null && this.hasSpaceForItem(stack3.func_77973_b())) {
            this.addItemPlox(stack3.func_77973_b());
            --this.slots[2].field_77994_a;
            --this.slots[5].field_77994_a;
            if (this.slots[2].field_77994_a <= 0) {
                this.slots[2] = null;
            }
            if (this.slots[5].field_77994_a <= 0) {
                this.slots[5] = null;
            }
        }
        if (this.slots[0] != null && stack1 == null) {
            if (this.rand.nextInt(100) < this.getAmatChance(this.slots[0]) && this.hasSpaceForItem(ModItems.cell_antimatter) && this.useCell()) {
                this.addItemPlox(ModItems.cell_antimatter);
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
        }
        if (this.slots[1] != null && stack1 == null) {
            if (this.rand.nextInt(100) < this.getAmatChance(this.slots[1]) && this.hasSpaceForItem(ModItems.cell_antimatter) && this.useCell()) {
                this.addItemPlox(ModItems.cell_antimatter);
            }
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
        }
        if (this.slots[2] != null && stack1 == null) {
            if (this.rand.nextInt(100) < this.getAmatChance(this.slots[2]) && this.hasSpaceForItem(ModItems.cell_antimatter) && this.useCell()) {
                this.addItemPlox(ModItems.cell_antimatter);
            }
            --this.slots[2].field_77994_a;
            if (this.slots[2].field_77994_a <= 0) {
                this.slots[2] = null;
            }
        }
    }

    public boolean hasSpaceForItem(Item item) {
        if (this.slots[11] == null || this.slots[12] == null || this.slots[13] == null || this.slots[14] == null || this.slots[15] == null) {
            return true;
        }
        if (this.slots[11] != null && this.slots[11].func_77973_b() == item && this.slots[11].field_77994_a < this.slots[11].func_77976_d()) {
            return true;
        }
        if (this.slots[12] != null && this.slots[12].func_77973_b() == item && this.slots[12].field_77994_a < this.slots[12].func_77976_d()) {
            return true;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == item && this.slots[13].field_77994_a < this.slots[13].func_77976_d()) {
            return true;
        }
        if (this.slots[14] != null && this.slots[14].func_77973_b() == item && this.slots[14].field_77994_a < this.slots[14].func_77976_d()) {
            return true;
        }
        return this.slots[15] != null && this.slots[15].func_77973_b() == item && this.slots[15].field_77994_a < this.slots[15].func_77976_d();
    }

    public boolean useCell() {
        if (this.slots[10] != null && this.slots[10].func_77973_b() == ModItems.cell_empty) {
            --this.slots[10].field_77994_a;
            if (this.slots[10].field_77994_a <= 0) {
                this.slots[10] = null;
            }
            return true;
        }
        return false;
    }

    public void addItemPlox(Item item) {
        if (this.slots[11] != null && this.slots[11].func_77973_b() == item && this.slots[11].field_77994_a < this.slots[11].func_77976_d()) {
            ++this.slots[11].field_77994_a;
            return;
        }
        if (this.slots[12] != null && this.slots[12].func_77973_b() == item && this.slots[12].field_77994_a < this.slots[12].func_77976_d()) {
            ++this.slots[12].field_77994_a;
            return;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == item && this.slots[13].field_77994_a < this.slots[13].func_77976_d()) {
            ++this.slots[13].field_77994_a;
            return;
        }
        if (this.slots[14] != null && this.slots[14].func_77973_b() == item && this.slots[14].field_77994_a < this.slots[14].func_77976_d()) {
            ++this.slots[14].field_77994_a;
            return;
        }
        if (this.slots[15] != null && this.slots[15].func_77973_b() == item && this.slots[15].field_77994_a < this.slots[15].func_77976_d()) {
            ++this.slots[15].field_77994_a;
            return;
        }
        if (this.slots[11] == null) {
            this.slots[11] = new ItemStack(item, 1);
            return;
        }
        if (this.slots[12] == null) {
            this.slots[12] = new ItemStack(item, 1);
            return;
        }
        if (this.slots[13] == null) {
            this.slots[13] = new ItemStack(item, 1);
            return;
        }
        if (this.slots[14] == null) {
            this.slots[14] = new ItemStack(item, 1);
            return;
        }
        if (this.slots[15] == null) {
            this.slots[15] = new ItemStack(item, 1);
            return;
        }
    }

    public boolean hasFuse() {
        return this.slots[8] != null && (this.slots[8].func_77973_b() == ModItems.fuse || this.slots[8].func_77973_b() == ModItems.screwdriver);
    }

    public boolean hasEnergy() {
        return this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.crystal_energy;
    }

    public int getHeatLevel() {
        if (this.slots[7] != null && this.slots[7].func_77973_b() == ModItems.pellet_coolant) {
            int i = this.slots[7].func_77960_j() * 100 / this.slots[7].func_77958_k();
            if (i < 75) {
                return 0;
            }
            if (i < 85) {
                return 1;
            }
            if (i < 95) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    public int getCoolantTicksLeft() {
        if (this.slots[7] != null && this.slots[7].func_77973_b() == ModItems.pellet_coolant) {
            int i = this.slots[7].func_77958_k() - this.slots[7].func_77960_j();
            return i;
        }
        return 0;
    }

    public boolean isPart(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == ModItems.part_lithium) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.part_beryllium) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.part_carbon) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.part_copper) {
                return true;
            }
            if (stack.func_77973_b() == ModItems.part_plutonium) {
                return true;
            }
        }
        return false;
    }

    public int getPower(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == ModItems.part_lithium) {
                return 25000;
            }
            if (stack.func_77973_b() == ModItems.part_beryllium) {
                return 35000;
            }
            if (stack.func_77973_b() == ModItems.part_carbon) {
                return 60000;
            }
            if (stack.func_77973_b() == ModItems.part_copper) {
                return 75000;
            }
            if (stack.func_77973_b() == ModItems.part_plutonium) {
                return 100000;
            }
        }
        return 0;
    }

    public int getAmatChance(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == ModItems.part_lithium) {
                return 2;
            }
            if (stack.func_77973_b() == ModItems.part_beryllium) {
                return 3;
            }
            if (stack.func_77973_b() == ModItems.part_carbon) {
                return 6;
            }
            if (stack.func_77973_b() == ModItems.part_copper) {
                return 29;
            }
            if (stack.func_77973_b() == ModItems.part_plutonium) {
                return 94;
            }
        }
        return 0;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 690;
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }
}

