/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineGasCent
extends TileEntity
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots = new ItemStack[9];
    public long power;
    public int progress;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 200;
    public FluidTank tank = new FluidTank(FluidTypeHandler.FluidType.UF6, 8000, 0);
    private static final int[] slots_top = new int[]{3};
    private static final int[] slots_bottom = new int[]{5, 6, 7, 8};
    private static final int[] slots_side = new int[]{0, 3};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.gasCentrifuge";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i != 2 && i != 3 && i != 4 && i != 5;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.progress = nbt.func_74765_d("CookTime");
        this.tank.readFromNBT(nbt, "tank");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74777_a("cookTime", (short)this.progress);
        this.tank.writeToNBT(nbt, "tank");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return j != 0 || i != 1 || itemStack.func_77973_b() == Items.field_151133_ar;
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / 200;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    private boolean canProcess() {
        if (this.power > 0L && this.tank.getFill() >= MachineRecipes.getFluidConsumedGasCent(this.tank.getTankType())) {
            List<MachineRecipes.GasCentOutput> list = MachineRecipes.getGasCentOutput(this.tank.getTankType());
            if (list == null) {
                return false;
            }
            if (list.size() < 1 || list.size() > 4) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                int slot = i + 5;
                if (this.slots[slot] == null || this.slots[slot].func_77973_b() == list.get((int)i).output.func_77973_b() && this.slots[slot].func_77960_j() == list.get((int)i).output.func_77960_j() && this.slots[slot].field_77994_a + list.get((int)i).output.field_77994_a <= this.slots[slot].func_77976_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void process() {
        List<MachineRecipes.GasCentOutput> out = MachineRecipes.getGasCentOutput(this.tank.getTankType());
        this.progress = 0;
        this.tank.setFill(this.tank.getFill() - MachineRecipes.getFluidConsumedGasCent(this.tank.getTankType()));
        ArrayList<MachineRecipes.GasCentOutput> random = new ArrayList<MachineRecipes.GasCentOutput>();
        for (int i = 0; i < out.size(); ++i) {
            for (int j = 0; j < out.get((int)i).weight; ++j) {
                random.add(out.get(i));
            }
        }
        Collections.shuffle(random);
        MachineRecipes.GasCentOutput result = (MachineRecipes.GasCentOutput)random.get(this.field_145850_b.field_73012_v.nextInt(random.size()));
        int slot = result.slot + 4;
        if (this.slots[slot] == null) {
            this.slots[slot] = result.output.func_77946_l();
        } else {
            this.slots[slot].field_77994_a += result.output.field_77994_a;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            this.tank.setType(1, 2, this.slots);
            this.tank.loadTank(3, 4, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.canProcess()) {
                this.isProgressing = true;
                ++this.progress;
                this.power -= 200L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
                if (this.progress >= 200) {
                    this.process();
                }
            } else {
                this.isProgressing = false;
                this.progress = 0;
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.progress, 0));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isProgressing ? 1 : 0, 1));
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }
}

