/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.particle.EntityGasFlameFX;
import com.hbm.explosion.ExplosionThermo;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.special.ItemBattery;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineGasFlare
extends TileEntity
implements ISidedInventory,
ISource,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots;
    public long power;
    public static final long maxPower = 100000L;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public FluidTank tank;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    Random rand = new Random();
    private String customName;

    public TileEntityMachineGasFlare() {
        this.slots = new ItemStack[3];
        this.tank = new FluidTank(FluidTypeHandler.FluidType.GAS, 64000, 0);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.gasFlare";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof ItemBattery) {
            return true;
        }
        return i == 1;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.tank.readFromNBT(nbt, "gas");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(nbt, "gas");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public void func_145845_h() {
        ++this.age;
        if (this.age >= 20) {
            this.age -= 20;
        }
        if (this.age == 9 || this.age == 19) {
            this.ffgeuaInit();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tank.loadTank(1, 2, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.tank.getFill() >= 10) {
                this.tank.setFill(this.tank.getFill() - 10);
                this.power += 50L;
                if (this.power > 100000L) {
                    this.power = 100000L;
                }
                this.field_145850_b.func_72838_d((Entity)new EntityGasFlameFX(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 11.0f, (float)this.field_145849_e + 0.5f, 0.0, 0.0, 0.0));
                ExplosionThermo.setEntitiesOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d + 11, this.field_145849_e, 5);
                if (this.age % 5 == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 11), (double)this.field_145849_e, "hbm:weapon.flamethrowerShoot", 1.5f, 1.0f);
                }
            }
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, 100000L);
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact());
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }
}

