/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.ISource;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEIGeneratorPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineIGenerator
extends TileEntity
implements ISidedInventory,
ISource {
    private ItemStack[] slots;
    public long power;
    public int torque;
    public int heat;
    public int water;
    public int lubricant;
    public int fuel;
    public int burn;
    public int soundCycle = 0;
    public float rotation;
    public static final long maxPower = 100000L;
    public static final int maxTorque = 2500;
    public static final int maxHeat = 7500;
    public static final int maxWater = 10000;
    public static final int maxLubricant = 10000;
    public static final int maxFuel = 50000;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 0};
    private static final int[] slots_side = new int[]{0};
    private String customName;

    public TileEntityMachineIGenerator() {
        this.slots = new ItemStack[16];
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.iGenerator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.torque = nbt.func_74762_e("torque");
        this.heat = nbt.func_74762_e("heat");
        this.water = nbt.func_74762_e("water");
        this.lubricant = nbt.func_74762_e("lubricant");
        this.fuel = nbt.func_74762_e("fuel");
        this.burn = nbt.func_74762_e("burn");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("torque", this.torque);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("water", this.water);
        nbt.func_74768_a("lubricant", this.lubricant);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74768_a("burn", this.burn);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            this.rotation += (float)this.torque / 100.0f;
            if (this.burn > 0) {
                --this.burn;
                if (this.heat + 10 <= 7500) {
                    this.heat += 10;
                }
            }
            if (this.water > 0) {
                if (this.heat >= 8) {
                    this.heat -= 8;
                    this.torque += 10;
                    --this.water;
                }
            } else if (this.heat >= 4) {
                this.heat -= 4;
                this.torque += 5;
            }
            this.heat += 5 * this.canLocateRTG();
            this.heat += 3 * this.canLocateWeakRTG();
            for (int i = 0; i < this.canLocateThermalElement(); ++i) {
                if (this.heat < 10) continue;
                this.heat -= 10;
                if (this.power + 10L > 100000L) continue;
                this.power += 10L;
            }
            this.power += (long)this.torque;
            if (this.power > 100000L) {
                this.power = 100000L;
            }
            if (this.torque > 0) {
                if (this.lubricant > 0) {
                    --this.torque;
                    --this.lubricant;
                } else {
                    this.torque -= 5;
                }
            }
            if (this.torque < 0) {
                this.torque = 0;
            }
            if (this.torque > 2500 && this.hasLimiter()) {
                this.torque = 2500;
            }
            if (this.torque > 2500) {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
            }
            if (this.getHeatScaled(100) < 90) {
                if (this.fuel > 0) {
                    --this.fuel;
                    if (this.heat + 10 <= 7500) {
                        this.heat += 10;
                    }
                }
                this.doSolidFuelTask();
            }
            this.doFuelTask();
            this.doLubeTask();
            this.doWaterTask();
            this.doBatteryTask();
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new TEIGeneratorPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rotation, this.torque));
            PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    public void doFuelTask() {
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.canister_fuel && this.fuel + 625 <= 50000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.fuel += 625;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.canister_smear && this.fuel + 200 <= 50000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.fuel += 200;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.canister_reoil && this.fuel + 350 <= 50000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.fuel += 350;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.canister_petroil && this.fuel + 500 <= 50000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.fuel += 500;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == Item.func_150898_a((Block)ModBlocks.red_barrel) && this.fuel + 5000 <= 50000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == ModItems.tank_steel && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(ModItems.tank_steel);
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.fuel += 5000;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.fluid_barrel_infinite) {
            this.fuel = 50000;
            this.lubricant = 10000;
            this.water = 10000;
        }
    }

    public void doLubeTask() {
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.canister_canola && this.lubricant + 625 <= 10000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.lubricant += 625;
        }
    }

    public void doWaterTask() {
        if (this.slots[13] != null && this.slots[13].func_77973_b() == Items.field_151131_as && this.water + 625 <= 10000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.water += 625;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.rod_water && this.water + 625 <= 10000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.water += 625;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.rod_dual_water && this.water + 1250 <= 10000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.water += 1250;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.rod_quad_water && this.water + 2500 <= 10000 && (this.slots[14] == null || this.slots[14] != null && this.slots[14].func_77973_b() == this.slots[13].func_77973_b().func_77668_q() && this.slots[14].field_77994_a < this.slots[14].func_77976_d())) {
            if (this.slots[14] == null) {
                this.slots[14] = new ItemStack(this.slots[13].func_77973_b().func_77668_q());
            } else {
                ++this.slots[14].field_77994_a;
            }
            --this.slots[13].field_77994_a;
            if (this.slots[13].field_77994_a <= 0) {
                this.slots[13] = null;
            }
            this.water += 2500;
        }
        if (this.slots[13] != null && this.slots[13].func_77973_b() == ModItems.inf_water) {
            this.water = 10000;
        }
    }

    public void doSolidFuelTask() {
        if (this.slots[12] != null && this.slots[12].func_77973_b() == Items.field_151044_h && this.burn <= 0) {
            --this.slots[12].field_77994_a;
            this.burn = 200;
            if (this.slots[12].field_77994_a == 0) {
                this.slots[12] = null;
            }
        }
        if (this.slots[12] != null && this.slots[12].func_77973_b() == ModItems.powder_coal && this.burn <= 0) {
            --this.slots[12].field_77994_a;
            this.burn = 200;
            if (this.slots[12].field_77994_a == 0) {
                this.slots[12] = null;
            }
        }
        if (this.slots[12] != null && this.slots[12].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci) && this.burn <= 0) {
            --this.slots[12].field_77994_a;
            this.burn = 2000;
            if (this.slots[12].field_77994_a == 0) {
                this.slots[12] = null;
            }
        }
    }

    public void doBatteryTask() {
        this.power = Library.chargeItemsFromTE(this.slots, 15, this.power, 100000L);
    }

    public int canLocateThermalElement() {
        int thermo = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.thermo_element) continue;
            ++thermo;
        }
        return thermo;
    }

    public int canLocateRTG() {
        int rtg = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.pellet_rtg) continue;
            ++rtg;
        }
        return rtg;
    }

    public int canLocateWeakRTG() {
        int rtg = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.pellet_rtg_weak) continue;
            ++rtg;
        }
        return rtg;
    }

    public boolean hasLimiter() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.limiter) continue;
            return true;
        }
        return false;
    }

    public int getFuelScaled(int i) {
        return this.fuel * i / 50000;
    }

    public int getLubeScaled(int i) {
        return this.lubricant * i / 10000;
    }

    public int getWaterScaled(int i) {
        return this.water * i / 10000;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 7500;
    }

    public int getTorqueScaled(int i) {
        return this.torque * i / 2500;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        int i = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (i == 5) {
            this.ffgeua(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e, this.getTact());
            this.ffgeua(this.field_145851_c - 4, this.field_145848_d, this.field_145849_e, this.getTact());
        }
        if (i == 3) {
            this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3, this.getTact());
            this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 4, this.getTact());
        }
        if (i == 4) {
            this.ffgeua(this.field_145851_c + 4, this.field_145848_d, this.field_145849_e, this.getTact());
            this.ffgeua(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e, this.getTact());
        }
        if (i == 2) {
            this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 4, this.getTact());
            this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3, this.getTact());
        }
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }
}

