/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineInserter
extends TileEntity
implements ISidedInventory,
IFluidContainer,
IFluidSource,
IFluidAcceptor {
    private ItemStack[] slots;
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0};
    private static final int[] slots_side = new int[]{0};
    public int age = 0;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list3 = new ArrayList<IFluidAcceptor>();
    private String customName;

    public TileEntityMachineInserter() {
        this.slots = new ItemStack[9];
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.NONE, 32000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.NONE, 32000, 0);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.NONE, 32000, 0);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.inserter";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "content1");
        this.tanks[1].readFromNBT(nbt, "content2");
        this.tanks[2].readFromNBT(nbt, "content3");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "content1");
        this.tanks[1].writeToNBT(nbt, "content2");
        this.tanks[2].writeToNBT(nbt, "content3");
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                if (this.dna1()) {
                    this.fillFluidInit(this.tanks[0].getTankType());
                }
                if (this.dna2()) {
                    this.fillFluidInit(this.tanks[1].getTankType());
                }
                if (this.dna3()) {
                    this.fillFluidInit(this.tanks[2].getTankType());
                }
            }
            this.tanks[0].setType(1, 2, this.slots);
            this.tanks[1].setType(4, 5, this.slots);
            this.tanks[2].setType(7, 8, this.slots);
            this.tanks[0].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.tanks[1].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.tanks[2].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean dna1() {
        return this.slots[0] != null && (this.slots[0].func_77973_b() == ModItems.fuse || this.slots[0].func_77973_b() == ModItems.screwdriver);
    }

    public boolean dna2() {
        return this.slots[3] != null && (this.slots[3].func_77973_b() == ModItems.fuse || this.slots[3].func_77973_b() == ModItems.screwdriver);
    }

    public boolean dna3() {
        return this.slots[6] != null && (this.slots[6].func_77973_b() == ModItems.fuse || this.slots[6].func_77973_b() == ModItems.screwdriver);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getMaxFill();
        }
        return 0;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.list1;
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.list2;
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.list3;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.list1.clear();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.list2.clear();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.list3.clear();
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        return list;
    }
}

