/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.missile.EntityMissileAntiBallistic;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.interfaces.IConsumer;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TERadarDestructorPacket;
import com.hbm.packet.TERadarPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineRadar
extends TileEntity
implements IConsumer {
    public static List<EntityMissileBaseAdvanced> allMissiles = new ArrayList<EntityMissileBaseAdvanced>();
    public List<int[]> nearbyMissiles = new ArrayList<int[]>();
    int pingTimer = 0;
    static final int maxTimer = 40;
    public long power = 0L;
    public static final int maxPower = 100000;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
    }

    public void func_145845_h() {
        if (this.field_145848_d < MainRegistry.radarAltitude) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.nearbyMissiles.clear();
        }
        if (this.power > 0L) {
            if (!this.field_145850_b.field_72995_K) {
                this.allocateMissiles();
                this.sendMissileData();
            }
            this.power -= 500L;
            if (this.power < 0L) {
                this.power = 0L;
            }
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
        ++this.pingTimer;
        if (this.power > 0L && this.pingTimer >= 40) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.sonarPing", 5.0f, 1.0f);
            this.pingTimer = 0;
        }
    }

    private void allocateMissiles() {
        this.nearbyMissiles.clear();
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)MainRegistry.radarRange), (double)0.0, (double)((double)this.field_145849_e + 0.5 - (double)MainRegistry.radarRange), (double)((double)this.field_145851_c + 0.5 + (double)MainRegistry.radarRange), (double)5000.0, (double)((double)this.field_145849_e + 0.5 + (double)MainRegistry.radarRange)));
        for (Entity entity : list) {
            if (entity instanceof EntityPlayer && entity.field_70163_u >= (double)(this.field_145848_d + MainRegistry.radarBuffer)) {
                this.nearbyMissiles.add(new int[]{(int)entity.field_70165_t, (int)entity.field_70161_v, 5, (int)entity.field_70163_u});
            }
            if (!(entity instanceof EntityMissileAntiBallistic) || !(entity.field_70163_u >= (double)(this.field_145848_d + MainRegistry.radarBuffer))) continue;
            this.nearbyMissiles.add(new int[]{(int)entity.field_70165_t, (int)entity.field_70161_v, 4, (int)entity.field_70163_u});
        }
        for (Entity entity : allMissiles) {
            if (entity == null || entity.field_70128_L || !(entity.field_70163_u >= (double)(this.field_145848_d + MainRegistry.radarBuffer)) || !(entity instanceof EntityMissileBaseAdvanced) || !(entity.field_70165_t < (double)(this.field_145851_c + MainRegistry.radarRange)) || !(entity.field_70165_t > (double)(this.field_145851_c - MainRegistry.radarRange)) || !(entity.field_70161_v < (double)(this.field_145849_e + MainRegistry.radarRange)) || !(entity.field_70161_v > (double)(this.field_145849_e - MainRegistry.radarRange))) continue;
            EntityMissileBaseAdvanced mis = (EntityMissileBaseAdvanced)entity;
            this.nearbyMissiles.add(new int[]{(int)mis.field_70165_t, (int)mis.field_70161_v, mis.getMissileType(), (int)mis.field_70163_u});
        }
    }

    public int getRedPower() {
        if (!this.nearbyMissiles.isEmpty()) {
            double maxRange = (double)MainRegistry.radarRange * Math.sqrt(2.0);
            int power = 0;
            for (int i = 0; i < this.nearbyMissiles.size(); ++i) {
                int[] j = this.nearbyMissiles.get(i);
                double dist = Math.sqrt(Math.pow(j[0] - this.field_145851_c, 2.0) + Math.pow(j[1] - this.field_145849_e, 2.0));
                int p = 15 - (int)Math.floor(dist / maxRange * 15.0);
                if (p <= power) continue;
                power = p;
            }
            return power;
        }
        return 0;
    }

    private void sendMissileData() {
        PacketDispatcher.wrapper.sendToAll((IMessage)new TERadarDestructorPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        for (int[] e : this.nearbyMissiles) {
            PacketDispatcher.wrapper.sendToAll((IMessage)new TERadarPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, e[0], e[1], e[2], e[3]));
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

