/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineReactorLarge
extends TileEntity
implements ISidedInventory,
IFluidContainer,
IFluidAcceptor,
IFluidSource {
    private ItemStack[] slots;
    public int hullHeat;
    public final int maxHullHeat = 100000;
    public int coreHeat;
    public final int maxCoreHeat = 50000;
    public int rods;
    public final int rodsMax = 100;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks;
    public ReactorFuelType type;
    public int fuel;
    public int maxFuel = 240 * fuelMult;
    public int waste;
    public int maxWaste = 240 * fuelMult;
    public static int fuelMult = 1000;
    public static int cycleDuration = 24000;
    private static int fuelBase = 240 * fuelMult;
    private static int waterBase = 128000;
    private static int coolantBase = 64000;
    private static int steamBase = 32000;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 16};
    private static final int[] slots_side = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16};
    private String customName;
    int height;
    int depth;
    public int size;
    static List<ReactorFuelEntry> fuels = new ArrayList<ReactorFuelEntry>();
    static List<ReactorWasteEntry> wastes = new ArrayList<ReactorWasteEntry>();

    public TileEntityMachineReactorLarge() {
        this.slots = new ItemStack[8];
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 128000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 64000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.STEAM, 32000, 2);
        this.type = ReactorFuelType.URANIUM;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.reactorLarge";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.coreHeat = nbt.func_74762_e("heat");
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.rods = nbt.func_74762_e("rods");
        this.fuel = nbt.func_74762_e("fuel");
        this.waste = nbt.func_74762_e("waste");
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "coolant");
        this.tanks[2].readFromNBT(nbt, "steam");
        this.type = ReactorFuelType.getEnum(nbt.func_74762_e("type"));
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("heat", this.coreHeat);
        nbt.func_74768_a("hullHeat", this.hullHeat);
        nbt.func_74768_a("rods", this.rods);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74768_a("waste", this.waste);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "coolant");
        nbt.func_74768_a("type", this.type.getID());
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public int getCoreHeatScaled(int i) {
        return this.coreHeat * i / 50000;
    }

    public int getHullHeatScaled(int i) {
        return this.hullHeat * i / 100000;
    }

    public int getFuelScaled(int i) {
        return this.fuel * i / this.maxFuel;
    }

    public int getWasteScaled(int i) {
        return this.waste * i / this.maxWaste;
    }

    public int getSteamScaled(int i) {
        return this.tanks[2].getFill() * i / this.tanks[2].getMaxFill();
    }

    public boolean hasCoreHeat() {
        return this.coreHeat > 0;
    }

    public boolean hasHullHeat() {
        return this.hullHeat > 0;
    }

    public boolean checkBody() {
        return this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) == ModBlocks.reactor_control;
    }

    public boolean checkSegment(int offset) {
        return this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + offset, this.field_145849_e + 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + offset, this.field_145849_e + 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + offset, this.field_145849_e - 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + offset, this.field_145849_e - 1) == ModBlocks.reactor_element && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + offset, this.field_145849_e) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + offset, this.field_145849_e) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + offset, this.field_145849_e + 1) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + offset, this.field_145849_e - 1) == ModBlocks.reactor_control && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + offset, this.field_145849_e) == ModBlocks.reactor_conductor;
    }

    private float checkHull() {
        float max = this.getSize() * 12;
        float count = 0.0f;
        for (int y = this.field_145848_d - this.depth; y <= this.field_145848_d + this.height; ++y) {
            if (this.blocksRad(this.field_145851_c - 1, y, this.field_145849_e + 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c, y, this.field_145849_e + 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c + 1, y, this.field_145849_e + 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c - 1, y, this.field_145849_e - 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c, y, this.field_145849_e - 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c + 1, y, this.field_145849_e - 2)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c + 2, y, this.field_145849_e - 1)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c + 2, y, this.field_145849_e)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c + 2, y, this.field_145849_e + 1)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c - 2, y, this.field_145849_e - 1)) {
                count += 1.0f;
            }
            if (this.blocksRad(this.field_145851_c - 2, y, this.field_145849_e)) {
                count += 1.0f;
            }
            if (!this.blocksRad(this.field_145851_c - 2, y, this.field_145849_e + 1)) continue;
            count += 1.0f;
        }
        if (count == 0.0f) {
            return 1.0f;
        }
        return 1.0f - count / max;
    }

    private boolean blocksRad(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b == ModBlocks.block_lead || b == ModBlocks.block_desh || b == ModBlocks.brick_concrete) {
            return true;
        }
        return b.func_149638_a(null) >= 100.0f;
    }

    private void caluclateSize() {
        int i;
        this.height = 0;
        this.depth = 0;
        for (i = 0; i < 7 && this.checkSegment(i + 1); ++i) {
            ++this.height;
        }
        for (i = 0; i < 7 && this.checkSegment(-i - 1); ++i) {
            ++this.depth;
        }
        this.size = this.height + this.depth + 1;
    }

    private int getSize() {
        return this.size;
    }

    private void generate() {
        int consumption = this.maxFuel / cycleDuration * this.rods / 100;
        if (consumption > this.fuel) {
            consumption = this.fuel;
        }
        if (consumption + this.waste > this.maxWaste) {
            consumption = this.maxWaste - this.waste;
        }
        this.fuel -= consumption;
        this.waste += consumption;
        int heat = consumption / this.size * this.type.heat / fuelMult;
        this.coreHeat += heat;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.checkBody()) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[2].getTankType());
            }
            this.caluclateSize();
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.size, 3));
        }
        this.tanks[0].changeTankSize(waterBase * this.getSize());
        this.tanks[1].changeTankSize(coolantBase * this.getSize());
        this.tanks[2].changeTankSize(steamBase * this.getSize());
        this.maxWaste = this.maxFuel = fuelBase * this.getSize();
        if (!this.field_145850_b.field_72995_K) {
            int absorbed;
            int cont;
            if (this.waste > this.maxWaste) {
                this.waste = this.maxWaste;
            }
            if (this.fuel > this.maxFuel) {
                this.fuel = this.maxFuel;
            }
            this.tanks[0].loadTank(0, 1, this.slots);
            this.tanks[1].loadTank(2, 3, this.slots);
            if (this.fuel == 0 && this.slots[4] != null && !TileEntityMachineReactorLarge.getFuelType(this.slots[4].func_77973_b()).toString().equals(ReactorFuelType.UNKNOWN.toString())) {
                this.type = TileEntityMachineReactorLarge.getFuelType(this.slots[4].func_77973_b());
                this.waste = 0;
            }
            if (this.slots[4] != null && TileEntityMachineReactorLarge.getFuelContent(this.slots[4].func_77973_b(), this.type) > 0 && this.fuel + (cont = TileEntityMachineReactorLarge.getFuelContent(this.slots[4].func_77973_b(), this.type) * fuelMult) <= this.maxFuel) {
                if (!this.slots[4].func_77973_b().func_77634_r()) {
                    --this.slots[4].field_77994_a;
                    this.fuel += cont;
                } else if (this.slots[5] == null) {
                    this.slots[5] = new ItemStack(this.slots[4].func_77973_b().func_77668_q());
                    --this.slots[4].field_77994_a;
                    this.fuel += cont;
                } else if (this.slots[4].func_77973_b().func_77668_q() == this.slots[5].func_77973_b() && this.slots[5].field_77994_a < this.slots[5].func_77976_d()) {
                    --this.slots[4].field_77994_a;
                    ++this.slots[5].field_77994_a;
                    this.fuel += cont;
                }
                if (this.slots[4].field_77994_a == 0) {
                    this.slots[4] = null;
                }
            }
            if (this.slots[6] != null && TileEntityMachineReactorLarge.getWasteAbsorbed(this.slots[6].func_77973_b(), this.type) > 0 && (absorbed = TileEntityMachineReactorLarge.getWasteAbsorbed(this.slots[6].func_77973_b(), this.type) * fuelMult) <= this.waste) {
                if (this.slots[7] == null) {
                    this.waste -= absorbed;
                    this.slots[7] = new ItemStack(TileEntityMachineReactorLarge.getWaste(this.slots[6].func_77973_b(), this.type));
                    --this.slots[6].field_77994_a;
                } else if (this.slots[7] != null && this.slots[7].func_77973_b() == TileEntityMachineReactorLarge.getWaste(this.slots[6].func_77973_b(), this.type) && this.slots[7].field_77994_a < this.slots[7].func_77976_d()) {
                    this.waste -= absorbed;
                    ++this.slots[7].field_77994_a;
                    --this.slots[6].field_77994_a;
                }
                if (this.slots[6].field_77994_a == 0) {
                    this.slots[6] = null;
                }
            }
            if (this.rods > 0) {
                this.generate();
            }
            if (this.coreHeat > 0 && this.tanks[1].getFill() > 0 && this.hullHeat < this.maxHullHeat) {
                this.hullHeat = (int)((double)this.hullHeat + (double)this.coreHeat * 0.175);
                this.coreHeat = (int)((double)this.coreHeat - (double)this.coreHeat * 0.1);
                this.tanks[1].setFill(this.tanks[1].getFill() - 10);
                if (this.tanks[1].getFill() < 0) {
                    this.tanks[1].setFill(0);
                }
            }
            if (this.hullHeat > 100000) {
                this.hullHeat = 100000;
            }
            if (this.hullHeat > 0 && this.tanks[0].getFill() > 0) {
                this.generateSteam();
                this.hullHeat = (int)((double)this.hullHeat - (double)this.hullHeat * 0.085);
            }
            if (this.coreHeat > 50000) {
                this.explode();
            }
            if (this.rods > 0 && this.coreHeat > 0 && this.age == 5) {
                float rad = (float)this.coreHeat / 50000.0f * 50.0f;
                RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, rad *= this.checkHull(), 200.0f);
            }
            for (int i = 0; i < 3; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == ModBlocks.reactor_ejector && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == 2) {
                this.tryEjectInto(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == ModBlocks.reactor_ejector && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == 3) {
                this.tryEjectInto(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_ejector && this.field_145850_b.func_72805_g(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == 4) {
                this.tryEjectInto(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_ejector && this.field_145850_b.func_72805_g(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == 5) {
                this.tryEjectInto(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == ModBlocks.reactor_inserter && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == 2) {
                this.tryInsertFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == ModBlocks.reactor_inserter && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == 3) {
                this.tryInsertFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_inserter && this.field_145850_b.func_72805_g(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == 4) {
                this.tryInsertFrom(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_inserter && this.field_145850_b.func_72805_g(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == 5) {
                this.tryInsertFrom(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e);
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rods, 0));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.coreHeat, 1));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.hullHeat, 2));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.fuel, 4));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.waste, 5));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.type.getID(), 6));
        }
    }

    private void tryEjectInto(int x, int y, int z) {
        int wSize;
        int n = wSize = this.type.toString().equals(ReactorFuelType.SCHRABIDIUM.toString()) ? 60 * fuelMult : 6 * fuelMult;
        if (this.waste < wSize) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            int i;
            IInventory chest = (IInventory)te;
            Item waste = ModItems.waste_uranium;
            switch (this.type) {
                case PLUTONIUM: {
                    waste = ModItems.waste_plutonium;
                    break;
                }
                case MOX: {
                    waste = ModItems.waste_mox;
                    break;
                }
                case SCHRABIDIUM: {
                    waste = ModItems.waste_schrabidium;
                    break;
                }
                case THORIUM: {
                    waste = ModItems.waste_thorium;
                    break;
                }
                default: {
                    waste = ModItems.waste_uranium;
                }
            }
            for (i = 0; i < chest.func_70302_i_(); ++i) {
                if (!chest.func_94041_b(i, new ItemStack(waste)) || chest.func_70301_a(i) == null || chest.func_70301_a(i).func_77973_b() != waste || chest.func_70301_a((int)i).field_77994_a >= chest.func_70301_a(i).func_77976_d()) continue;
                chest.func_70299_a(i, new ItemStack(waste, chest.func_70301_a((int)i).field_77994_a + 1));
                this.waste -= wSize;
                return;
            }
            for (i = 0; i < chest.func_70302_i_(); ++i) {
                if (!chest.func_94041_b(i, new ItemStack(waste)) || chest.func_70301_a(i) != null) continue;
                chest.func_70299_a(i, new ItemStack(waste));
                this.waste -= wSize;
                return;
            }
        }
    }

    private void tryInsertFrom(int x, int y, int z) {
        block4: {
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (!(te instanceof IInventory)) break block4;
            IInventory chest = (IInventory)te;
            if (this.fuel > 0) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    int cont;
                    if (chest.func_70301_a(i) == null || (cont = TileEntityMachineReactorLarge.getFuelContent(chest.func_70301_a(i).func_77973_b(), this.type) * fuelMult) <= 0 || this.fuel + cont > this.maxFuel) continue;
                    Item container = chest.func_70301_a(i).func_77973_b().func_77668_q();
                    chest.func_70298_a(i, 1);
                    this.fuel += cont;
                    if (chest.func_70301_a(i) != null || container == null) continue;
                    chest.func_70299_a(i, new ItemStack(container));
                }
            } else {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    int cont;
                    if (chest.func_70301_a(i) == null || (cont = TileEntityMachineReactorLarge.getFuelContent(chest.func_70301_a(i).func_77973_b(), TileEntityMachineReactorLarge.getFuelType(chest.func_70301_a(i).func_77973_b())) * fuelMult) <= 0 || this.fuel + cont > this.maxFuel) continue;
                    Item container = chest.func_70301_a(i).func_77973_b().func_77668_q();
                    this.type = TileEntityMachineReactorLarge.getFuelType(chest.func_70301_a(i).func_77973_b());
                    chest.func_70298_a(i, 1);
                    this.fuel += cont;
                    if (chest.func_70301_a(i) != null || container == null) continue;
                    chest.func_70299_a(i, new ItemStack(container));
                }
            }
        }
    }

    private void generateSteam() {
        double steam;
        double statSteMaFiFiLe = 8000.0;
        double water = steam = (double)this.hullHeat / 100000.0 * (statSteMaFiFiLe / 50.0) * (double)this.size;
        switch (this.tanks[2].getTankType()) {
            case STEAM: {
                water /= 100.0;
                break;
            }
            case HOTSTEAM: {
                water /= 10.0;
                break;
            }
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - (int)Math.ceil(water));
        this.tanks[2].setFill(this.tanks[2].getFill() + (int)Math.floor(steam));
        if (this.tanks[0].getFill() < 0) {
            this.tanks[0].setFill(0);
        }
        if (this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
            this.tanks[2].setFill(this.tanks[2].getMaxFill());
        }
    }

    private void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
        int rad = (int)((long)this.fuel * 25000L / ((long)fuelBase * 15L));
        RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, rad, 75000.0f);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 7.5f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
        for (int i = this.field_145848_d - this.depth; i <= this.field_145848_d + this.height; ++i) {
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_145851_c + 1, i, this.field_145849_e + 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_145851_c + 1, i, this.field_145849_e - 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_145851_c - 1, i, this.field_145849_e - 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_145851_c - 1, i, this.field_145849_e + 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(5) != 0) continue;
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0f, true);
        }
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.sellafield_core);
    }

    private void randomizeRadBlock(int x, int y, int z) {
        int rand = this.field_145850_b.field_73012_v.nextInt(20);
        if (rand < 7) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.toxic_block);
        } else if (rand < 10) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.sellafield_0);
        } else if (rand < 14) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.sellafield_1);
        } else if (rand < 17) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.sellafield_2);
        } else if (rand < 19) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.sellafield_3);
        } else {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.sellafield_4);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        if (this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_hatch) {
            this.fillFluid(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == ModBlocks.reactor_hatch) {
            this.fillFluid(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == ModBlocks.reactor_hatch) {
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3, this.getTact(), type);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == ModBlocks.reactor_hatch) {
            this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3, this.getTact(), type);
        }
        this.fillFluid(this.field_145851_c, this.field_145848_d + this.height + 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - this.depth - 1, this.field_145849_e + 3, this.getTact(), type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    public static void registerFuelEntry(int nuggets, ReactorFuelType type, Item fuel) {
        fuels.add(new ReactorFuelEntry(nuggets, type, fuel));
    }

    public static void registerWasteEntry(int nuggets, ReactorFuelType type, Item in, Item out) {
        wastes.add(new ReactorWasteEntry(nuggets, type, in, out));
    }

    public static int getFuelContent(Item item, ReactorFuelType type) {
        for (ReactorFuelEntry ent : fuels) {
            if (ent.item != item || !type.toString().equals(ent.type.toString())) continue;
            return ent.value;
        }
        return 0;
    }

    public static ReactorFuelType getFuelType(Item item) {
        for (ReactorFuelEntry ent : fuels) {
            if (ent.item != item) continue;
            return ent.type;
        }
        return ReactorFuelType.UNKNOWN;
    }

    public static Item getWaste(Item item, ReactorFuelType type) {
        for (ReactorWasteEntry ent : wastes) {
            if (ent.in != item || !type.toString().equals(ent.type.toString())) continue;
            return ent.out;
        }
        return null;
    }

    public static int getWasteAbsorbed(Item item, ReactorFuelType type) {
        for (ReactorWasteEntry ent : wastes) {
            if (ent.in != item || !type.toString().equals(ent.type.toString())) continue;
            return ent.value;
        }
        return 0;
    }

    static class ReactorWasteEntry {
        int value;
        ReactorFuelType type;
        Item in;
        Item out;

        public ReactorWasteEntry(int value, ReactorFuelType type, Item in, Item out) {
            this.value = value;
            this.type = type;
            this.in = in;
            this.out = out;
        }
    }

    static class ReactorFuelEntry {
        int value;
        ReactorFuelType type;
        Item item;

        public ReactorFuelEntry(int value, ReactorFuelType type, Item item) {
            this.value = value;
            this.type = type;
            this.item = item;
        }
    }

    public static enum ReactorFuelType {
        URANIUM(250000),
        THORIUM(200000),
        PLUTONIUM(312500),
        MOX(250000),
        SCHRABIDIUM(2085000),
        UNKNOWN(1);

        private int heat;

        private ReactorFuelType(int i) {
            this.heat = i;
        }

        public int getHeat() {
            return this.heat;
        }

        public int getID() {
            return Arrays.asList(ReactorFuelType.values()).indexOf((Object)this);
        }

        public static ReactorFuelType getEnum(int i) {
            if (i < ReactorFuelType.values().length) {
                return ReactorFuelType.values()[i];
            }
            return URANIUM;
        }
    }
}

