/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBattery;
import com.hbm.items.special.ItemFuelRod;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineReactorSmallOld
extends TileEntity
implements ISidedInventory,
ISource,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots;
    public int hullHeat;
    public final int maxHullHeat = 100000;
    public int coreHeat;
    public final int maxCoreHeat = 50000;
    public long power;
    public final long powerMax = 250000L;
    public int rods;
    public final int rodsMax = 100;
    public boolean retracting = true;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{16};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 16};
    private static final int[] slots_side = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16};
    private String customName;

    public TileEntityMachineReactorSmallOld() {
        this.slots = new ItemStack[17];
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 32000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 16000, 1);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.reactorSmall";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if ((i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11) && itemStack.func_77973_b() instanceof ItemFuelRod) {
            return true;
        }
        if (i == 12 && (itemStack.func_77973_b() == ModItems.rod_water || itemStack.func_77973_b() == ModItems.rod_dual_water || itemStack.func_77973_b() == ModItems.rod_quad_water || itemStack.func_77973_b() == Items.field_151131_as)) {
            return true;
        }
        if (i == 14 && (itemStack.func_77973_b() == ModItems.rod_coolant || itemStack.func_77973_b() == ModItems.rod_dual_coolant || itemStack.func_77973_b() == ModItems.rod_quad_coolant)) {
            return true;
        }
        return i == 16 && itemStack.func_77973_b() instanceof ItemBattery;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.coreHeat = nbt.func_74762_e("heat");
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "coolant");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("heat", this.coreHeat);
        nbt.func_74768_a("hullHeat", this.hullHeat);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "coolant");
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (!(i != 0 && i != 1 && i != 2 && i != 3 && i != 4 && i != 5 && i != 6 && i != 7 && i != 8 && i != 9 && i != 10 && i != 11 || itemStack.func_77973_b() != ModItems.rod_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_schrabidium_fuel_depleted)) {
            return true;
        }
        if (!(i != 13 && i != 15 || itemStack.func_77973_b() != Items.field_151133_ar && itemStack.func_77973_b() != ModItems.rod_empty && itemStack.func_77973_b() != ModItems.rod_dual_empty && itemStack.func_77973_b() != ModItems.rod_quad_empty && itemStack.func_77973_b() != ModItems.fluid_tank_empty && itemStack.func_77973_b() != ModItems.fluid_barrel_empty)) {
            return true;
        }
        return i == 16 && itemStack.func_77973_b() instanceof ItemBattery && ItemBattery.getCharge(itemStack) == ItemBattery.getMaxChargeStatic(itemStack);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 250000L;
    }

    public int getCoreHeatScaled(int i) {
        return this.coreHeat * i / 50000;
    }

    public int getHullHeatScaled(int i) {
        return this.hullHeat * i / 100000;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean hasCoreHeat() {
        return this.coreHeat > 0;
    }

    public boolean hasHullHeat() {
        return this.hullHeat > 0;
    }

    private int[] getNeighbouringSlots(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 5};
            }
            case 1: {
                return new int[]{0, 6};
            }
            case 2: {
                return new int[]{3, 7};
            }
            case 3: {
                return new int[]{2, 4, 8};
            }
            case 4: {
                return new int[]{3, 9};
            }
            case 5: {
                return new int[]{0, 6, 10};
            }
            case 6: {
                return new int[]{1, 5, 11};
            }
            case 7: {
                return new int[]{2, 8};
            }
            case 8: {
                return new int[]{3, 7, 9};
            }
            case 9: {
                return new int[]{4, 8};
            }
            case 10: {
                return new int[]{5, 11};
            }
            case 11: {
                return new int[]{6, 10};
            }
        }
        return null;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            if (this.tanks[0].getFill() < this.tanks[0].getMaxFill()) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150358_i) {
                    this.tanks[0].setFill(this.tanks[0].getFill() + 25);
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150358_i) {
                    this.tanks[0].setFill(this.tanks[0].getFill() + 25);
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) == Blocks.field_150358_i) {
                    this.tanks[0].setFill(this.tanks[0].getFill() + 25);
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1) == Blocks.field_150358_i) {
                    this.tanks[0].setFill(this.tanks[0].getFill() + 25);
                }
                if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
                    this.tanks[0].setFill(this.tanks[0].getMaxFill());
                }
            }
            this.tanks[0].loadTank(12, 13, this.slots);
            this.tanks[1].loadTank(14, 15, this.slots);
            if (this.retracting && this.rods > 0) {
                if (this.rods == 100) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStart", 1.0f, 0.75f);
                }
                --this.rods;
                if (this.rods == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStop", 1.0f, 1.0f);
                }
            }
            if (!this.retracting && this.rods < 100) {
                if (this.rods == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStart", 1.0f, 0.75f);
                }
                ++this.rods;
                if (this.rods == 100) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStop", 1.0f, 1.0f);
                }
            }
            for (i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.power = Library.chargeItemsFromTE(this.slots, 11, this.power, 250000L);
            if (this.rods >= 100) {
                for (i = 0; i < 12; ++i) {
                    if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemFuelRod)) continue;
                    this.decay(i);
                }
            }
            if (this.coreHeat > 0 && this.tanks[1].getFill() > 0 && this.hullHeat < this.maxHullHeat) {
                this.hullHeat = (int)((double)this.hullHeat + (double)this.coreHeat * 0.175);
                this.coreHeat = (int)((double)this.coreHeat - (double)this.coreHeat * 0.1);
                this.tanks[1].setFill(this.tanks[1].getFill() - 10);
                if (this.tanks[1].getFill() < 0) {
                    this.tanks[1].setFill(0);
                }
            }
            if (this.hullHeat > 100000) {
                this.hullHeat = 100000;
            }
            if (this.hullHeat > 0 && this.tanks[0].getFill() > 0) {
                this.power = (long)((double)this.power + (double)this.hullHeat * 0.1);
                this.hullHeat = (int)((double)this.hullHeat - (double)this.hullHeat * 0.085);
                this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                if (this.tanks[0].getFill() < 0) {
                    this.tanks[0].setFill(0);
                }
            }
            if (this.power > 250000L) {
                this.power = 250000L;
            }
            if (this.coreHeat > 50000) {
                this.explode();
            }
            if (!(this.rods <= 0 || this.coreHeat <= 0 || this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e).func_149721_r() && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e).func_149721_r() && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1).func_149721_r() && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1).func_149721_r() && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) != Blocks.field_150350_a && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) != Blocks.field_150350_a && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) != Blocks.field_150350_a && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1) != Blocks.field_150350_a)) {
                List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 5.0), (double)((double)this.field_145848_d + 1.5 - 5.0), (double)((double)this.field_145849_e + 0.5 - 5.0), (double)((double)this.field_145851_c + 0.5 + 5.0), (double)((double)this.field_145848_d + 1.5 + 5.0), (double)((double)this.field_145849_e + 0.5 + 5.0)));
                float rad = (float)this.coreHeat / 50000.0f * 50.0f;
                RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, rad, rad * 4.0f);
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rods, 0));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.retracting ? 1 : 0, 1));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.coreHeat, 2));
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.hullHeat, 3));
        }
    }

    private boolean hasFuelRod(int id) {
        if (id > 11) {
            return false;
        }
        if (this.slots[id] != null) {
            return this.slots[id].func_77973_b() instanceof ItemFuelRod;
        }
        return false;
    }

    private int getNeightbourCount(int id) {
        int[] neighbours = this.getNeighbouringSlots(id);
        if (neighbours == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < neighbours.length; ++i) {
            if (!this.hasFuelRod(neighbours[i])) continue;
            ++count;
        }
        return count;
    }

    private void decay(int id) {
        if (id > 11) {
            return;
        }
        int decay = this.getNeightbourCount(id) + 1;
        for (int i = 0; i < decay; ++i) {
            ItemFuelRod rod = (ItemFuelRod)this.slots[id].func_77973_b();
            this.coreHeat += rod.heat;
            ItemFuelRod.setLifeTime(this.slots[id], ItemFuelRod.getLifeTime(this.slots[id]) + 1);
            ItemFuelRod.updateDamage(this.slots[id]);
            if (ItemFuelRod.getLifeTime(this.slots[id]) <= ((ItemFuelRod)this.slots[id].func_77973_b()).lifeTime) continue;
            this.onRunOut(id);
            return;
        }
    }

    private void onRunOut(int id) {
        System.out.println("aaa");
        Item item = this.slots[id].func_77973_b();
        if (item == ModItems.rod_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_uranium_fuel_depleted);
        } else if (item == ModItems.rod_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_mox_fuel_depleted);
        } else if (item == ModItems.rod_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_schrabidium_fuel_depleted);
        } else if (item == ModItems.rod_dual_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_uranium_fuel_depleted);
        } else if (item == ModItems.rod_dual_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_dual_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_mox_fuel_depleted);
        } else if (item == ModItems.rod_dual_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_schrabidium_fuel_depleted);
        } else if (item == ModItems.rod_quad_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_uranium_fuel_depleted);
        } else if (item == ModItems.rod_quad_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_quad_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_mox_fuel_depleted);
        } else if (item == ModItems.rod_quad_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_schrabidium_fuel_depleted);
        }
    }

    private void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 18.0f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k);
        RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
        RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, 1000.0f, 2000.0f);
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

