/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.special.ItemBattery;
import com.hbm.items.special.ItemBlades;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineShredder
extends TileEntity
implements ISidedInventory,
IConsumer {
    private ItemStack[] slots = new ItemStack[30];
    public long power;
    public int progress;
    public int soundCycle = 0;
    public static final long maxPower = 10000L;
    public static final int processingSpeed = 60;
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] slots_bottom = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] slots_side = new int[]{27, 28, 29};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineShredder";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            return true;
        }
        return i == 2 && (stack.func_77973_b() instanceof ItemBattery || stack.func_77973_b() instanceof ItemBlades);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i >= 9 && i <= 26) {
            return true;
        }
        return i >= 27 && i <= 29 && itemStack.func_77960_j() == itemStack.func_77958_k();
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 60;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public void func_145845_h() {
        boolean flag = this.hasPower();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                this.power -= 5L;
                this.slots[27].func_77964_b(this.slots[27].func_77960_j() + 1);
                this.slots[28].func_77964_b(this.slots[28].func_77960_j() + 1);
                if (this.progress == 60) {
                    this.progress = 0;
                    this.processItem();
                    flag1 = true;
                }
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "minecart.base", 1.0f, 0.75f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 50) {
                    this.soundCycle = 0;
                }
            } else {
                this.progress = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.progress == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
            }
        }
        this.power = Library.chargeTEFromItems(this.slots, 29, this.power, 10000L);
        PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void processItem() {
        for (int i = 0; i < 9; ++i) {
            int j;
            if (this.slots[i] == null || !this.hasSpace(this.slots[i])) continue;
            ItemStack inp = this.slots[i].func_77946_l();
            ItemStack outp = MachineRecipes.getShredderResult(inp);
            boolean flag = false;
            for (j = 9; j < 27; ++j) {
                if (this.slots[j] == null || !this.slots[j].func_77973_b().equals(outp.func_77973_b()) || this.slots[j].field_77994_a + outp.field_77994_a > outp.func_77976_d()) continue;
                this.slots[j].field_77994_a += outp.field_77994_a;
                --this.slots[i].field_77994_a;
                flag = true;
                break;
            }
            if (!flag) {
                for (j = 9; j < 27; ++j) {
                    if (this.slots[j] != null) continue;
                    this.slots[j] = outp.func_77946_l();
                    --this.slots[i].field_77994_a;
                    break;
                }
            }
            if (this.slots[i].field_77994_a > 0) continue;
            this.slots[i] = null;
        }
    }

    public boolean canProcess() {
        if (this.slots[27] != null && this.slots[28] != null && this.slots[27].func_77973_b() instanceof ItemBlades && this.slots[28].func_77973_b() instanceof ItemBlades && this.slots[27].func_77960_j() < this.slots[27].func_77958_k() && this.slots[28].func_77960_j() < this.slots[28].func_77958_k()) {
            for (int i = 0; i < 9; ++i) {
                if (this.slots[i] == null || this.slots[i].field_77994_a <= 0 || !this.hasSpace(this.slots[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpace(ItemStack stack) {
        ItemStack result = MachineRecipes.getShredderResult(stack);
        if (result != null) {
            for (int i = 9; i < 27; ++i) {
                if (this.slots[i] == null) {
                    return true;
                }
                if (this.slots[i] == null || !this.slots[i].func_77973_b().equals(result.func_77973_b()) || this.slots[i].field_77994_a + result.field_77994_a > result.func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000L;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    public int getGearLeft() {
        if (this.slots[27] != null && this.slots[27].func_77973_b() instanceof ItemBlades) {
            if (this.slots[27].func_77960_j() < this.slots[27].func_77973_b().func_77612_l() / 2) {
                return 1;
            }
            if (this.slots[27].func_77960_j() != this.slots[27].func_77973_b().func_77612_l()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public int getGearRight() {
        if (this.slots[28] != null && this.slots[28].func_77973_b() instanceof ItemBlades) {
            if (this.slots[28].func_77960_j() < this.slots[28].func_77973_b().func_77612_l() / 2) {
                return 1;
            }
            if (this.slots[28].func_77960_j() != this.slots[28].func_77973_b().func_77612_l()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }
}

