/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.special.ItemBattery;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineTurbine
extends TileEntity
implements ISidedInventory,
IFluidContainer,
IFluidAcceptor,
IFluidSource,
ISource {
    private ItemStack[] slots;
    public long power;
    public static final long maxPower = 1000000L;
    public int age = 0;
    public List<IConsumer> list1 = new ArrayList<IConsumer>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{4};
    private static final int[] slots_bottom = new int[]{6};
    private static final int[] slots_side = new int[]{4};
    private String customName;

    public TileEntityMachineTurbine() {
        this.slots = new ItemStack[7];
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.STEAM, 64000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.WATER, 128000, 1);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineTurbine";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 4 && stack != null && stack.func_77973_b() instanceof ItemBattery;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    public void func_145845_h() {
        boolean mark = false;
        if (!this.field_145850_b.field_72995_K) {
            int i;
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            this.fillFluidInit(this.tanks[1].getTankType());
            this.ffgeuaInit();
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[0].loadTank(2, 3, this.slots);
            Object[] outs = MachineRecipes.getTurbineOutput(this.tanks[0].getTankType());
            if (outs == null) {
                this.tanks[1].setTankType(FluidTypeHandler.FluidType.NONE);
            } else {
                this.tanks[1].setTankType((FluidTypeHandler.FluidType)((Object)outs[0]));
                for (i = 0; i < 1200 && this.tanks[0].getFill() >= (Integer)outs[2] && this.tanks[1].getFill() + (Integer)outs[1] <= this.tanks[1].getMaxFill(); ++i) {
                    this.tanks[0].setFill(this.tanks[0].getFill() - (Integer)outs[2]);
                    this.tanks[1].setFill(this.tanks[1].getFill() + (Integer)outs[1]);
                    this.power += (long)((Integer)outs[3]).intValue();
                    if (this.power <= 1000000L) continue;
                    this.power = 1000000L;
                }
            }
            this.tanks[1].unloadTank(5, 6, this.slots);
            for (i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power));
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age == 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list2.clear();
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list1;
    }

    @Override
    public void clearList() {
        this.list1.clear();
    }
}

