/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.item;

import com.bartz24.skyresources.alchemy.effects.IHealthBoostItem;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemHealthGem
extends Item
implements IHealthBoostItem {
    private final int maxHealth;

    public ItemHealthGem() {
        this.maxHealth = ConfigOptions.toolSettings.healthGemMaxHealth;
        this.func_77655_b("skyresources.itemHealthGem");
        this.setRegistryName("ItemHealthGem");
        this.func_77627_a(true);
        this.func_77637_a(ModCreativeTabs.tabAlchemy);
        this.func_77625_d(1);
    }

    @Override
    public int getHealthBoost(ItemStack stack) {
        return (int)((double)this.getCompound(stack).func_74762_e("health") * ConfigOptions.toolSettings.healthGemPercentage);
    }

    public int getHealthInjected(ItemStack stack) {
        return this.getCompound(stack).func_74762_e("health");
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
        itemStack.func_77978_p().func_74768_a("health", 0);
        itemStack.func_77978_p().func_74768_a("cooldown", 0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        super.func_77659_a(world, player, hand);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (this.getCompound(stack) != null) {
                if (stack.func_77978_p().func_74762_e("health") + 2 <= this.maxHealth && stack.func_77978_p().func_74762_e("cooldown") == 0) {
                    player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                    stack.func_77978_p().func_74768_a("health", stack.func_77978_p().func_74762_e("health") + 2);
                    stack.func_77978_p().func_74768_a("cooldown", 20);
                }
            } else {
                this.func_77622_d(stack, world, player);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(TextFormatting.GREEN + "Shift-right click to inject health.");
            if (stack.func_77978_p() != null) {
                tooltip.add(TextFormatting.RED + "Health Injected: " + stack.func_77978_p().func_74762_e("health"));
            } else {
                tooltip.add("Health Injected: 0");
            }
            tooltip.add(TextFormatting.DARK_RED + "Health Gained: " + this.getHealthBoost(stack));
        } else {
            tooltip.add(TextFormatting.GREEN + "Hold LSHIFT for info.");
        }
    }

    public NBTTagCompound getCompound(ItemStack stack) {
        NBTTagCompound com = stack.func_77978_p();
        if (com == null) {
            this.func_77622_d(stack, null, null);
        }
        com = stack.func_77978_p();
        return com;
    }
}

