/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base;

import com.bartz24.skyresources.base.IHeatSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatSources {
    static HashMap<IBlockState, Integer> validHeatSources;
    private static List<IBlockState> ctRemoved;
    private static HashMap<IBlockState, Integer> ctAdded;

    public HeatSources() {
        validHeatSources = new HashMap();
        ctAdded = new HashMap();
        ctRemoved = new ArrayList<IBlockState>();
    }

    public static void addHeatSource(IBlockState blockState, int value) {
        validHeatSources.put(blockState, value);
    }

    public static boolean isValidHeatSource(BlockPos pos, World world) {
        if (!validHeatSources.containsKey(world.func_180495_p(pos))) {
            Iterator<IBlockState> iterator = validHeatSources.keySet().iterator();
            while (iterator.hasNext()) {
                IBlockState key;
                IBlockState block = key = iterator.next();
                int val = validHeatSources.get(key);
                if (block.func_177230_c() != world.func_180495_p(pos).func_177230_c()) continue;
                return true;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof IHeatSource) {
                return HeatSources.getHeatSourceValue(pos, world) > 0;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean isValidHeatSource(IBlockState state) {
        if (!validHeatSources.containsKey(state)) {
            Iterator<IBlockState> iterator = validHeatSources.keySet().iterator();
            while (iterator.hasNext()) {
                IBlockState key;
                IBlockState block = key = iterator.next();
                int val = validHeatSources.get(key);
                if (block.func_177230_c() != state.func_177230_c()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static int getHeatSourceValue(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        if (validHeatSources.containsKey(state)) {
            return validHeatSources.get(state);
        }
        Iterator<IBlockState> iterator = validHeatSources.keySet().iterator();
        while (iterator.hasNext()) {
            IBlockState key;
            IBlockState block = key = iterator.next();
            int val = validHeatSources.get(key);
            if (block.func_177230_c() != state.func_177230_c()) continue;
            return val;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)tile;
            return source.getHeatValue();
        }
        return 0;
    }

    public static int getHeatSourceValue(IBlockState state) {
        if (!HeatSources.isValidHeatSource(state)) {
            return 0;
        }
        if (validHeatSources.containsKey(state)) {
            return validHeatSources.get(state);
        }
        Iterator<IBlockState> iterator = validHeatSources.keySet().iterator();
        while (iterator.hasNext()) {
            IBlockState key;
            IBlockState block = key = iterator.next();
            int val = validHeatSources.get(key);
            if (block.func_177230_c() != state.func_177230_c()) continue;
            return val;
        }
        return 0;
    }

    public static void removeCTHeatSource(IBlockState blockState) {
        ctRemoved.add(blockState);
    }

    public static void addCTHeatSource(IBlockState blockState, int value) {
        ctAdded.put(blockState, value);
    }

    public static void ctRecipes() {
        for (IBlockState s : ctRemoved) {
            HeatSources.removeHeatSource(s);
        }
        for (IBlockState s : ctAdded.keySet()) {
            HeatSources.addHeatSource(s, ctAdded.get(s));
        }
    }

    public static void removeHeatSource(IBlockState blockState) {
        validHeatSources.remove(blockState);
    }

    public static HashMap<IBlockState, Integer> getHeatSources() {
        return validHeatSources;
    }
}

