/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.block;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.SkyResources;
import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.block.IMetaBlockName;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCasing
extends BlockContainer
implements IMetaBlockName {
    public static final PropertyEnum<MachineVariants> variant = PropertyEnum.func_177709_a((String)"variant", MachineVariants.class);

    public BlockCasing(String unlocalizedName, String registryName, float hardness, float resistance) {
        super(Material.field_151576_e);
        this.func_149663_c("skyresources." + unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabMain);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setRegistryName(registryName);
        this.field_149758_A = true;
    }

    public Material func_149688_o(IBlockState state) {
        return this.func_176201_c(state) == 0 ? Material.field_151575_d : Material.field_151576_e;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCasing();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{variant});
    }

    public int func_176201_c(IBlockState state) {
        return ((MachineVariants)((Object)state.func_177229_b(variant))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= MachineVariants.values().length || meta < 0) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(variant, (Comparable)((Object)MachineVariants.values()[meta]));
    }

    public void func_149666_a(CreativeTabs par2, NonNullList<ItemStack> par3) {
        for (int i = 0; i < MachineVariants.values().length; ++i) {
            par3.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return MachineVariants.values()[stack.func_77960_j()].func_176610_l();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public MachineVariants getVariant(ItemStack stack) {
        return MachineVariants.values()[stack.func_77960_j()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GREEN + "Efficiency: " + (int)(Math.ceil(this.getVariant(stack).getRawEfficiency() * 10.0f) * 10.0) + "%");
        tooltip.add(TextFormatting.RED + "Max HU: " + this.getVariant(stack).getMaxHeat());
        if ((double)this.getVariant(stack).getRawSpeed() >= 2.0) {
            tooltip.add(TextFormatting.DARK_RED + "MUFFLER");
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (((TileCasing)world.func_175625_s((BlockPos)pos)).machineStored.func_190926_b()) {
                if (player.func_184586_b(hand).func_77973_b() instanceof ItemMachine) {
                    ItemStack machine = player.func_184586_b(hand).func_77946_l();
                    machine.func_190920_e(1);
                    ((TileCasing)world.func_175625_s(pos)).setMachine(machine, player);
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
            if (player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
                RandomHelper.spawnItemInWorld(world, ((TileCasing)world.func_175625_s((BlockPos)pos)).machineStored, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                ((TileCasing)world.func_175625_s(pos)).setMachine(ItemStack.field_190927_a, player);
            } else {
                player.openGui((Object)SkyResources.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileCasing te = (TileCasing)world.func_175625_s(pos);
        te.dropInventory();
        super.func_180663_b(world, pos, state);
    }
}

