/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.gui;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class ItemHandlerSpecial
extends ItemStackHandler {
    private int stackLimit = 64;
    protected int[] slotsNoInsert;
    protected int[] slotsNoExtract;

    public ItemHandlerSpecial(int size) {
        super(size);
        this.slotsNoExtract = new int[0];
        this.slotsNoInsert = new int[0];
    }

    public void setSlotLimit(int amount) {
        this.stackLimit = Math.min(64, amount);
    }

    public int getSlotLimit(int slot) {
        return this.stackLimit;
    }

    public ItemHandlerSpecial(int size, int[] noInsert, int[] noExtract) {
        super(size);
        this.slotsNoExtract = noExtract == null ? new int[]{} : noExtract;
        this.slotsNoInsert = noInsert == null ? new int[]{} : noInsert;
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (ArrayUtils.contains((int[])this.slotsNoInsert, (int)slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (ArrayUtils.contains((int[])this.slotsNoExtract, (int)slot)) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack insertInternalItem(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack containerExtractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public NBTTagCompound serializeNBT() {
        int i;
        NBTTagCompound nbt = super.serializeNBT();
        NBTTagList nbtTagList = new NBTTagList();
        for (i = 0; i < this.slotsNoInsert.length; ++i) {
            nbtTagList.func_74742_a((NBTBase)new NBTTagInt(this.slotsNoInsert[i]));
        }
        nbt.func_74768_a("noInsertSize", this.slotsNoInsert.length);
        nbt.func_74782_a("noInsert", (NBTBase)nbtTagList);
        nbtTagList = new NBTTagList();
        for (i = 0; i < this.slotsNoExtract.length; ++i) {
            nbtTagList.func_74742_a((NBTBase)new NBTTagInt(this.slotsNoExtract[i]));
        }
        nbt.func_74768_a("noExtractSize", this.slotsNoExtract.length);
        nbt.func_74782_a("noExtract", (NBTBase)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        super.deserializeNBT(nbt);
        this.slotsNoInsert = new int[nbt.func_74762_e("noInsertSize")];
        NBTTagList tagList = nbt.func_150295_c("noInsert", 3);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            this.slotsNoInsert[i] = tagList.func_186858_c(i);
        }
        this.slotsNoExtract = new int[nbt.func_74762_e("noExtractSize")];
        tagList = nbt.func_150295_c("noExtract", 3);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            this.slotsNoExtract[i] = tagList.func_186858_c(i);
        }
    }
}

