/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.guide;

import com.bartz24.skyresources.base.guide.GuidePage;
import com.bartz24.skyresources.base.guide.GuidePageButton;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.item.ItemStack;

public class SkyResourcesGuide {
    private static List<GuidePage> guidePages;
    private static List<GuidePageButton> blankButtonTypes;

    public SkyResourcesGuide() {
        guidePages = new ArrayList<GuidePage>();
        blankButtonTypes = new ArrayList<GuidePageButton>();
    }

    public static List<String> getCategories() {
        ArrayList<String> cats = new ArrayList<String>();
        for (GuidePage p : guidePages) {
            if (cats.contains(p.pageCategory)) continue;
            cats.add(p.pageCategory);
        }
        return cats;
    }

    public static GuidePage getPage(String id) {
        for (GuidePage p : guidePages) {
            if (!p.pageId.equals(id)) continue;
            return p;
        }
        return null;
    }

    public static List<GuidePage> getPages(String category, String filter) {
        if (Strings.isNullOrEmpty((String)category) && Strings.isNullOrEmpty((String)filter.trim())) {
            return guidePages;
        }
        ArrayList<GuidePage> pages = new ArrayList<GuidePage>();
        for (GuidePage p : guidePages) {
            if (category != null && !p.pageCategory.equals(category) || !Strings.isNullOrEmpty((String)filter.trim()) && !p.pageDisplay.toLowerCase().contains(filter.trim().toLowerCase())) continue;
            pages.add(p);
        }
        return pages;
    }

    public static List<GuidePage> getPages(String category) {
        if (Strings.isNullOrEmpty((String)category)) {
            return guidePages;
        }
        ArrayList<GuidePage> pages = new ArrayList<GuidePage>();
        for (GuidePage p : guidePages) {
            if (!p.pageCategory.equals(category)) continue;
            pages.add(p);
        }
        return pages;
    }

    public static void addPage(String id, String category, ItemStack displayStack) {
        String base = category + "." + id;
        guidePages.add(new GuidePage(id, category, base + ".title", displayStack, base + ".text"));
    }

    public static void addPage(String id, String category, ItemStack displayStack, String info) {
        String base = category + "." + id;
        guidePages.add(new GuidePage(id, category, base + ".title", displayStack, info));
    }

    public static void addButtonType(GuidePageButton button) {
        for (GuidePageButton b : blankButtonTypes) {
            if (b.getClass() != button.getClass()) continue;
            return;
        }
        blankButtonTypes.add(button);
    }

    public static GuidePageButton getBlankButton(String buttonType) {
        for (GuidePageButton b : blankButtonTypes) {
            if (!b.getIdentifier().equals(buttonType)) continue;
            return b.clone();
        }
        return null;
    }
}

