/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.guide.gui;

import com.bartz24.skyresources.base.guide.GuideImage;
import com.bartz24.skyresources.base.guide.GuideImageButton;
import com.bartz24.skyresources.base.guide.GuideLinkPageButton;
import com.bartz24.skyresources.base.guide.GuidePage;
import com.bartz24.skyresources.base.guide.GuidePageButton;
import com.bartz24.skyresources.base.guide.GuideRecipeButton;
import com.bartz24.skyresources.base.guide.SkyResourcesGuide;
import com.bartz24.skyresources.base.guide.gui.GuiPageButton;
import com.bartz24.skyresources.config.ConfigOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Mouse;

public class GuideGUI
extends GuiScreen {
    public static String lastGuidePage;
    public static String lastGuideCat;
    public static String lastGuideSearch;
    GuiButton closeButton;
    GuiButton cycleCatLeftButton;
    GuiButton cycleCatRightButton;
    GuiButton backButton;
    List<GuiPageButton> linkButtons;
    List<GuiButton> infoButtons;
    String currentCategory;
    GuideImage currentImage;
    GuidePage currentPage;
    List<List<Object>> currentPageInfo;
    GuiTextField searchBox;
    List<String> pageHistory;
    int fontType = 0;
    int curIndex = 0;
    PageList pageScroll;
    PageInfo pageInfo;

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.currentImage == null) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            ItemStack stack = this.currentPage.pageItemDisplay;
            int x = Math.max(this.field_146294_l / 2 - 100, 275);
            if (stack != null) {
                this.drawItem(stack, x, 22);
            }
            this.field_146289_q.func_78276_b(I18n.func_74838_a((String)this.currentPage.pageDisplay), x + 20, 26, 0xFFFFFF);
            String catDisplay = Strings.isNullOrEmpty((String)this.currentCategory) ? "All" : I18n.func_74838_a((String)this.currentCategory);
            this.field_146289_q.func_78276_b(catDisplay, 60 - this.field_146289_q.func_78256_a(catDisplay) / 2, 18, 0xFFFFFF);
            this.field_146289_q.func_78276_b("Category", 60 - this.field_146289_q.func_78256_a("Category") / 2, 6, 0xFFFFFF);
            this.searchBox.func_146194_f();
            this.pageScroll.drawScreen(mouseX, mouseY, partialTicks);
            this.pageInfo.drawScreen(mouseX, mouseY, partialTicks);
        } else {
            this.closeButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.currentImage.draw(this.field_146297_k, this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 256, 256, partialTicks);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    public void openPage(GuidePage page) {
        if (page != null) {
            if (this.pageHistory.size() == 0 || !this.pageHistory.get(this.pageHistory.size() - 1).equals(this.currentPage.pageId)) {
                this.pageHistory.add(this.currentPage.pageId);
            }
            this.currentPage = page;
            this.curIndex = this.getPageIndex(this.currentPage);
            this.func_73866_w_();
        }
    }

    public void closeImage() {
        this.currentImage = null;
        for (GuiButton b : this.field_146292_n) {
            b.field_146124_l = true;
        }
    }

    public void openImage(GuideImage image) {
        this.currentImage = image;
        for (GuiButton b : this.field_146292_n) {
            if (b == this.closeButton) continue;
            b.field_146124_l = false;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (ConfigOptions.guideSettings.rememberGuide) {
            lastGuideCat = this.currentCategory;
            lastGuidePage = this.currentPage.pageId;
            lastGuideSearch = this.searchBox.func_146179_b();
        }
    }

    public void func_73866_w_() {
        new GuideRecipeButton(new ItemStack(Blocks.field_150346_d));
        new GuideLinkPageButton(null, null, null);
        new GuideImageButton("", null, null);
        if (this.currentPage == null) {
            if (ConfigOptions.guideSettings.rememberGuide) {
                this.currentCategory = lastGuideCat;
                GuidePage lastPage = SkyResourcesGuide.getPage(lastGuidePage);
                this.currentPage = lastPage == null ? SkyResourcesGuide.getPage("stage1") : lastPage;
            } else {
                this.currentPage = SkyResourcesGuide.getPage("stage1");
            }
        }
        if (this.linkButtons == null) {
            this.linkButtons = new ArrayList<GuiPageButton>();
        }
        if (this.infoButtons == null) {
            this.infoButtons = new ArrayList<GuiButton>();
        }
        if (this.pageHistory == null) {
            this.pageHistory = new ArrayList<String>();
        }
        this.field_146292_n.clear();
        this.linkButtons.clear();
        this.infoButtons.clear();
        if (this.searchBox == null) {
            this.searchBox = new GuiTextField(55, this.field_146289_q, 120, 5, 100, 20);
            this.searchBox.func_146203_f(23);
            this.searchBox.func_146195_b(true);
            if (ConfigOptions.guideSettings.rememberGuide && !Strings.isNullOrEmpty((String)lastGuideSearch)) {
                this.searchBox.func_146180_a(lastGuideSearch);
            }
        }
        this.searchBox.field_146218_h = Math.min(this.field_146294_l / 2, 250) - 110;
        if (this.pageScroll == null || this.pageScroll.getWidth() != this.field_146294_l || this.pageScroll.getHeight() != this.field_146295_m) {
            this.pageScroll = new PageList(this.field_146297_k, Math.min(this.field_146294_l / 2, 250), this.field_146295_m - 60, 40, this.field_146295_m - 20, 10, 20, this.field_146294_l, this.field_146295_m);
        }
        if (this.pageInfo == null || this.pageInfo.getWidth() != this.field_146294_l || this.pageInfo.getHeight() != this.field_146295_m) {
            this.pageInfo = new PageInfo(this.field_146297_k, this.field_146294_l - Math.max(this.field_146294_l / 2 - 100, 225) - 50, this.field_146295_m - 60, 40, this.field_146295_m - 20, Math.max(this.field_146294_l / 2 - 100, 275), 20, this.field_146294_l, this.field_146295_m);
        }
        this.cycleCatLeftButton = new GuiButton(8, 10, 4, 10, 20, "<");
        this.field_146292_n.add(this.cycleCatLeftButton);
        this.cycleCatRightButton = new GuiButton(9, 105, 4, 10, 20, ">");
        this.field_146292_n.add(this.cycleCatRightButton);
        this.closeButton = new GuiButton(0, 0, this.field_146295_m - 20, 40, 20, "Close");
        this.field_146292_n.add(this.closeButton);
        this.backButton = new GuiButton(10, Math.max(this.field_146294_l / 2 - 100, 275), 2, 40, 20, "Back");
        this.field_146292_n.add(this.backButton);
        this.addLinkButtons();
        this.currentPageInfo = this.setupPage(this.currentPage.pageInfo, this.field_146294_l - Math.max(this.field_146294_l / 2 - 100, 225) - 50, 600);
        if (this.currentImage != null) {
            for (GuiButton b : this.field_146292_n) {
                if (b == this.closeButton) continue;
                b.field_146124_l = false;
            }
        }
        this.curIndex = this.getPageIndex(this.currentPage);
    }

    public void addLinkButton(String pageLink, String display, ItemStack stack) {
        this.linkButtons.add(new GuiPageButton(this.linkButtons.size() + 2000, 10, 40 + this.linkButtons.size() * 20, new GuideLinkPageButton(pageLink, display, stack)));
    }

    public int getMaxLinkButtons() {
        int heightAllowed = this.field_146295_m - 40 - 20;
        return (int)Math.floor((float)heightAllowed / 20.0f);
    }

    public void removeLinkButtons() {
        this.linkButtons.clear();
    }

    public void addLinkButtons() {
        for (GuidePage p : SkyResourcesGuide.getPages(this.currentCategory, this.searchBox == null ? "" : this.searchBox.func_146179_b())) {
            this.addLinkButton(p.pageId, p.pageDisplay, p.pageItemDisplay);
        }
    }

    public int getPageIndex(GuidePage page) {
        for (int i = 0; i < (this.linkButtons == null ? 0 : this.linkButtons.size()); ++i) {
            if (!(this.linkButtons.get((int)i).buttonInfo instanceof GuideLinkPageButton) || ((GuideLinkPageButton)this.linkButtons.get((int)i).buttonInfo).getLinkPage().pageId != page.pageId) continue;
            return i;
        }
        return 0;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        block11: {
            GuiButton b;
            int curIndex;
            List<String> categories;
            if (button == this.closeButton) {
                if (this.currentImage == null) {
                    this.field_146297_k.func_147108_a(null);
                    if (this.field_146297_k.field_71462_r == null) {
                        this.field_146297_k.func_71381_h();
                    }
                } else {
                    this.closeImage();
                }
            }
            if (this.currentImage != null) break block11;
            if (button == this.cycleCatLeftButton) {
                categories = SkyResourcesGuide.getCategories();
                curIndex = categories.indexOf(this.currentCategory);
                if (--curIndex < -1) {
                    curIndex = categories.size() - 1;
                }
                this.currentCategory = curIndex == -1 ? "" : categories.get(curIndex);
                curIndex = 0;
                this.removeLinkButtons();
                this.addLinkButtons();
            }
            if (button == this.cycleCatRightButton) {
                categories = SkyResourcesGuide.getCategories();
                curIndex = categories.indexOf(this.currentCategory);
                if (++curIndex >= categories.size()) {
                    curIndex = -1;
                }
                this.currentCategory = curIndex == -1 ? "" : categories.get(curIndex);
                curIndex = 0;
                this.removeLinkButtons();
                this.addLinkButtons();
            }
            if (button == this.backButton && this.pageHistory.size() > 0) {
                String prevPage = this.pageHistory.get(this.pageHistory.size() - 1);
                this.pageHistory.remove(this.pageHistory.size() - 1);
                this.currentPage = SkyResourcesGuide.getPage(prevPage);
                this.curIndex = this.getPageIndex(this.currentPage);
                this.func_73866_w_();
            }
            Iterator<Object> iterator = this.field_146292_n.iterator();
            while (!(!iterator.hasNext() || (b = (GuiButton)iterator.next()) instanceof GuiPageButton && b == button && ((GuiPageButton)b).onPressed())) {
            }
            iterator = this.infoButtons.iterator();
            while (!(!iterator.hasNext() || (b = (GuiButton)iterator.next()) instanceof GuiPageButton && b == button && ((GuiPageButton)b).onPressed())) {
            }
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.pageScroll.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchBox.func_146201_a(typedChar, keyCode)) {
            this.curIndex = 0;
            this.removeLinkButtons();
            this.addLinkButtons();
        } else if (keyCode == 1) {
            if (this.currentImage == null) {
                super.func_73869_a(typedChar, keyCode);
            } else {
                this.closeImage();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < this.infoButtons.size(); ++i) {
                GuiButton guibutton = this.infoButtons.get(i);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.infoButtons);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                guibutton = event.getButton();
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
            }
        }
    }

    void drawItem(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(stack, x, y);
        RenderHelper.func_74518_a();
    }

    List<List<Object>> setupPage(String info, int width, int height) {
        int buttonIndex = 5000;
        ArrayList<List<Object>> richTextLines = new ArrayList<List<Object>>();
        String string = I18n.func_74838_a((String)info).replace("\\n", "\n");
        String[] words = string.split(" ");
        ArrayList<Object> line = new ArrayList<Object>();
        int lineWidth = 0;
        String currentString = "";
        for (String word : words) {
            int wordWidth;
            if (word.equals("\n")) {
                line.add(currentString);
                currentString = "";
                richTextLines.add(line);
                line = new ArrayList();
                lineWidth = 0;
                continue;
            }
            if (word.equals("*nl")) {
                line.add(currentString);
                line.add("*nl");
                currentString = "";
                continue;
            }
            if (word.equals("*gl")) {
                line.add(currentString);
                line.add("*gl");
                currentString = "";
                continue;
            }
            if (word.startsWith("<") && word.endsWith(">")) {
                String argWord = word.replace("<", "").replace(">", "");
                String[] args = argWord.split(",");
                GuidePageButton button = SkyResourcesGuide.getBlankButton(args[0]);
                if (button == null) continue;
                line.add(currentString);
                button.setDisplay(args[1]);
                button.setItemDisplay(args[2]);
                button.setArguments(args);
                GuiPageButton guiButton = new GuiPageButton(buttonIndex, -100, -100, button);
                guiButton.resetWidth();
                if (lineWidth + guiButton.field_146120_f > width) {
                    richTextLines.add(line);
                    line = new ArrayList();
                    lineWidth = 0;
                }
                this.infoButtons.add(guiButton);
                lineWidth += guiButton.field_146120_f;
                line.add((Object)guiButton);
                currentString = " ";
                ++buttonIndex;
                continue;
            }
            if (currentString.equals(" ") && (word.equals(",") || word.equals(".") || word.equals("!"))) {
                currentString = "";
            }
            if (lineWidth + (wordWidth = this.field_146289_q.func_78256_a(word + " ")) > width) {
                line.add(currentString);
                currentString = "";
                richTextLines.add(line);
                line = new ArrayList();
                lineWidth = 0;
            }
            currentString = currentString + word + " ";
            lineWidth += wordWidth;
        }
        line.add(currentString);
        richTextLines.add(line);
        return richTextLines;
    }

    private class PageInfo
    extends GuiScrollingList {
        public PageInfo(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
            super(client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
        }

        protected int getSize() {
            return GuideGUI.this.currentPageInfo.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotId, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            int curX = this.left;
            int curY = slotTop;
            if (GuideGUI.this.currentPageInfo != null) {
                for (Object obj : GuideGUI.this.currentPageInfo.get(slotId)) {
                    if (obj instanceof String) {
                        if (obj.toString().equals("*gl")) {
                            GuideGUI.this.fontType = 1;
                            continue;
                        }
                        if (obj.toString().equals("*nl")) {
                            GuideGUI.this.fontType = 0;
                            continue;
                        }
                        Date date = new Date();
                        FontRenderer fontrenderer = GuideGUI.this.fontType == 1 || date.getMonth() == 3 && date.getDate() == 1 ? GuideGUI.this.field_146297_k.field_71464_q : GuideGUI.this.field_146297_k.field_71466_p;
                        fontrenderer.func_78276_b(obj.toString(), curX, curY, 0xFFFFFF);
                        curX += fontrenderer.func_78256_a(obj.toString());
                        continue;
                    }
                    if (!(obj instanceof GuiPageButton)) continue;
                    GuiPageButton button = (GuiPageButton)((Object)obj);
                    button.buttonInfo.setDisplay(button.buttonInfo.getDisplay().replace("_", " "));
                    button.field_146128_h = curX;
                    button.field_146129_i = curY - 4;
                    button.drawButton(GuideGUI.this.field_146297_k, this.mouseX, this.mouseY, 0);
                    curX += button.field_146120_f;
                }
            }
        }

        public int getHeight() {
            return this.screenHeight;
        }

        public int getWidth() {
            return this.screenWidth;
        }
    }

    private class PageList
    extends GuiScrollingList {
        public PageList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
            super(client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
        }

        protected int getSize() {
            return GuideGUI.this.linkButtons.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            GuideGUI.this.curIndex = index;
            GuiPageButton button = GuideGUI.this.linkButtons.get(index);
            button.onPressed();
        }

        protected boolean isSelected(int index) {
            return GuideGUI.this.curIndex == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotId, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            GuiPageButton button = GuideGUI.this.linkButtons.get(slotId);
            button.drawScrollButton(GuideGUI.this.field_146297_k, this.left, slotTop, this.isSelected(slotId));
        }

        public int getHeight() {
            return this.screenHeight;
        }

        public int getWidth() {
            return this.screenWidth;
        }
    }

    public static class SpecialTextEffect {
        int type = 0;

        public SpecialTextEffect(int type) {
            this.type = type;
        }
    }
}

