/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.tile;

import com.bartz24.skyresources.base.tile.TileItemInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileGenericPower
extends TileItemInventory
implements IEnergyStorage {
    protected int energy;
    protected int maxEnergy;
    protected int maxReceive;
    protected int maxExtract;

    public TileGenericPower(String name, int maxPower, int maxIn, int maxOut) {
        super(name, 0);
        this.maxEnergy = maxPower;
        this.maxReceive = maxIn;
        this.maxExtract = maxOut;
    }

    public TileGenericPower(String name, int maxPower, int maxIn, int maxOut, int invSlots, int[] noInsert, int[] noExtract) {
        super(name, invSlots, noInsert, noExtract);
        this.maxEnergy = maxPower;
        this.maxReceive = maxIn;
        this.maxExtract = maxOut;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.func_70296_d();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtract = Math.min(Math.max(this.energy, 0), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtract;
            this.func_70296_d();
        }
        return energyExtract;
    }

    public int internalExtractEnergy(int extract, boolean simulate) {
        int energyExtract = Math.min(Math.max(this.energy, 0), extract);
        if (!simulate) {
            this.energy -= energyExtract;
            this.func_70296_d();
        }
        return energyExtract;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.maxExtract != 0;
    }

    public boolean canReceive() {
        return this.maxReceive != 0;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Energy", this.energy);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74762_e("Energy");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

