/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.plugin.forestry.tile;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.base.tile.TileGenericPower;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.plugin.ModPlugins;
import com.bartz24.skyresources.plugin.extrabees.ExtraBeesPlugin;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.worldgen.Hive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;

public class TileBeeAttractor
extends TileGenericPower
implements ITickable,
IFluidHandler {
    private FluidTank tank;
    private int powerUsage;
    private int fluidUsage;

    public TileBeeAttractor() {
        super("beeAttractor", 100000, 2000, 0, 6, new int[]{0, 1, 2, 3, 4, 5}, null);
        this.powerUsage = ConfigOptions.pluginSettings.forestrySettings.beeAttractorPowerUsage;
        this.fluidUsage = ConfigOptions.pluginSettings.forestrySettings.beeAttractorSeedOilUsage;
        this.tank = new FluidTank(ConfigOptions.pluginSettings.forestrySettings.beeAttractorSeedOilCapacity);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.getRedstoneSignal() == 0 && this.tank.getFluidAmount() >= this.fluidUsage && this.tank.getFluid().getFluid().getName().equals("seed.oil") && this.energy >= this.powerUsage && !this.isInvFull()) {
            this.tank.drain(this.fluidUsage, true);
            this.energy -= this.powerUsage;
            for (int i = 0; i < this.field_145850_b.field_73012_v.nextInt(3) + 1; ++i) {
                if (this.isInvFull()) continue;
                ItemStack bee = this.getRandomBee();
                RandomHelper.fillInternalInventory(this.getInventory(), bee);
            }
        }
        this.func_70296_d();
    }

    boolean isInvFull() {
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            if (!this.getInventory().getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    ItemStack getRandomBee() {
        if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
            boolean smallChance;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            boolean bl = smallChance = this.field_145850_b.field_73012_v.nextFloat() <= 0.25f;
            while (drops.size() == 0) {
                for (Hive h : ModuleApiculture.getHiveRegistry().getHives()) {
                    Biome biome = this.field_145850_b.getBiomeForCoordsBody(this.func_174877_v());
                    if (smallChance || h.isGoodBiome(biome) && h.isGoodHumidity(EnumHumidity.getFromValue((float)biome.func_76727_i())) && h.isGoodTemperature(EnumTemperature.getFromValue((float)biome.func_185353_n()))) {
                        List hiveDrops = h.getDrops();
                        drops.addAll(this.getBeeDrops(hiveDrops));
                    }
                    if (!Loader.isModLoaded((String)"extrabees")) continue;
                    drops.addAll(this.getBeeDrops(((ExtraBeesPlugin)ModPlugins.plugins.get("extrabees")).getAllHiveDrops()));
                }
                smallChance = true;
            }
            boolean princess = this.field_145850_b.field_73012_v.nextInt(5) == 0;
            ItemStack beeStack = ItemStack.field_190927_a;
            for (int tries = 0; beeStack.func_190926_b() && tries < 30; ++tries) {
                ItemStack stack = (ItemStack)drops.get(this.field_145850_b.field_73012_v.nextInt(drops.size()));
                if (princess && stack.func_77973_b() == ModuleApiculture.getItems().beePrincessGE) {
                    beeStack = stack;
                    continue;
                }
                if (princess || stack.func_77973_b() != ModuleApiculture.getItems().beeDroneGE) continue;
                beeStack = stack;
            }
            return beeStack.func_190926_b() ? ItemStack.field_190927_a : beeStack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    List<ItemStack> getBeeDrops(List<IHiveDrop> hiveDrops) {
        IBee bee;
        Collections.shuffle(hiveDrops);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (this.field_145850_b.field_73012_v.nextDouble() >= drop.getChance((IBlockAccess)this.field_145850_b, this.field_174879_c, 0)) continue;
                bee = drop.getBeeType((IBlockAccess)this.field_145850_b, this.field_174879_c);
                if ((double)this.field_145850_b.field_73012_v.nextFloat() < drop.getIgnobleChance((IBlockAccess)this.field_145850_b, this.field_174879_c, 0)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS);
                drops.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (this.field_145850_b.field_73012_v.nextDouble() >= drop.getChance((IBlockAccess)this.field_145850_b, this.field_174879_c, 0)) continue;
            bee = drop.getBeeType((IBlockAccess)this.field_145850_b, this.field_174879_c);
            ItemStack drone = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
            drops.add(drone);
            break;
        }
        return drops;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid().getName().equals("seed.oil")) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
    }

    public FluidTank getTank() {
        return this.tank;
    }
}

