/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.item;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.gui.GuiCasing;
import com.bartz24.skyresources.base.gui.GuiHelper;
import com.bartz24.skyresources.base.gui.SlotSpecial;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import com.bartz24.skyresources.technology.tile.TileCombustionCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class ItemCombustionHeater
extends ItemMachine {
    public ItemCombustionHeater() {
        super("combustionheater", ModCreativeTabs.tabTech, false, true, true, true);
    }

    public List<Material> ValidMaterialsForCrafting(ItemStack machineStack) {
        ArrayList<Material> mats = new ArrayList<Material>();
        switch (machineStack.func_77960_j()) {
            case 0: {
                mats.add(Material.field_151575_d);
                mats.add(Material.field_151592_s);
                break;
            }
            case 1: {
                mats.add(Material.field_151576_e);
                mats.add(Material.field_151592_s);
                break;
            }
            default: {
                mats.add(Material.field_151573_f);
                mats.add(Material.field_151576_e);
                mats.add(Material.field_151592_s);
            }
        }
        return mats;
    }

    public int getMaxHU(World world, BlockPos pos) {
        return MachineVariants.values()[world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos))].getMaxHeat();
    }

    public boolean isValidFuel(ItemStack machineStack, Object stack) {
        if (this.getVariant(machineStack).getFuelType().equals("Fuel") && stack instanceof ItemStack && TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)stack)) <= 0) {
            return false;
        }
        if (this.getVariant(machineStack).getFuelType() instanceof ItemStack && stack instanceof ItemStack && !((ItemStack)this.getVariant(machineStack).getFuelType()).func_77969_a((ItemStack)stack)) {
            return false;
        }
        return !(this.getVariant(machineStack).getFuelType() instanceof Fluid) || !(stack instanceof FluidStack) || (Fluid)this.getVariant(machineStack).getFuelType() == ((FluidStack)stack).getFluid();
    }

    private void heatUp(ItemStack machineStack, World world, BlockPos pos, NBTTagCompound data) {
        float curHU = data.func_74760_g("curHU");
        float itemHU = data.func_74760_g("itemHU");
        float huTick = data.func_74760_g("huTick");
        float huAdded = 0.0f;
        boolean added = true;
        while (added && (huAdded < huTick || huTick == 0.0f)) {
            added = false;
            if (curHU < (float)this.getMaxHU(world, pos) && itemHU > 0.0f) {
                float amt = Math.max(Math.min(Math.min((float)this.getMaxHU(world, pos) - curHU, huTick - huAdded), itemHU), 0.0f);
                if (!(amt > 0.0f)) continue;
                curHU += amt;
                huAdded += amt;
                itemHU -= amt;
                added = true;
                continue;
            }
            if (!(itemHU <= 0.0f)) continue;
            data.func_74776_a("itemHU", itemHU);
            data.func_74776_a("huTick", huTick);
            this.getFuel(machineStack, world, pos, data);
            itemHU = data.func_74760_g("itemHU");
            huTick = data.func_74760_g("huTick");
            if (!(itemHU > 0.0f)) continue;
            added = true;
        }
        data.func_74776_a("curHU", curHU);
        data.func_74776_a("itemHU", itemHU);
        data.func_74776_a("huTick", huTick);
    }

    private void getFuel(ItemStack machineStack, World world, BlockPos pos, NBTTagCompound data) {
        if (this.getVariant(machineStack).getFuelType().equals("RF")) {
            float extract = this.getCasingTile(world, pos).internalExtractEnergy((int)this.getMachineFuelData(machineStack, world, pos)[1], false);
            if (extract > 0.0f) {
                data.func_74776_a("itemHU", extract / this.getMachineFuelData(machineStack, world, pos)[2]);
                data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            }
        } else if (this.getVariant(machineStack).getFuelType() instanceof ItemStack && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getInventory().getStackInSlot(0))) {
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0]);
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_190918_g(1);
        } else if (this.getVariant(machineStack).getFuelType() instanceof Fluid && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getTank().getFluid()) && this.getCasingTile(world, pos).getTank().drainInternal(1, false) != null && this.getCasingTile((World)world, (BlockPos)pos).getTank().drainInternal((int)1, (boolean)true).amount > 0) {
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0]);
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
        } else if (this.getVariant(machineStack).getFuelType().equals("Fuel") && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getInventory().getStackInSlot(0))) {
            float huStored = this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0] * (float)TileEntityFurnace.func_145952_a((ItemStack)this.getCasingTile(world, pos).getInventory().getStackInSlot(0));
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0] * (float)TileEntityFurnace.func_145952_a((ItemStack)this.getCasingTile(world, pos).getInventory().getStackInSlot(0)));
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_190918_g(1);
        } else {
            data.func_74776_a("itemHU", 0.0f);
            data.func_74776_a("huTick", 0.0f);
        }
        data.func_74776_a("maxHU", data.func_74760_g("itemHU"));
    }

    @Override
    public void update(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
        if (this.getCasingTile(world, pos).receivedPulse() && this.hasValidMultiblock(world, pos, machineStack)) {
            this.craftItem(world, pos, machineStack, data);
        }
        if (!world.field_72995_K) {
            this.heatUp(machineStack, world, pos, data);
            float curHU = data.func_74760_g("curHU");
            if (!this.hasValidMultiblock(world, pos, machineStack) && curHU > 0.0f) {
                curHU -= 1.0f;
            }
            curHU = Math.max(0.0f, Math.min(curHU, (float)this.getMaxHU(world, pos)));
            data.func_74776_a("curHU", curHU);
        }
    }

    public TileCombustionCollector getCollector(World world, BlockPos pos) {
        BlockPos[] poses;
        for (BlockPos p : poses = new BlockPos[]{pos.func_177982_a(-1, 1, 0), pos.func_177982_a(1, 1, 0), pos.func_177982_a(0, 1, -1), pos.func_177982_a(0, 1, 1), pos.func_177982_a(0, 2, 0)}) {
            TileEntity t = world.func_175625_s(p);
            if (t == null || !(t instanceof TileCombustionCollector)) continue;
            return (TileCombustionCollector)t;
        }
        return null;
    }

    public boolean hasValidMultiblock(World world, BlockPos pos, ItemStack machineStack) {
        List<Material> materials = this.ValidMaterialsForCrafting(machineStack);
        return this.isBlockValid(world, machineStack, pos.func_177984_a(), pos.func_177982_a(-1, 1, 0)) && this.isBlockValid(world, machineStack, pos.func_177984_a(), pos.func_177982_a(1, 1, 0)) && this.isBlockValid(world, machineStack, pos.func_177984_a(), pos.func_177982_a(0, 2, 0)) && this.isBlockValid(world, machineStack, pos.func_177984_a(), pos.func_177982_a(0, 1, -1)) && this.isBlockValid(world, machineStack, pos.func_177984_a(), pos.func_177982_a(0, 1, 1)) && world.func_175623_d(pos.func_177984_a());
    }

    boolean isBlockValid(World world, ItemStack machineStack, BlockPos center, BlockPos pos) {
        BlockPos dir = center.func_177973_b((Vec3i)pos);
        return this.ValidMaterialsForCrafting(machineStack).contains(world.func_180495_p(pos).func_185904_a()) && world.func_180495_p(pos).func_193401_d((IBlockAccess)world, pos, EnumFacing.func_176737_a((float)dir.func_177958_n(), (float)dir.func_177956_o(), (float)dir.func_177952_p())) == BlockFaceShape.SOLID;
    }

    void craftItem(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
        float curHU = data.func_74760_g("curHU");
        ProcessRecipe recipe = this.recipeToCraft(world, pos, curHU);
        if (recipe != null) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
            if ((double)MachineVariants.values()[world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos))].getRawSpeed() < 2.0) {
                world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            if (!world.field_72995_K) {
                List list = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 2.0f), (double)(pos.func_177952_p() + 1)));
                HashMap<Object, Integer> items = new HashMap<Object, Integer>();
                for (EntityItem o : list) {
                    ItemStack i = o.func_92059_d().func_77946_l();
                    int n = i.func_190916_E();
                    i.func_190920_e(1);
                    boolean added = false;
                    for (ItemStack i2 : items.keySet()) {
                        if (!i2.func_77969_a(i)) continue;
                        items.put(i2, (Integer)items.get(i2) + n);
                        added = true;
                    }
                    if (!added) {
                        items.put(i, n);
                    }
                    o.func_70106_y();
                }
                ItemStack item1 = items.keySet().toArray(new ItemStack[items.size()])[0];
                int ratio = 0;
                for (Object e : recipe.getInputs()) {
                    if (!item1.func_77969_a((ItemStack)e)) continue;
                    ratio = (Integer)items.get(item1) / ((ItemStack)e).func_190916_E();
                    break;
                }
                for (int times = 0; times < ratio && !(curHU < recipe.getIntParameter()); ++times) {
                    for (Object recStack : recipe.getInputs()) {
                        for (ItemStack item2 : items.keySet().toArray(new ItemStack[items.size()])) {
                            if (!item2.func_77969_a((ItemStack)recStack)) continue;
                            items.put(item2, (Integer)items.get(item2) - ((ItemStack)recStack).func_190916_E());
                        }
                    }
                    float f = 1.0f - 1.0f / (1.5f + 0.8f * this.getMachineEfficiency(machineStack, world, pos));
                    curHU *= f;
                    ItemStack stack = recipe.getOutputs().get(0).func_77946_l();
                    TileCombustionCollector collector = this.getCollector(world, pos);
                    if (collector != null) {
                        for (int i = 0; i < 5 && !stack.func_190926_b(); ++i) {
                            stack = collector.getInventory().insertItem(i, stack, false);
                        }
                    }
                    if (stack.func_190926_b()) continue;
                    EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), stack);
                    world.func_72838_d((Entity)entity);
                }
                for (ItemStack item2 : items.keySet().toArray(new ItemStack[items.size()])) {
                    if ((Integer)items.get(item2) <= 0) continue;
                    EntityItem entity = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), item2);
                    entity.func_92059_d().func_190920_e(((Integer)items.get(item2)).intValue());
                    world.func_72838_d((Entity)entity);
                }
            }
        }
        data.func_74776_a("curHU", curHU);
    }

    public ProcessRecipe recipeToCraft(World world, BlockPos pos, float curHU) {
        List list = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)));
        ArrayList<Object> items = new ArrayList<Object>();
        for (EntityItem i : list) {
            items.add(i.func_92059_d());
        }
        ProcessRecipe recipe = ProcessRecipeManager.combustionRecipes.getMultiRecipe(items, curHU);
        return recipe;
    }

    @Override
    public List<Slot> getSlots(TileCasing tile) {
        if (this.getItemSlots(tile.machineStored) == 1) {
            return Collections.singletonList(new SlotSpecial((IItemHandler)tile.getInventory(), 0, 80, 53));
        }
        return new ArrayList<Slot>();
    }

    @Override
    public int getMaxEnergy(ItemStack stack) {
        this.getVariant(stack);
        return MachineVariants.values()[stack.func_77960_j()].getFuelType().equals("RF") ? 100000 : 0;
    }

    @Override
    public int getMaxReceive(ItemStack stack) {
        this.getVariant(stack);
        return MachineVariants.values()[stack.func_77960_j()].getFuelType().equals("RF") ? 10000 : 0;
    }

    @Override
    public int getItemSlots(ItemStack stack) {
        this.getVariant(stack);
        MachineVariants variant = MachineVariants.values()[stack.func_77960_j()];
        return variant.getFuelType().equals("Fuel") || variant.getFuelType() instanceof ItemStack ? 1 : 0;
    }

    @Override
    public int[] getExtractBlacklist(ItemStack stack) {
        int[] nArray;
        if (this.getItemSlots(stack) == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public Fluid getFluid(ItemStack stack) {
        this.getVariant(stack);
        MachineVariants variant = MachineVariants.values()[stack.func_77960_j()];
        return variant.getFuelType() instanceof Fluid ? (Fluid)variant.getFuelType() : null;
    }

    @Override
    public int getMaxFluid(ItemStack stack) {
        return this.getFluid(stack) != null ? 4000 : 0;
    }

    @Override
    public void drawBackgroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.drawBackgroundGui(tile, gui, fontRenderer, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(gui.getGuiLeft() + 8, gui.getGuiTop() + 24, 73, 0, 10, 45);
        if (this.getItemSlots(tile.machineStored) == 1) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/blankInventory.png"));
            gui.func_73729_b(gui.getGuiLeft() + 79, gui.getGuiTop() + 52, 7, 83, 18, 18);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
            gui.func_73729_b(gui.getGuiLeft() + 83, gui.getGuiTop() + 24, 73, 0, 10, 45);
        }
    }

    @Override
    public void drawForegroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        float curHU = tile.machineData.func_74760_g("curHU");
        float itemHU = tile.machineData.func_74760_g("itemHU");
        float maxHU = tile.machineData.func_74760_g("maxHU");
        float huTick = tile.machineData.func_74760_g("huTick");
        fontRenderer.func_78276_b("HU: ", 19, 24, -786665);
        fontRenderer.func_78276_b("" + (int)curHU, 42, 24, -786665);
        fontRenderer.func_78276_b("+ " + (int)huTick + " HU/t", gui.getXSize() - 8 - fontRenderer.func_78256_a("+ " + (int)huTick + " HU/t"), 64, -786665);
        fontRenderer.func_78276_b("Max: ", 19, 32, -786665);
        fontRenderer.func_78276_b("" + this.getMaxHU(tile.func_145831_w(), tile.func_174877_v()), 42, 32, -786665);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(9, 68 - (int)(curHU / (float)this.getMaxHU(tile.func_145831_w(), tile.func_174877_v()) * 43.0f), 59, 82 - (int)(curHU / (float)this.getMaxHU(tile.func_145831_w(), tile.func_174877_v()) * 43.0f), 9, (int)(curHU / (float)this.getMaxHU(tile.func_145831_w(), tile.func_174877_v()) * 43.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(100, 52, 29, 60, 3, 18);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(101, 69 - (int)(16.0f * itemHU / maxHU), 26, 77 - (int)(16.0f * itemHU / maxHU), 1, (int)(16.0f * itemHU / maxHU));
        if (this.getMaxEnergy(tile.machineStored) > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
            gui.func_73729_b(84, 68 - (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)), 51, 59 - (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)), 8, (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)));
        } else if (this.getMaxFluid(tile.machineStored) > 0) {
            RandomHelper.renderGuiTank(tile.getTank().getFluid(), this.getMaxFluid(tile.machineStored), tile.getTank().getFluidAmount(), 84.0, 25.0, 8.0, 43.0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiIcons.png"));
        gui.func_73729_b(20, 40, 0, 16, 32, 28);
        if (this.hasValidMultiblock(tile.func_145831_w(), tile.func_174877_v(), tile.machineStored)) {
            gui.func_73729_b(52, 48, 0, 0, 16, 16);
        } else {
            gui.func_73729_b(52, 48, 16, 0, 16, 16);
        }
        super.drawForegroundGui(tile, gui, fontRenderer, mouseX, mouseY);
        if (GuiHelper.isMouseInRect(20 + gui.getGuiLeft(), 40 + gui.getGuiTop(), 50, 28, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.hasValidMultiblock(tile.func_145831_w(), tile.func_174877_v(), tile.machineStored)) {
                list.add("Multiblock Formed!");
            } else {
                list.add("Multiblock Not Formed.");
            }
            int k = (gui.field_146294_l - gui.getXSize()) / 2;
            int l = (gui.field_146295_m - gui.getYSize()) / 2;
            gui.drawHoveringText(list, mouseX - k, mouseY - l, fontRenderer);
        }
    }
}

