/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.item;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.gui.GuiCasing;
import com.bartz24.skyresources.base.gui.SlotSpecial;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHeatProvider
extends ItemMachine {
    public ItemHeatProvider() {
        super("heatprovider", ModCreativeTabs.tabTech, false, true, true, true);
    }

    @Override
    public void update(World world, BlockPos pos, ItemStack machineStack, NBTTagCompound data) {
        if (!world.field_72995_K) {
            if (this.getCasingTile(world, pos).getRedstoneSignal() == 0 && data.func_74760_g("itemHU") <= 0.0f) {
                this.getFuel(machineStack, world, pos, data);
            }
            if (data.func_74760_g("itemHU") <= 0.0f) {
                data.func_74776_a("huTick", 0.0f);
            } else {
                data.func_74776_a("itemHU", data.func_74760_g("itemHU") - 1.0f);
            }
        }
    }

    @Override
    public String[] getFuelDisplay(ItemStack stack, @Nullable World world, BlockPos pos) {
        String[] list = super.getFuelDisplay(stack, world, pos);
        list[1] = TextFormatting.RED.toString() + this.getHUPerTick(stack, world, pos, this.useSpeedInfo) + " Heat Value" + TextFormatting.YELLOW;
        return list;
    }

    public boolean isValidFuel(ItemStack machineStack, Object stack) {
        if (this.getVariant(machineStack).getFuelType().equals("Fuel") && stack instanceof ItemStack && TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)stack)) <= 0) {
            return false;
        }
        if (this.getVariant(machineStack).getFuelType() instanceof ItemStack && stack instanceof ItemStack && !((ItemStack)this.getVariant(machineStack).getFuelType()).func_77969_a((ItemStack)stack)) {
            return false;
        }
        return !(this.getVariant(machineStack).getFuelType() instanceof Fluid) || !(stack instanceof FluidStack) || (Fluid)this.getVariant(machineStack).getFuelType() == ((FluidStack)stack).getFluid();
    }

    private void getFuel(ItemStack machineStack, World world, BlockPos pos, NBTTagCompound data) {
        if (this.getVariant(machineStack).getFuelType().equals("RF")) {
            float extract = this.getCasingTile(world, pos).internalExtractEnergy((int)Math.ceil(this.getMachineFuelData(machineStack, world, pos)[1]), false);
            if (extract > 0.0f) {
                data.func_74776_a("itemHU", extract / this.getMachineFuelData(machineStack, world, pos)[2]);
                data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            }
        } else if (this.getVariant(machineStack).getFuelType() instanceof ItemStack && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getInventory().getStackInSlot(0))) {
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0]);
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_190918_g(1);
        } else if (this.getVariant(machineStack).getFuelType() instanceof Fluid && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getTank().getFluid()) && this.getCasingTile(world, pos).getTank().drainInternal(1, false) != null && this.getCasingTile((World)world, (BlockPos)pos).getTank().drainInternal((int)1, (boolean)true).amount > 0) {
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0]);
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
        } else if (this.getVariant(machineStack).getFuelType().equals("Fuel") && this.isValidFuel(machineStack, this.getCasingTile(world, pos).getInventory().getStackInSlot(0))) {
            float huStored = this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0] * (float)TileEntityFurnace.func_145952_a((ItemStack)this.getCasingTile(world, pos).getInventory().getStackInSlot(0));
            data.func_74776_a("itemHU", this.getMachineFuelData(machineStack, world, pos)[1] * this.getMachineFuelData(machineStack, world, pos)[0] * (float)TileEntityFurnace.func_145952_a((ItemStack)this.getCasingTile(world, pos).getInventory().getStackInSlot(0)));
            data.func_74776_a("huTick", this.getMachineFuelData(machineStack, world, pos)[0]);
            this.getCasingTile(world, pos).getInventory().getStackInSlot(0).func_190918_g(1);
        } else {
            data.func_74776_a("itemHU", 0.0f);
            data.func_74776_a("huTick", 0.0f);
        }
        data.func_74776_a("maxHU", data.func_74760_g("itemHU"));
    }

    @Override
    public int getHeatProv(ItemStack stack, World world, BlockPos pos) {
        return (int)this.getCasingTile((World)world, (BlockPos)pos).machineData.func_74760_g("huTick");
    }

    @Override
    public List<Slot> getSlots(TileCasing tile) {
        if (this.getItemSlots(tile.machineStored) == 1) {
            return Collections.singletonList(new SlotSpecial((IItemHandler)tile.getInventory(), 0, 80, 53));
        }
        return new ArrayList<Slot>();
    }

    @Override
    public int getMaxEnergy(ItemStack stack) {
        this.getVariant(stack);
        return MachineVariants.values()[stack.func_77960_j()].getFuelType().equals("RF") ? 100000 : 0;
    }

    @Override
    public int getMaxReceive(ItemStack stack) {
        this.getVariant(stack);
        return MachineVariants.values()[stack.func_77960_j()].getFuelType().equals("RF") ? 10000 : 0;
    }

    @Override
    public int getItemSlots(ItemStack stack) {
        this.getVariant(stack);
        MachineVariants variant = MachineVariants.values()[stack.func_77960_j()];
        return variant.getFuelType().equals("Fuel") || variant.getFuelType() instanceof ItemStack ? 1 : 0;
    }

    @Override
    public int[] getExtractBlacklist(ItemStack stack) {
        int[] nArray;
        if (this.getItemSlots(stack) == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public Fluid getFluid(ItemStack stack) {
        this.getVariant(stack);
        MachineVariants variant = MachineVariants.values()[stack.func_77960_j()];
        return variant.getFuelType() instanceof Fluid ? (Fluid)variant.getFuelType() : null;
    }

    @Override
    public int getMaxFluid(ItemStack stack) {
        return this.getFluid(stack) != null ? 4000 : 0;
    }

    @Override
    public void drawBackgroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.drawBackgroundGui(tile, gui, fontRenderer, mouseX, mouseY);
        if (this.getItemSlots(tile.machineStored) == 1) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/blankInventory.png"));
            gui.func_73729_b(gui.getGuiLeft() + 79, gui.getGuiTop() + 52, 7, 83, 18, 18);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
            gui.func_73729_b(gui.getGuiLeft() + 83, gui.getGuiTop() + 24, 73, 0, 10, 45);
        }
    }

    @Override
    public void drawForegroundGui(TileCasing tile, GuiCasing gui, FontRenderer fontRenderer, int mouseX, int mouseY) {
        fontRenderer.func_78276_b(this.getHeatProv(tile.machineStored, tile.func_145831_w(), tile.func_174877_v()) + " Heat", 19, 24, -786665);
        float itemHU = tile.machineData.func_74760_g("itemHU");
        float maxHU = tile.machineData.func_74760_g("maxHU");
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(100, 52, 29, 60, 3, 18);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
        gui.func_73729_b(101, 69 - (int)(16.0f * itemHU / maxHU), 26, 77 - (int)(16.0f * itemHU / maxHU), 1, (int)(16.0f * itemHU / maxHU));
        if (this.getMaxEnergy(tile.machineStored) > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("skyresources", "textures/gui/guiicons.png"));
            gui.func_73729_b(84, 68 - (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)), 51, 59 - (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)), 8, (int)(43.0f * (float)tile.getEnergyStored() / (float)this.getMaxEnergy(tile.machineStored)));
        } else if (this.getMaxFluid(tile.machineStored) > 0) {
            RandomHelper.renderGuiTank(tile.getTank().getFluid(), this.getMaxFluid(tile.machineStored), tile.getTank().getFluidAmount(), 84.0, 25.0, 8.0, 43.0);
        }
        super.drawForegroundGui(tile, gui, fontRenderer, mouseX, mouseY);
    }
}

