/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.ItemHelper;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.base.tile.TileItemInventory;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.technology.block.BlockCombustionController;
import com.bartz24.skyresources.technology.item.ItemCombustionHeater;
import com.bartz24.skyresources.technology.tile.TileCombustionCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileCombustionController
extends TileItemInventory
implements ITickable {
    public int cooldownTicks = 0;

    public TileCombustionController() {
        super("combustionController", 5);
        this.getInventory().setSlotLimit(1);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("cooldown", this.cooldownTicks);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooldownTicks = compound.func_74762_e("cooldown");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRedstoneSignal() == 0 && this.cooldownTicks <= 0) {
                this.craftSingleItem();
            } else if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
            }
        }
        this.func_70296_d();
    }

    public ProcessRecipe recipeToCraft(float curHU) {
        List list = this.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.getPosBehind().func_177958_n(), (double)this.getPosBehind().func_177956_o(), (double)this.getPosBehind().func_177952_p(), (double)(this.getPosBehind().func_177958_n() + 1), (double)(this.getPosBehind().func_177956_o() + 1), (double)(this.getPosBehind().func_177952_p() + 1)));
        ArrayList<Object> items = new ArrayList<Object>();
        for (EntityItem i : list) {
            items.add(i.func_92059_d());
        }
        List<ProcessRecipe> recipes = ProcessRecipeManager.combustionRecipes.getRecipes();
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            ItemStack stack = this.getInventory().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            for (ProcessRecipe r : recipes) {
                if (!ItemHelper.itemStacksEqualOD(r.getOutputs().get(0), stack) || ProcessRecipeManager.combustionRecipes.compareRecipeLess(items, curHU, true, r) == null) continue;
                return r;
            }
        }
        return null;
    }

    void craftSingleItem() {
        if (this.getHeater() == null || this.getHeater().machineStored.func_190926_b() || this.getHeaterMachine() == null) {
            return;
        }
        float curHU = this.getHeater().machineData.func_74760_g("curHU");
        ProcessRecipe recipe = this.recipeToCraft(curHU);
        if (recipe != null) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)this.getPosBehind().func_177958_n(), (double)this.getPosBehind().func_177956_o() + 0.5, (double)this.getPosBehind().func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.getPosBehind().func_177958_n() + 0.5, (double)this.getPosBehind().func_177956_o() + 0.5, (double)this.getPosBehind().func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (!this.field_145850_b.field_72995_K) {
                List list = this.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.getPosBehind().func_177958_n(), (double)this.getPosBehind().func_177956_o(), (double)this.getPosBehind().func_177952_p(), (double)(this.getPosBehind().func_177958_n() + 1), (double)(this.getPosBehind().func_177956_o() + 1), (double)(this.getPosBehind().func_177952_p() + 1)));
                HashMap<Object, Integer> items = new HashMap<Object, Integer>();
                for (EntityItem o : list) {
                    ItemStack[] i = o.func_92059_d().func_77946_l();
                    int count = i.func_190916_E();
                    i.func_190920_e(1);
                    boolean added = false;
                    for (ItemStack i2 : items.keySet()) {
                        if (!i2.func_77969_a((ItemStack)i)) continue;
                        items.put(i2, (Integer)items.get(i2) + count);
                        added = true;
                    }
                    if (!added) {
                        items.put(i, count);
                    }
                    o.func_70106_y();
                }
                for (Object recStack : recipe.getInputs()) {
                    for (ItemStack item2 : items.keySet().toArray(new ItemStack[items.size()])) {
                        if (!item2.func_77969_a((ItemStack)recStack)) continue;
                        items.put(item2, (Integer)items.get(item2) - ((ItemStack)recStack).func_190916_E());
                    }
                }
                float mult = 1.0f - 1.0f / (1.5f + 0.8f * this.getHeaterMachine().getMachineEfficiency(this.getHeater().machineStored, this.field_145850_b, this.getPosBehind().func_177977_b()));
                curHU *= mult;
                this.cooldownTicks = ConfigOptions.machineSettings.combustionControllerTicks;
                ItemStack stack = recipe.getOutputs().get(0).func_77946_l();
                TileCombustionCollector collector = this.getHeaterMachine().getCollector(this.field_145850_b, this.getPosBehind().func_177977_b());
                if (collector != null) {
                    for (int i = 0; i < 5 && !stack.func_190926_b(); ++i) {
                        stack = collector.getInventory().insertItem(i, stack, false);
                    }
                }
                if (!stack.func_190926_b()) {
                    EntityItem entity = new EntityItem(this.field_145850_b, (double)((float)this.getPosBehind().func_177958_n() + 0.5f), (double)((float)this.getPosBehind().func_177956_o() + 0.5f), (double)((float)this.getPosBehind().func_177952_p() + 0.5f), stack);
                    this.field_145850_b.func_72838_d((Entity)entity);
                }
                for (ItemStack item2 : items.keySet().toArray(new ItemStack[items.size()])) {
                    if ((Integer)items.get(item2) <= 0) continue;
                    EntityItem entity = new EntityItem(this.field_145850_b, (double)((float)this.getPosBehind().func_177958_n() + 0.5f), (double)((float)this.getPosBehind().func_177956_o() + 0.5f), (double)((float)this.getPosBehind().func_177952_p() + 0.5f), item2);
                    entity.func_92059_d().func_190920_e(((Integer)items.get(item2)).intValue());
                    this.field_145850_b.func_72838_d((Entity)entity);
                }
            }
        }
        this.getHeater().machineData.func_74776_a("curHU", curHU);
    }

    BlockPos getPosBehind() {
        return this.func_174877_v().func_177971_a(((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockCombustionController.FACING)).func_176734_d().func_176730_m());
    }

    TileCasing getHeater() {
        TileEntity te = this.func_145831_w().func_175625_s(this.getPosBehind().func_177977_b());
        return te instanceof TileCasing ? (TileCasing)te : null;
    }

    ItemCombustionHeater getHeaterMachine() {
        ItemMachine item = this.getHeater().getMachine();
        return item instanceof ItemCombustionHeater ? (ItemCombustionHeater)this.getHeater().getMachine() : null;
    }
}

