/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.gui.ItemHandlerSpecial;
import com.bartz24.skyresources.base.tile.TileGenericPower;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;

public class TileRockCrusher
extends TileGenericPower
implements ITickable {
    private int powerUsage;
    private float curProgress;
    private NonNullList<ItemStack> bufferStacks;

    public TileRockCrusher() {
        super("rockCrusher", 100000, 2000, 0, 4, new int[]{1, 2, 3}, new int[]{0});
        this.powerUsage = ConfigOptions.machineSettings.rockCrusherPowerUsage;
        this.bufferStacks = NonNullList.func_191196_a();
        this.setInventory(new ItemHandlerSpecial(4, new int[]{1, 2, 3}, new int[]{0}){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileRockCrusher.this.func_70296_d();
            }
        });
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRedstoneSignal() == 0) {
                if (this.bufferStacks.size() > 0 && !this.fullOutput()) {
                    this.addToOutput(1);
                    this.addToOutput(2);
                    this.addToOutput(3);
                } else {
                    boolean hasRecipes = this.hasRecipes();
                    if (this.curProgress < 100.0f && this.getEnergyStored() >= this.powerUsage && hasRecipes && this.bufferStacks.size() == 0) {
                        this.internalExtractEnergy(this.powerUsage, false);
                        this.curProgress += (float)ConfigOptions.machineSettings.rockCrusherSpeed;
                    } else if (!hasRecipes) {
                        this.curProgress = 0.0f;
                    }
                    if (this.curProgress >= 100.0f && hasRecipes) {
                        ProcessRecipe recMachine = new ProcessRecipe(Collections.singletonList(this.getInventory().getStackInSlot(0)), 2.1474836E9f, "rockgrinder");
                        for (ProcessRecipe r : ProcessRecipeManager.rockGrinderRecipes.getRecipes()) {
                            float chance;
                            if (r == null || !recMachine.isInputRecipeEqualTo(r, false)) continue;
                            for (chance = r.getIntParameter() * 1.2f; chance >= 1.0f; chance -= 1.0f) {
                                this.bufferStacks.add((Object)r.getOutputs().get(0).func_77946_l());
                            }
                            if (!(this.field_145850_b.field_73012_v.nextFloat() <= chance)) continue;
                            this.bufferStacks.add((Object)r.getOutputs().get(0).func_77946_l());
                        }
                        this.getInventory().getStackInSlot(0).func_190918_g(1);
                        this.curProgress = 0.0f;
                    }
                }
            }
            this.func_70296_d();
        }
    }

    public void addToOutput(int slot) {
        if (this.bufferStacks.size() > 0) {
            ItemStack stack = this.getInventory().insertInternalItem(slot, (ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1), false);
            this.bufferStacks.set(this.bufferStacks.size() - 1, (Object)stack);
            if (((ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1)).func_190926_b()) {
                this.bufferStacks.remove(this.bufferStacks.size() - 1);
            }
        }
    }

    public boolean fullOutput() {
        return !this.getInventory().getStackInSlot(1).func_190926_b() && !this.getInventory().getStackInSlot(2).func_190926_b() && !this.getInventory().getStackInSlot(3).func_190926_b();
    }

    public boolean hasRecipes() {
        if (this.getInventory().getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ProcessRecipe recMachine = new ProcessRecipe(Collections.singletonList(this.getInventory().getStackInSlot(0)), 2.1474836E9f, "rockgrinder");
        for (ProcessRecipe r : ProcessRecipeManager.rockGrinderRecipes.getRecipes()) {
            if (r == null || !recMachine.isInputRecipeEqualTo(r, false)) continue;
            return true;
        }
        return false;
    }

    public int getProgress() {
        return (int)this.curProgress;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("buffer", (NBTBase)this.bufferListWrite());
        compound.func_74776_a("progress", this.curProgress);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bufferListRead(compound.func_74775_l("buffer"));
        this.curProgress = compound.func_74760_g("progress");
    }

    public NBTTagCompound bufferListWrite() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.bufferStacks.size(); ++i) {
            if (((ItemStack)this.bufferStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.bufferStacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        return nbt;
    }

    public void bufferListRead(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            this.bufferStacks.add((Object)new ItemStack(itemTags));
        }
    }
}

